#!/bin/sh

#Copyright (c) 2010 NTT DATA CORPORATION
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み 
export EXEC_PATH=${0%/*}

export HINEMOS_AGENT_HOME=/opt/hinemos_agent
export SYSLOG_CONF=/etc/syslog.conf
export INSTALL_LOG=${EXEC_PATH}/install.log
export VERSION=`cat ${EXEC_PATH}/hinemos_agent/_version`
export LANG=C

export PLATFORM=aix
export PLATFORM_NAME=AIX
export LOG_FILE_ENCODING=SJIS
export SYSLOG_RESTART="refresh -s syslogd"

echo "Install start : `date`" >> ${INSTALL_LOG}

#インストーラの実行
${EXEC_PATH}/install.sh | tee -a ${INSTALL_LOG}

echo "Install end : `date`" >> ${INSTALL_LOG}
echo "" >> ${INSTALL_LOG}

if [ -d ${HINEMOS_AGENT_HOME}/var/log ] ; then
	cp ${INSTALL_LOG} ${HINEMOS_AGENT_HOME}/var/log
fi

