/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import com.clustercontrol.sql.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SQL監視一覧テーブル定義情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetSqlListTableDefine {

    /**
     * SQL監視一覧のテーブル定義情報を返します。
     * 
     * @return SQL監視一覧テーブル定義情報
     */
    public static ArrayList get() {
    	
    	MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getSqlController();

        ArrayList tableDefine = null;
        
        try {
			tableDefine = sql.getSqlListTableDefine(Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		}

        return tableDefine;
    }
}