/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * HA構成時のログ重複情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="SyslogDuplicationInfo"
 *     jndi-name="SyslogDuplication"
 *     type="CMP"
 *     primkey-field="monitorId","facilityId","generationDate","messageOrg"
 *     schema="SyslogDuplicationInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_syslog_duplication_data"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM SyslogDuplicationInfo as a"
 *     signature="java.util.Collection findAll()"
 * 
 * @ejb.finder
 *     query="SELECT OBJECT(a) FROM SyslogDuplicationInfo as a WHERE a.generationDate < ?1"
 *     signature="java.util.Collection findOldRecode(java.sql.Timestamp generationDate)"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.SyslogDuplicationInfoPK"
 */
public abstract class SyslogDuplicationInfoBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * ログの重複情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param monitorId 監視項目ID
	 * @param facilityId ファシリティID
	 * @param generationDate 出力日時
	 * @param messageOrg オリジナルメッセージ
	 * @param multiId マルチID
	 * @param count カウンタ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 */
	public SyslogDuplicationInfoPK ejbCreate(
			String monitorId,
			String facilityId,
			Timestamp generationDate,
			String messageOrg,
			String multiId,
			Integer count
			) throws javax.ejb.CreateException {
		
		setMonitorId(monitorId);
		setFacilityId(facilityId);
		setGenerationDate(generationDate);
		setMessageOrg(messageOrg);
		setMultiId(multiId);
		setCount(count);
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();
	
	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * ファシリティIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public abstract String getFacilityId();
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public abstract void setFacilityId(String facilityId);
	
	/**
	 * 出力日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="generation_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 出力日時
	 */
	public abstract Timestamp getGenerationDate();
	
	/**
	 * 出力日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param generationDate 
	 */
	public abstract void setGenerationDate(Timestamp generationDate);
	
	/**
	 * オリジナルメッセージを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_org"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="text"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return オリジナルメッセージ
	 */
	public abstract String getMessageOrg();
	
	/**
	 * オリジナルメッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param messageOrg 
	 */
	public abstract void setMessageOrg(String messageOrg);	
	
	/**
	 * マルチIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="multi_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return マルチID
	 */
	public abstract String getMultiId();
	
	/**
	 * マルチIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param eventInhibitionFlg マルチID
	 */
	public abstract void setMultiId(String multiId);
	
	/**
	 * カウンタを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="count"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return カウンタ
	 */
	public abstract Integer getCount();
	
	/**
	 * カウンタを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param count カウンタ
	 */
	public abstract void setCount(Integer count);
}
