/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.CheckBoxImageConstant;
import com.clustercontrol.bean.CollectiveRunStatusConstant;
import com.clustercontrol.bean.CollectiveRunStatusImageConstant;
import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.EndStatusImageConstant;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityImageConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JobImageConstant;
import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ScheduleConstant;
import com.clustercontrol.bean.ScheduleOnOffImageConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.StatusImageConstant;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.util.Messages;

/**
 * CommonTableViewerクラス用のLabelProviderクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableTreeLabelProvider extends LabelProvider implements
        ICommonTableLabelProvider {
    protected CommonTableTreeViewer m_viewer;

    /**
     * コンストラクタ
     * 
     * アイコンイメージを取得
     * 
     * @param viewer
     * @since 1.0.0
     */
    public CommonTableTreeLabelProvider(CommonTableTreeViewer viewer) {
        m_viewer = viewer;
    }

    /**
     * カラム文字列取得処理
     * 
     * @since 1.0.0
     * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object,
     *      int)
     */
    public String getColumnText(Object element, int columnIndex) {
        ArrayList tableColumnList = m_viewer.getTableColumnList();

        CommonTableTreeItem item = (CommonTableTreeItem) element;
        Object value = null;
        if (item.getData() instanceof ArrayList) {
            value = item.getData().get(columnIndex);
        } else {
            return "";
        }

        TableColumnInfo tableColumn = (TableColumnInfo) tableColumnList
                .get(columnIndex);

        if (value == null) {
            return "";
        }

        if (tableColumn.getType() == TableColumnInfo.JOB) {
            //データタイプが「ジョブ」の処理
            return JobConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.STATE) {
            //データタイプが「状態」の処理
            return StatusConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CRUN_STATUS) {
            //データタイプが「一括制御状態」の処理
            return CollectiveRunStatusConstant.typeToString(((Number) value)
                    .intValue());
        } else if (tableColumn.getType() == TableColumnInfo.PRIORITY) {
            //データタイプが「重要度」の処理
            return PriorityConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.VALID) {
            //データタイプが「有効/無効」の処理
            return ValidConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.JUDGMENT_OBJECT) {
            //データタイプが「判定対象」の処理
            return JudgmentObjectConstant.typeToString(((Number) value)
                    .intValue());
        } else if (tableColumn.getType() == TableColumnInfo.WAIT_RULE_VALUE) {
            //データタイプが「開始条件値」の処理
            Class itemClass = value.getClass();

            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");

            if (itemClass == Date.class) {
                return formatter.format((Date) value);
            } else if (itemClass == String.class) {
                return String.valueOf(value);
            } else if (itemClass.getSuperclass() == Number.class) {
                return ((Number) value).toString();
            }
        } else if (tableColumn.getType() == TableColumnInfo.SCHEDULE) {
            //データタイプが「スケジュール」の処理
            Schedule schedule = (Schedule) value;

            String scheduleString = "";
            if (schedule.getType() == ScheduleConstant.TYPE_EVERY_YEAR) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_MONTH) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd'"
                        + Messages.getString("monthday") + "' HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_DAY) {
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_HOUR) {
                SimpleDateFormat formatter = new SimpleDateFormat("mm'"
                        + Messages.getString("minute") + "'");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = formatter
                            .format((Date) schedule.getDate());
                }
            } else if (schedule.getType() == ScheduleConstant.TYPE_EVERY_WEEK) {
                SimpleDateFormat formatter = new SimpleDateFormat(" HH:mm");
                if (schedule.getDate() instanceof Date) {
                    scheduleString = DayOfWeekConstant.typeToString(schedule
                            .getDayOfWeek())
                            + formatter.format((Date) schedule.getDate());
                }
            }
            return scheduleString;
        } else if (tableColumn.getType() == TableColumnInfo.CONFIRM) {
            //データタイプが「確認/未確認」の処理
            return ConfirmConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.WAIT_RULE) {
            //データタイプが「待ち条件」の処理
            return YesNoConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.PROCESS) {
            //データタイプが「処理」の処理
            return ProcessConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.END_STATUS) {
            //データタイプが「終了状態」の処理
            return EndStatusConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CHECKBOX) {
            //データタイプが「チェックボックス」の処理
            return "";
        } else if (tableColumn.getType() == TableColumnInfo.DAY_OF_WEEK) {
            //データタイプが「曜日」の処理
            return DayOfWeekConstant.typeToString(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.SCHEDULE_ON_OFF) {
            //データタイプが「予定」の処理
            return "";
        } else if (tableColumn.getType() == TableColumnInfo.JOB_PARAM_TYPE) {
            //データタイプが「ジョブパラメータ種別」の処理
        	return JobParamTypeConstant.typeToString(((Number) value).intValue());
        } else {
            //上記以外のデータタイプの処理
            Class itemClass = value.getClass();

            if (itemClass == String.class) {
                return String.valueOf(value);
            } else if (itemClass == Date.class) {
                return DateFormat.getDateTimeInstance().format((Date) value);
            } else if (itemClass == Time.class) {
                SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
                return formatter.format((Time) value);
            } else if (itemClass.getSuperclass() == Number.class) {
                return ((Number) value).toString();
            }
        }
        return "";
    }

    /**
     * カラムイメージ(アイコン)取得処理
     * 
     * @since 1.0.0
     * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object,
     *      int)
     */
    public Image getColumnImage(Object element, int columnIndex) {
        ArrayList tableColumnList = m_viewer.getTableColumnList();

        CommonTableTreeItem item = (CommonTableTreeItem) element;
        Object value = null;
        if (item.getData() instanceof ArrayList) {
            value = item.getData().get(columnIndex);
        } else {
            return null;
        }

        TableColumnInfo tableColumn = (TableColumnInfo) tableColumnList
                .get(columnIndex);

        if (value == null) {
            return null;
        }

        if (tableColumn.getType() == TableColumnInfo.JOB) {
            //データタイプが「ジョブ」の処理
            return JobImageConstant.typeToImage(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.FACILITY) {
            //データタイプが「ファシリティ」の処理
            Pattern p = Pattern.compile(".*>");
            Matcher m = p.matcher((String) value);
            if (m.matches()) {
                return FacilityImageConstant
                        .typeToImage(FacilityConstant.TYPE_SCOPE);
            } else {
                return FacilityImageConstant
                        .typeToImage(FacilityConstant.TYPE_NODE);
            }
        } else if (tableColumn.getType() == TableColumnInfo.STATE) {
            //データタイプが「状態」の処理
            return StatusImageConstant.typeToImage(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CRUN_STATUS) {
            //データタイプが「一括制御状態」の処理
            return CollectiveRunStatusImageConstant
                    .typeToImage(((Number) value).intValue());
        } else if (tableColumn.getType() == TableColumnInfo.END_STATUS) {
            //データタイプが「終了状態」の処理
            return EndStatusImageConstant.typeToImage(((Number) value)
                    .intValue());
        } else if (tableColumn.getType() == TableColumnInfo.CHECKBOX) {
            //データタイプが「チェックボックス」の処理
            return CheckBoxImageConstant.typeToImage(((Boolean) value)
                    .booleanValue());
        } else if (tableColumn.getType() == TableColumnInfo.SCHEDULE_ON_OFF) {
            //データタイプが「予定」の処理
            return ScheduleOnOffImageConstant.dateToImage(((Date) value));
        }

        return null;
    }

    /**
     * カラムカラー取得処理
     * 
     * @since 1.0.0
     * @see com.clustercontrol.composite.ICommonTableLabelProvider#getColumnColor(java.lang.Object,
     *      int)
     */
    public Color getColumnColor(Object element, int columnIndex) {
        return null;
    }
}