/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.audit.log;

import java.util.ArrayList;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.util.PropertyUtil;

/**
 * VM管理機能 操作ログ出力クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 * @see com.clustercontrol.audit.log.Logger
 */
@Aspect (scope= Scope.PER_VM)
public class VM extends Logger {

	/**
	 * VM操作実行時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.vm.ejb.session.VmControllerBean->run(..))")
	public Object runVmAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[VM] Run VM";
		StringBuffer msg = new StringBuffer();
		
		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof String && args[1] instanceof String){
			String commandId = (String)args[0];
			String facilityId = (String)args[1];
			msg.append(", CommandId=");
			msg.append(commandId);
			msg.append(", FacilityId=");
			msg.append(facilityId);
		}

		outputLogMessage(title, msg.toString(), invocation);
		return result;
	}
	
	/**
	 * 仮想ノード割当情報取得時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(* com.clustercontrol.vm.ejb.session.VmControllerBean->getVmNodeInfoList(..))")
	public Object getVmNodeInfoAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[VM] Get Node";
		StringBuffer msg = new StringBuffer();
		
		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof Property){
			Property property = (Property)args[0];
			ArrayList list = PropertyUtil.getProperty(property, NodeProperty.FACILITY_ID);
			String facilityId = ((Property)list.get(0)).getValue().toString();

			msg.append(", FacilityId=");
			msg.append(facilityId);
		}

		outputLogMessage(title, msg.toString(), invocation);
		return result;
	}
	
	/**
	 * 仮想ノード割当情報更新時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.vm.ejb.session.VmControllerBean->updateVmNodeAllocation(..))")
	public Object updateVmNodeAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[VM] Update Assign";

		outputLogMessage(title, "", invocation);

		return result;
	}
}
