/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.audit.log;



import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.audit.log.util.LogMessageComponent;
import com.clustercontrol.audit.log.util.LogMessageParameter;
import com.clustercontrol.audit.log.util.MethodName;
import com.clustercontrol.audit.log.util.UserName;


/**
 * 操作ログ出力ベースクラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 */
public abstract class Logger {
	protected static Log log = LogFactory.getLog("hinemos.audit.log");

	/**
	 * ログ出力
	 * 
	 * @param title タイトル
	 * @param argMessage 引数文字列
	 * @param invocation MethodInvocationオブジェクト
	 * @throws Exception
	 */
	public void outputLogMessage(
			String title, 
			String argMessage, 
			MethodInvocation invocation) throws Exception {
		StringBuffer msg = new StringBuffer();
		msg.append(title);

		LogMessageParameter param = new LogMessageParameter();
		param.setValue(invocation);
		LogMessageComponent component = new MethodName(new UserName(param));
		component.getLogMessage();
		msg.append(component.getLogMessage());

		msg.append(argMessage);

		log.debug(msg.toString());
	}
}
