/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.audit.log;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.logtransfer.bean.LogTransferInfo;

/**
 * ログ転送機能 操作ログ出力クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 * @see com.clustercontrol.audit.log.Logger
 */
@Aspect (scope= Scope.PER_VM)
public class LogTransfer extends Logger {

	/**
	 * ログ転送設定追加時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.logtransfer.ejb.session.LogTransferControllerBean->addLogTransfer(..))")
	public Object addLogTransferAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[LogTransfer] Add";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof LogTransferInfo){
			LogTransferInfo info = (LogTransferInfo)args[0];
			msg.append(", TransferID=");
			msg.append(info.getTransferId());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * ログ転送設定変更時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.logtransfer.ejb.session.LogTransferControllerBean->modifyLogTransfer(..))")
	public Object modifyLogTransferAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[LogTransfer] Change";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof LogTransferInfo){
			LogTransferInfo info = (LogTransferInfo)args[0];
			msg.append(", TransferID=");
			msg.append(info.getTransferId());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * ログ転送設定削除時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.logtransfer.ejb.session.LogTransferControllerBean->deleteLogTransfer(..))")
	public Object deleteLogTransferAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[LogTransfer] Delete";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof String){
			msg.append(", TransferID=");
			msg.append((String)args[0]);
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}
}
