/*
 
Copyright (C) 2007, 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

//
// Hinemos SNMP gG[WFgDLL for Hinemos ver. 2.4.0
//

// -------------------------------------------------------------
//    CN[ht@C
// -------------------------------------------------------------
#include <windows.h>
#include <stdio.h>
#include <snmp.h>
#include <winbase.h>
#include "HinemosSNMPExtAgent.h"

#include <bitset>
#include <string>
#include <map>
#include <vector>
#include <iostream>

using namespace std;

// -------------------------------------------------------------
//    ֐錾
// -------------------------------------------------------------
UINT ResolveVarBind( SnmpVarBind *, UINT );
UINT OperateVarBind( UINT, int, SnmpVarBind * );

VOID PostEvtLog(WORD, LPTSTR, char *, DWORD );
VOID GetMibData(MIB_ENTRY *);

AsnCounter GetCpuRawUser(void);
AsnCounter GetCpuRawNice(void);
AsnCounter GetCpuRawSystem(void);
AsnCounter GetCpuRawIdle(void);
AsnCounter GetCpuRawWait(void);
AsnCounter GetCpuRawKernel(void);
AsnCounter GetCpuRawInterrupt(void);

AsnCounter GetRawInterrupts(void);
AsnCounter GetRawContexts(void);

AsnInteger GetMemTotalFree(void);
AsnInteger GetMemTotalReal(void);
AsnInteger GetMemTotalSwap(void);
AsnInteger GetMemAvailReal(void);
AsnInteger GetMemAvailSwap(void);

AsnInteger GetMemBuffer(void);
AsnInteger GetMemCached(void);


AsnInteger GetSsSwapIn(void);
AsnInteger GetSsSwapOut(void);

AsnInteger GetLaLoadInt1(void);
AsnInteger GetLaLoadInt2(void);
AsnInteger GetLaLoadInt3(void);

AsnCounter GetDiskIOIndex(char *);
char *	   GetDiskIODevice(char *);
AsnCounter GetDiskIORead(char *);
AsnCounter GetDiskIOWrite(char *);
AsnCounter GetDiskIOReads(char *);
AsnCounter GetDiskIOWrites(char *);

VOID CreateDataStructure(void);
VOID SetEntry(UINT, UINT *, AsnInteger32 *, UINT, UINT, int);
VOID SetEntry(UINT, UINT *, AsnCounter32 *, UINT, UINT, int);

int writeLog(char *	);

// for debug
char *g_szAbout = NULL;
//


/* DLL̏ */
BOOL WINAPI DllMain(HANDLE hDll, DWORD  dwReason, LPVOID lpReserved )
{

    switch( dwReason ){
        case DLL_PROCESS_ATTACH:
        case DLL_PROCESS_DETACH:
        case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
        default:
            break;
    }

    return TRUE;
}

/* DLL[hꂽۂɁASNMP ServiceďoAsB */
BOOL WINAPI SnmpExtensionInit(IN  DWORD dwTimeZeroReference,
							    OUT HANDLE *hPollForTrapEvent,
								OUT AsnObjectIdentifier *supportedView )
{

	// VXeCxg쐬p̃p[^
	SECURITY_ATTRIBUTES	sa;
	SECURITY_DESCRIPTOR	sd;
	sa.nLength = sizeof( SECURITY_ATTRIBUTES );
	sa.bInheritHandle = TRUE;
	sa.lpSecurityDescriptor = &sd;

    // ZLeB񏉊
	if( !InitializeSecurityDescriptor( &sd, SECURITY_DESCRIPTOR_REVISION )){
		PostEvtLog( EVENTLOG_ERROR_TYPE, "ExtensionInit", "ZLeBG[", 0 );
		return FALSE;
	}
    // ZLeBݒ
	if( !SetSecurityDescriptorDacl( &sd,TRUE, (PACL)NULL, FALSE )){
		PostEvtLog( EVENTLOG_ERROR_TYPE, "ExtensionInit", "ZLeBݒG[", 0 );
		return FALSE;
	}
    // Trap֐N邽߂̃VXeCxg쐬
	*hPollForTrapEvent = CreateEvent(&sa, FALSE, FALSE, TRAP_EVENT_NAME );
	if((*hPollForTrapEvent) == NULL ){
		PostEvtLog( EVENTLOG_ERROR_TYPE, "ExtensionInit", "CxgG[", 0 );
		return FALSE;
    }
    // Ăьw̎p[^ۑ
    dwTimeZero = dwTimeZeroReference;

    // {DLL̏ΏۂƂȂMIBOIDݒ
    *supportedView = MIB_OidPrefix;

	// Trap֐N邽߂̃VXeCxgۑ

//	TrapɂĂ͎Ȃ
//	hSimulateTrap = *hPollForTrapEvent;

	//Kvȃf[^\쐬
	CreateDataStructure();

	// ""EventLogo
	PostEvtLog( EVENTLOG_INFORMATION_TYPE, "ExtensionInit", "", 0 );
    return TRUE;
}


/*
 * {DLL̏ΏۂƂȂMIBɑ΂ASNMP}l[WGet/GetNext/SetvꂽۂɁA
 * SNMP ServiceďovɉsB
 */
BOOL WINAPI SnmpExtensionQuery(IN BYTE requestType, IN OUT SnmpVarBindList *variableBindings,
							   OUT AsnInteger32 *errorStatus, OUT AsnInteger32 *errorIndex )
{
    static ULONG requestCount = 0;
    UINT    i;

    // ϐ̐JԂ
    for( i=0; i<(variableBindings->len); i++ ){

        // NGXgƕϐɑ΂鏈
        *errorStatus = ResolveVarBind( &variableBindings->list[i], requestType );

        // G[̏ꍇ̏
        if( *errorStatus != SNMP_ERRORSTATUS_NOERROR ){
            *errorIndex = i + 1;
            break;
        }
    }
    return( SNMPAPI_NOERROR );
}

/*
 * NGXĝOIDɑ΂āAX|XԂOIDݒ肷
 */
UINT ResolveVarBind(IN OUT SnmpVarBind *VarBind, IN UINT PduAction )
{

    UINT                 nResult;
	int                  index = -1;
	bool                 noSuchName = true;

	UINT size = mib_entries.size();

	//GETNEXTł̖₢킹ł́A
	//VarBindɁAԂlƁAɎQƂOIDZbgreturnB
	if (PduAction == SNMP_PDU_GETNEXT) {
		
		//o^ĂMIB̈ꗗƁAOIDr
		for (UINT i = 0; i < size ; i++) {
			int compResult = SnmpUtilOidCmp(&VarBind->name, &mib_entries[i].Oid);

			// ₢킹̂OIDƃXg}b`Ȃꍇ́A
			// [DTŁA₢킹OID < XgOIDƂȂŏOIDɂāA\l擾B
			if (compResult < 0) {

				if( PduAction != SNMP_PDU_GETNEXT ){
					return( SNMP_ERRORSTATUS_NOSUCHNAME );
				}

				noSuchName = false;

				// ̌ʁAl擾OID
				PduAction = SNMP_PDU_GET;
				index = i;

				// ϐUAOIDݒ
				SnmpUtilOidFree( &VarBind->name );
				SnmpUtilOidCpy( &VarBind->name, &mib_entries[i].Oid );

				break;

			// ₢킹̂OID݂ꍇ
			} else if (compResult == 0) {
				PduAction = SNMP_PDU_GET;
				index = i;
				noSuchName = false;
				SnmpUtilOidFree( &VarBind->name );
				
				// Xg̖ł΁AOIDNULLƂĕԂ
				if (i != size - 1){
					//OID݂ꍇ͂ݒ肷
					index++;
					SnmpUtilOidCpy( &VarBind->name, &mib_entries[index].Oid );
					break;
				}
			}
		}

	// GETł̖₢킹ł́AXgāA݂琫\l擾B
	} else if (PduAction == SNMP_PDU_GET) {

		//mapoRŏ擾
		string requestOid(SnmpUtilOidToA(&VarBind->name));
		map<string, int>::iterator itr = oid_index_map.find(requestOid);

		//݂tO؂ւ
		if (itr != oid_index_map.end()) {
			noSuchName = false;
			index = (*itr).second;
		}
	}

	if (noSuchName) {
        return( SNMP_ERRORSTATUS_NOSUCHNAME );
    }

    // ֐Ăяo
    nResult = OperateVarBind( PduAction, index, VarBind );

    return( nResult );
}

/*
 * NGXgɑ΂Ԃlݒ肷B
 */
UINT OperateVarBind(IN UINT Action, IN int index, IN SnmpVarBind *VarBind )
{
//	UINT ErrStat;

	UINT next_index = index + 1;
	MIB_ENTRY *MibPtr = &mib_entries[index];
//	MIB_ENTRY *NextMibPtr = NULL;

	switch( Action ){
/*
	case SNMP_PDU_GETNEXT:
		
		//OIDZbg
		if (index < oid_index_map.size() - 1) {
			 NextMibPtr = &mib_entries[next_index];

		//XgŌOIDꍇ
		} else if (index == oid_index_map.size() - 1) {
			 NextMibPtr = NULL;

		// YOIDȂꍇAreturn
		} else {
			return( SNMP_ERRORSTATUS_NOSUCHNAME );
		}

		//ɌׂOIDZbg
        SnmpUtilOidFree( &VarBind->name );
		SnmpUtilOidCpy( &VarBind->name, &NextMibPtr->Oid );

	    // ֐Ăяo (3.2) ċAďo
        ErrStat = OperateVarBind( SNMP_PDU_GET, index, VarBind );
        return( ErrStat );
*/
	case SNMP_PDU_GET:
        if(( MibPtr->Access != MIB_ACCESS_READONLY  ) &&
           ( MibPtr->Access != MIB_ACCESS_READWRITE )){
            return( SNMP_ERRORSTATUS_NOSUCHNAME );
	    }

		//\[X擾
		GetMibData(MibPtr);

        VarBind->value.asnType = MibPtr->Type;
        switch( VarBind->value.asnType ){
            case ASN_RFC1155_COUNTER:
            case ASN_RFC1155_GAUGE:
            case ASN_INTEGER:
                VarBind->value.asnValue.number = *(AsnInteger *)(MibPtr->Storage);
                break;

            case ASN_OCTETSTRING:
				
				// octetZbg
				//VarBind->value.asnValue.string.length = ((AsnOctetString *)(LPSTR)MibPtr->Storage)->length;
				//VarBind->value.asnValue.string.length = strlen((LPSTR)MibPtr->Storage);
				VarBind->value.asnValue.string.length = 1;

				// m
				VarBind->value.asnValue.string.stream = (unsigned char *)SnmpUtilMemAlloc( VarBind->value.asnValue.string.length * sizeof(char) );

				if( VarBind->value.asnValue.string.stream == NULL ){
					return( SNMP_ERRORSTATUS_GENERR );
				}

				// |C^̏Rs[
				memcpy( VarBind->value.asnValue.string.stream, (LPSTR)MibPtr->Storage, VarBind->value.asnValue.string.length);

				VarBind->value.asnValue.string.dynamic = TRUE;
				
                break;

            default:
                return( SNMP_ERRORSTATUS_GENERR );
        }
        break;

/*
	case SNMP_PDU_SET:
        if( MibPtr->Access != MIB_ACCESS_READWRITE ){
            return( SNMP_ERRORSTATUS_NOSUCHNAME );
        }

        if( MibPtr->Type != VarBind->value.asnType ){
            return( SNMP_ERRORSTATUS_BADVALUE );
        }

        switch( VarBind->value.asnType ){
            case ASN_RFC1155_COUNTER:
            case ASN_RFC1155_GAUGE:
            case ASN_INTEGER:
                if(( VarBind->value.asnValue.number != MIB_CQPUB_ON  ) &&
                   ( VarBind->value.asnValue.number != MIB_CQPUB_OFF )){
                    return( SNMP_ERRORSTATUS_BADVALUE );
                }
                *(AsnInteger *)(MibPtr->Storage) = 
                    VarBind->value.asnValue.number;
                break;

            case ASN_OCTETSTRING:
                memcpy( (LPSTR)MibPtr->Storage,
                    VarBind->value.asnValue.string.stream,
                    VarBind->value.asnValue.string.length );
                wkLen = VarBind->value.asnValue.string.length;
                ((LPSTR)MibPtr->Storage)[wkLen] = '\0';
                break;

            default:
                return( SNMP_ERRORSTATUS_GENERR );
        }
        break;
*/
    default:
        return( SNMP_ERRORSTATUS_GENERR );
    }
    return( SNMP_ERRORSTATUS_NOERROR );
}

/* WindowsCxgo͗p֐ */
VOID PostEvtLog( WORD logType, LPTSTR ModuleName, char *SendMsg, DWORD val )
{
    CHAR    Msg[512];			// bZ[W
    HANDLE  hEventLog;          // CxgEÕnh
	LPCSTR  Strings[2];         // CxgEOւ̋Lڕ
    WORD    EventCat = 0;       // CxgEJeS
    DWORD   EventID = 1000;     // Cxgʎq
    char    tmpbf[256];
  
    // CxgEOɏL^
	hEventLog = RegisterEventSource(NULL, "Hinemos SNMP Ext Agent");

    if( hEventLog != NULL ){
		strcpy( Msg, "Hinemos SNMP Ext Agent : ");
        sprintf( tmpbf,"%s %s(%d)", ModuleName, SendMsg, val );
	    strcat( Msg, tmpbf );
		Strings[0] = Msg;

		ReportEvent( hEventLog, logType, EventCat, EventID, NULL, 1, 0, Strings, NULL );
		DeregisterEventSource( hEventLog );
    }
	return;
}



/*
 * Cuւ̃ANZX֐
 * OIDɊÂēK؂Ȋ֐ĂтAZbg
 */
void GetMibData(IN OUT MIB_ENTRY *mib)
{

	//U蕪WbN
	int id = mib->ResourceId;

	//diskIOp
	char drive;
	string oid_string(SnmpUtilOidToA(&mib->Oid));
	AsnCounter value;
	char *device;

	map<string, char>::iterator itr1;
	map<string, AsnCounter>::iterator itr2;
	map<string, char>::iterator itr3;

	switch(id){
		case MIB_DISK_IO_DEVICE:
			//hCu̎擾
			itr1 = oid_drivestring.find(oid_string);
			//݂tO؂ւ
			if (&itr1 != NULL) {
				drive = (*itr1).second;
			}
			itr3 = MIB_dat_diskIODevice.find(oid_string);
			if (&itr3 != NULL) {
				device = &(*itr3).second;
			}
			break;
	}


	switch(id){
		case MIB_DISK_IO_READ:
		case MIB_DISK_IO_WRITE:
		case MIB_DISK_IO_READS:
		case MIB_DISK_IO_WRITES:
			//hCu̎擾
			itr1 = oid_drivestring.find(oid_string);
			//݂tO؂ւ
			if (&itr1 != NULL) {
				drive = (*itr1).second;
			}

			//WlZbgϐ擾
			itr2 = MIB_dat_diskIO.find(oid_string);
			//݂tO؂ւ
			if (&itr2 != NULL) {
				value = (*itr2).second;
			}
			break;
	}

	
	switch(id){
		//Ԃlɂ͒lւ̃|C^ݒ肷邽߁A
		//l̕ێϐ̓O[oϐłKv
		//߂lāA|C^mibɃZbg

		case MIB_CPU_RAW_USER:
			MIB_dat_ssCpuRawUser = GetCpuRawUser();
			mib->Storage = &MIB_dat_ssCpuRawUser;
			break;

		case MIB_CPU_RAW_NICE:
			break;

		case MIB_CPU_RAW_SYSTEM:
			MIB_dat_ssCpuRawSystem = GetCpuRawSystem();
			mib->Storage = &MIB_dat_ssCpuRawSystem;
			break;

		case MIB_CPU_RAW_IDLE:
			MIB_dat_ssCpuRawIdle = GetCpuRawIdle();
			mib->Storage = &MIB_dat_ssCpuRawIdle;
			break;

		case MIB_CPU_RAW_WAIT:
			MIB_dat_ssCpuRawWait = GetCpuRawWait();
			mib->Storage = &MIB_dat_ssCpuRawWait;
			break;

		case MIB_CPU_RAW_KERNEL:
			MIB_dat_ssCpuRawKernel = GetCpuRawKernel();
			mib->Storage = &MIB_dat_ssCpuRawKernel;
			break;

		case MIB_CPU_RAW_INTERRUPT:
			MIB_dat_ssRawInterrupts = GetCpuRawInterrupt();
			mib->Storage = &MIB_dat_ssRawInterrupts;
			break;

		case MIB_RAW_INTERRUPTS:
			MIB_dat_ssCpuRawInterrupt = GetRawInterrupts();
			mib->Storage = &MIB_dat_ssCpuRawInterrupt;
			break;

		case MIB_RAW_CONTEXTS:
			MIB_dat_ssRawContexts = GetRawContexts();
			mib->Storage = &MIB_dat_ssRawContexts;
			break;

		case MIB_MEM_TOTAL_REAL:
			MIB_dat_memTotalReal = GetMemTotalReal();
			mib->Storage = &MIB_dat_memTotalReal;
			break;

		case MIB_MEM_TOTAL_SWAP:
			MIB_dat_memTotalSwap = GetMemTotalSwap();
			mib->Storage = &MIB_dat_memTotalSwap;
			break;

		case MIB_MEM_AVAIL_REAL:
			MIB_dat_memAvailReal = GetMemAvailReal();
			mib->Storage = &MIB_dat_memAvailReal;
			break;

		case MIB_MEM_AVAIL_SWAP:
			MIB_dat_memAvailSwap = GetMemAvailSwap();
			mib->Storage = &MIB_dat_memAvailSwap;
			break;

		case MIB_MEM_TOTAL_FREE:
			MIB_dat_memTotalFree = GetMemTotalFree();
			mib->Storage = &MIB_dat_memTotalFree;
			break;

		case MIB_MEM_BUFFER:
			MIB_dat_memBuffer = GetMemBuffer();
			mib->Storage = &MIB_dat_memBuffer;
			break;

		case MIB_MEM_CACHED:
			MIB_dat_memCached = GetMemCached();
			mib->Storage = &MIB_dat_memCached;
			break;

		case MIB_SS_SWAP_IN:
			MIB_dat_ssSwapIn = GetSsSwapIn();
			mib->Storage = &MIB_dat_ssSwapIn;
			break;

		case MIB_SS_SWAP_OUT:
			MIB_dat_ssSwapOut = GetSsSwapOut();
			mib->Storage = &MIB_dat_ssSwapOut;
			break;

		case MIB_DISK_IO_INDEX:
			value = GetDiskIOIndex(&drive);
			mib->Storage = &value;
			break;

		case MIB_DISK_IO_DEVICE:
			device = GetDiskIODevice(&drive);
			mib->Storage = device;
			break;

		case MIB_DISK_IO_READ:
			value = GetDiskIORead(&drive);
			mib->Storage = &value;
			break;

		case MIB_DISK_IO_WRITE:
			value = GetDiskIOWrite(&drive);
			mib->Storage = &value;
			break;

		case MIB_DISK_IO_READS:
			value = GetDiskIOReads(&drive);
			mib->Storage = &value;
			break;

		case MIB_DISK_IO_WRITES:
			value = GetDiskIOWrites(&drive);
			mib->Storage = &value;
			break;

	}

}


void SetEntry(UINT idLength, UINT *ids, AsnInteger32 *storage, UINT access, UINT resourceId, int index) {

	MIB_ENTRY entry;
	AsnObjectIdentifier  TempOid;

	entry.Oid.idLength = idLength;
	entry.Oid.ids = (UINT *)ids;
	entry.Storage = storage;
	entry.Type = ASN_INTEGER;
	entry.Access = access;
	entry.ResourceId = resourceId;

	SnmpUtilOidFree( &TempOid );
	SnmpUtilOidCpy( &TempOid, &entry.Oid );
	string oidstring(SnmpUtilOidToA(&TempOid));
	oid_index_map.insert(map<string, int>::value_type(oidstring, index));
	mib_entries.push_back(entry);

}

void SetEntry(UINT idLength, UINT *ids, AsnCounter32 *storage, UINT access, UINT resourceId, int index) {

	MIB_ENTRY entry;
	AsnObjectIdentifier  TempOid;

	entry.Oid.idLength = idLength;
	entry.Oid.ids = (UINT *)ids;
	entry.Storage = storage;
	entry.Type = ASN_RFC1155_COUNTER;
	entry.Access = access;
	entry.ResourceId = resourceId;

	SnmpUtilOidFree( &TempOid );
	SnmpUtilOidCpy( &TempOid, &entry.Oid );
	string oidstring(SnmpUtilOidToA(&TempOid));
	oid_index_map.insert(map<string, int>::value_type(oidstring, index));
	mib_entries.push_back(entry);

}

void SetEntry(UINT idLength, UINT *ids, char *storage, UINT access, UINT resourceId, int index) {

	MIB_ENTRY entry;
	AsnObjectIdentifier  TempOid;

	entry.Oid.idLength = idLength;
	entry.Oid.ids = (UINT *)ids;
	entry.Storage = storage;
	entry.Type = ASN_OCTETSTRING;
	entry.Access = access;
	entry.ResourceId = resourceId;

	SnmpUtilOidFree( &TempOid );
	SnmpUtilOidCpy( &TempOid, &entry.Oid );
	string oidstring(SnmpUtilOidToA(&TempOid));
	oid_index_map.insert(map<string, int>::value_type(oidstring, index));
	mib_entries.push_back(entry);

}


/*
 * ɃR[Af[^\邽߂̊֐B
 */
void CreateDataStructure()
{
	int index = 0;
	string oidstring;

	//OID̑召֌WlāAmibentry}邱
	
	/**  **/
	SetEntry(OID_SIZEOF(MIB_memTotalSwap), MIB_memTotalSwap, &MIB_dat_memTotalSwap,
			MIB_ACCESS_READONLY, MIB_MEM_TOTAL_SWAP, index++);

	SetEntry(OID_SIZEOF(MIB_memAvailSwap), MIB_memAvailSwap, &MIB_dat_memAvailSwap,
			MIB_ACCESS_READONLY, MIB_MEM_AVAIL_SWAP, index++);

	SetEntry(OID_SIZEOF(MIB_memTotalReal), MIB_memTotalReal, &MIB_dat_memTotalReal,
			MIB_ACCESS_READONLY, MIB_MEM_TOTAL_REAL, index++);

	SetEntry(OID_SIZEOF(MIB_memAvailReal), MIB_memAvailReal, &MIB_dat_memAvailReal,
			MIB_ACCESS_READONLY, MIB_MEM_AVAIL_REAL, index++);

	SetEntry(OID_SIZEOF(MIB_memTotalFree), MIB_memTotalFree, &MIB_dat_memTotalFree,
			MIB_ACCESS_READONLY, MIB_MEM_TOTAL_FREE, index++);


	SetEntry(OID_SIZEOF(MIB_memBuffer), MIB_memBuffer, &MIB_dat_memBuffer,
			MIB_ACCESS_READONLY, MIB_MEM_BUFFER, index++);

	SetEntry(OID_SIZEOF(MIB_memCached), MIB_memCached, &MIB_dat_memCached,
			MIB_ACCESS_READONLY, MIB_MEM_CACHED, index++);

	/** [hAx[W **/

	/******************************/

	/******************************/


	/** XbvC^AEg **/
	/******************************/
	SetEntry(OID_SIZEOF(MIB_ssSwapIn), MIB_ssSwapIn, &MIB_dat_ssSwapIn,
			MIB_ACCESS_READONLY, MIB_SS_SWAP_IN, index++);

	SetEntry(OID_SIZEOF(MIB_ssSwapOut), MIB_ssSwapOut, &MIB_dat_ssSwapOut,
			MIB_ACCESS_READONLY, MIB_SS_SWAP_OUT, index++);
	/******************************/

	
	/** CPUgp **/
	SetEntry(OID_SIZEOF(MIB_ssCpuRawUser), MIB_ssCpuRawUser, &MIB_dat_ssCpuRawUser,
			MIB_ACCESS_READONLY, MIB_CPU_RAW_USER, index++);

	SetEntry(OID_SIZEOF(MIB_ssCpuRawNice), MIB_ssCpuRawNice, &MIB_dat_ssCpuRawNice,
			MIB_ACCESS_READONLY, MIB_CPU_RAW_NICE, index++);

	SetEntry(OID_SIZEOF(MIB_ssCpuRawSystem), MIB_ssCpuRawSystem, &MIB_dat_ssCpuRawSystem,
			MIB_ACCESS_READONLY, MIB_CPU_RAW_SYSTEM, index++);

	SetEntry(OID_SIZEOF(MIB_ssCpuRawIdle), MIB_ssCpuRawIdle, &MIB_dat_ssCpuRawIdle,
			MIB_ACCESS_READONLY, MIB_CPU_RAW_IDLE, index++);

	SetEntry(OID_SIZEOF(MIB_ssCpuRawWait), MIB_ssCpuRawWait, &MIB_dat_ssCpuRawWait,
			MIB_ACCESS_READONLY, MIB_CPU_RAW_WAIT, index++);


	SetEntry(OID_SIZEOF(MIB_ssCpuRawKernel), MIB_ssCpuRawKernel, &MIB_dat_ssCpuRawKernel,
			MIB_ACCESS_READONLY, MIB_CPU_RAW_KERNEL, index++);

	SetEntry(OID_SIZEOF(MIB_ssCpuRawInterrupt), MIB_ssCpuRawInterrupt, &MIB_dat_ssCpuRawInterrupt,
			MIB_ACCESS_READONLY, MIB_CPU_RAW_INTERRUPT, index++);


	SetEntry(OID_SIZEOF(MIB_ssRawInterrupts), MIB_ssRawInterrupts, &MIB_dat_ssRawInterrupts,
			MIB_ACCESS_READONLY, MIB_RAW_INTERRUPTS, index++);

	SetEntry(OID_SIZEOF(MIB_ssRawContexts), MIB_ssRawContexts, &MIB_dat_ssRawContexts,
			MIB_ACCESS_READONLY, MIB_RAW_CONTEXTS, index++);


	/** fBXN **/

	//LȃhCuꗗ擾iAt@xbgPƂj
	char buf[1000] = {0};
	vector<char> drives;
	DWORD buf_size = 1000;
	DWORD cnt= 0;
	int drive_num = 0;

	// 26̃rbgŃhCu擾
	const int MAX_DRIVE_NUM = 26;
	DWORD mask = GetLogicalDrives();
	bitset<MAX_DRIVE_NUM> bit_drives(mask);

	AsnObjectIdentifier temp_oid;
	string key;
	AsnCounter *MIB_dat;
	char *MIB_dat_String;
	map<string, AsnCounter>::iterator itr;
	map<string, char>::iterator itr_diskIODevice;


	//diskIODevice
	for (int i = 0; i < MAX_DRIVE_NUM; i++) {
		if (bit_drives.at(i)) {
			//hCuɊÂāAOID̖ݒ肷B
			char drive_char = 'A' + i;

			//OIDƃhCũ}bv
			temp_oid.idLength = MIB_DISK_IO_OID_LENGTH;
			temp_oid.ids = &MIB_diskIODevicePtr[MIB_DISK_IO_OID_LENGTH * i];
			key = (string)(SnmpUtilOidToA(&temp_oid));
			oid_drivestring.insert(map<string, char>::value_type(key, drive_char));

			//OIDƎWli[p̕ϐ
			MIB_dat_diskIODevice.insert(map<string, char>::value_type(key, 0));
			itr_diskIODevice = MIB_dat_diskIODevice.find(key);
			if (itr_diskIODevice != MIB_dat_diskIODevice.end()) {
				MIB_dat_String = &(*itr_diskIODevice).second;
			}

			SetEntry(MIB_DISK_IO_OID_LENGTH, &MIB_diskIODevicePtr[MIB_DISK_IO_OID_LENGTH * i], MIB_dat_String,
					MIB_ACCESS_READONLY, MIB_DISK_IO_DEVICE, index++);
		}
	}

	//diskIORead
	for (int i = 0; i < MAX_DRIVE_NUM; i++) {
		if (bit_drives.at(i)) {
			//hCuɊÂāAOID̖ݒ肷B
			char drive_char = 'A' + i;

			//OIDƃhCũ}bv
			temp_oid.idLength = MIB_DISK_IO_OID_LENGTH;
			temp_oid.ids = &MIB_diskIOReadPtr[MIB_DISK_IO_OID_LENGTH * i];
			key = (string)(SnmpUtilOidToA(&temp_oid));
			oid_drivestring.insert(map<string, char>::value_type(key, drive_char));
			//OIDƎWli[p̕ϐ
			MIB_dat_diskIO.insert(map<string, AsnCounter>::value_type(key, 0));
			itr = MIB_dat_diskIO.find(key);
			if (itr != MIB_dat_diskIO.end()) {
				MIB_dat = &(*itr).second;
			}
			//Gg̍쐬a
			SetEntry(MIB_DISK_IO_OID_LENGTH, &MIB_diskIOReadPtr[MIB_DISK_IO_OID_LENGTH * i], MIB_dat,
					MIB_ACCESS_READONLY, MIB_DISK_IO_READ, index++);
		}
	}


	//diskIOWrite
	for (int i = 0; i < MAX_DRIVE_NUM; i++) {
		if (bit_drives.at(i)) {
			//hCuɊÂāAOID̖ݒ肷B
			char drive_char = 'A' + i;

			//OIDƃhCũ}bv
			temp_oid.idLength = MIB_DISK_IO_OID_LENGTH;
			temp_oid.ids = &MIB_diskIOWritePtr[MIB_DISK_IO_OID_LENGTH * i];
			key = (string)(SnmpUtilOidToA(&temp_oid));
			oid_drivestring.insert(map<string, char>::value_type(key, drive_char));
			//OIDƎWli[p̕ϐ
			MIB_dat_diskIO.insert(map<string, AsnCounter>::value_type(key, 0));
			itr = MIB_dat_diskIO.find(key);
			if (itr != MIB_dat_diskIO.end()) {
				MIB_dat = &(*itr).second;
			}
			//Gg̍쐬a
			SetEntry(MIB_DISK_IO_OID_LENGTH, &MIB_diskIOWritePtr[MIB_DISK_IO_OID_LENGTH * i], MIB_dat,
					MIB_ACCESS_READONLY, MIB_DISK_IO_WRITE, index++);
		}
	}


	//diskIOReads
	for (int i = 0; i < MAX_DRIVE_NUM; i++) {
		if (bit_drives.at(i)) {
			//hCuɊÂāAOID̖ݒ肷B
			char drive_char = 'A' + i;

			//OIDƃhCũ}bv
			temp_oid.idLength = MIB_DISK_IO_OID_LENGTH;
			temp_oid.ids = &MIB_diskIOReadsPtr[MIB_DISK_IO_OID_LENGTH * i];
			key = (string)(SnmpUtilOidToA(&temp_oid));
			oid_drivestring.insert(map<string, char>::value_type(key, drive_char));
			//OIDƎWli[p̕ϐ
			MIB_dat_diskIO.insert(map<string, AsnCounter>::value_type(key, 0));
			itr = MIB_dat_diskIO.find(key);
			if (itr != MIB_dat_diskIO.end()) {
				MIB_dat = &(*itr).second;
			}
			//Gg̍쐬a
			SetEntry(MIB_DISK_IO_OID_LENGTH, &MIB_diskIOReadsPtr[MIB_DISK_IO_OID_LENGTH * i], MIB_dat,
					MIB_ACCESS_READONLY, MIB_DISK_IO_READS, index++);
		}
	}

	//diskIOWrites
	for (int i = 0; i < MAX_DRIVE_NUM; i++) {
		if (bit_drives.at(i)) {
			//hCuɊÂāAOID̖ݒ肷B
			char drive_char = 'A' + i;

			//OIDƃhCũ}bv
			temp_oid.idLength = MIB_DISK_IO_OID_LENGTH;
			temp_oid.ids = &MIB_diskIOWritesPtr[MIB_DISK_IO_OID_LENGTH * i];
			key = (string)(SnmpUtilOidToA(&temp_oid));
			oid_drivestring.insert(map<string, char>::value_type(key, drive_char));
			//OIDƎWli[p̕ϐ
			MIB_dat_diskIO.insert(map<string, AsnCounter>::value_type(key, 0));
			itr = MIB_dat_diskIO.find(key);
			if (itr != MIB_dat_diskIO.end()) {
				MIB_dat = &(*itr).second;
			}
			//Gg̍쐬a
			SetEntry(MIB_DISK_IO_OID_LENGTH, &MIB_diskIOWritesPtr[MIB_DISK_IO_OID_LENGTH * i], MIB_dat,
					MIB_ACCESS_READONLY, MIB_DISK_IO_WRITES, index++);
		}
	}

	/**********/

}

int writeLog(char *ptr) {

	FILE* f;
	if ( fopen_s(&f, "C:\\test.log", "a") != 0)
		return 1;

	if (fprintf_s(f, "%s\n", ptr) < 0)
	{
		fclose(f);
		return 1;
	}

	if (fclose(f) != 0)
		return 1;

	return 0;

}

