/*

 Copyright (C) 2009 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.vm.ejb.entity;

import javax.ejb.EntityBean;

/**
 * cc_vm_protocol_mst情報を管理するEntity Bean <BR>
 * @ejb.bean name="VmProtocolMst"
 *           jndi-name="VmProtocolMst"
 *           type="CMP"
 *           schema="VmProtocolMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           view-type="local"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_vm_protocol_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *    
 *  @jboss.read-only read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_vm_protocol_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM VmProtocolMst as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.finder 
 *    query="SELECT DISTINCT a.protocol FROM VmProtocolMst as a"  
 *    signature="java.util.Collection findDistinctProtocol()"  
 *    
 *  @ejb.pk class="com.clustercontrol.vm.ejb.entity.VmProtocolMstPK"
 *   
 */
public abstract class VmProtocolMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public VmProtocolMstPK ejbCreate(
			String vmSolutionId,
			String protocol,
			Short orderNo
		) throws javax.ejb.CreateException {
		
		this.setVmSolutionId(vmSolutionId);
		this.setOrderNo(orderNo);
		this.setProtocol(protocol);
		
		return null;
	}
	
	/**
	 * コンストラクター
	 * @param vmSolutionId 仮想化ソリューション種別
	 * @param protocol 仮想化接続プロトコル
	 * @param orderNo 表示順
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String vmSolutionId,
			String protocol,
			Short orderNo
		) throws javax.ejb.CreateException {
	}
	
	
	
	
	
	/**
	 * 仮想化ソリューション種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="vm_solution_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="true"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the vmSolutionId.
	 */
	public abstract String getVmSolutionId();

	/**
	 * 仮想化ソリューション種別を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param vmSolutionId The vmSolutionId to set.
	 */
	public abstract void setVmSolutionId(String vmSolutionId);

	
	
	
	/**
	 * 仮想化接続プロトコルを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="protocol"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="true"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the protocol.
	 */
	public abstract String getProtocol();

	/**
	 * 仮想化接続プロトコルを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param protocol The protocol to set.
	 */
	public abstract void setProtocol(String protocol);

	
	/**
	 * 表示順を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="true"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the orderNo.
	 */
	public abstract Short getOrderNo();

	
	/**
	 * 表示順を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param orderNo The orderNo to set.
	 */
	public abstract void setOrderNo(Short orderNo);
	
}
