/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.SelectMonitor;
import com.clustercontrol.sql.bean.SqlCheckInfo;
import com.clustercontrol.sql.util.ControlSqlInfo;

/**
 * SQL監視 数値監視を検索するファクトリークラス<BR>
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class SelectMonitorSql extends SelectMonitor{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorSql.class );

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	public SqlCheckInfo getSqlCheckInfo() throws FinderException, NamingException{
		
		// SQL監視情報を取得
		ControlSqlInfo sql = new ControlSqlInfo(m_monitorId, m_monitorTypeId);
		return sql.get();
	}
}
