/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.process.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.SelectMonitor;
import com.clustercontrol.process.bean.ProcessCheckInfo;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessInfoUtil;

/**
 * プロセス監視判定情報を検索するクラス<BR>
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SelectMonitorProcess extends SelectMonitor{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorProcess.class );

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	public ProcessCheckInfo getProcessCheckInfo() throws FinderException, NamingException{
		
		// プロセス監視情報を取得
		MonitorProcessInfoPK pk = new MonitorProcessInfoPK(m_monitorId, m_monitorTypeId);
		MonitorProcessInfoLocal processLocal = MonitorProcessInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		ProcessCheckInfo process = new ProcessCheckInfo();
		process.setMonitorTypeId(m_monitorTypeId);
		process.setMonitorId(m_monitorId);
		process.setCommand(processLocal.getCommand());
		process.setParam(processLocal.getParam());
		
		return process;
	}
}
