/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 収集毎の計算方法の情報を保持するEntity Bean <BR>
 * @ejb.bean name="CollectorCategoryCollectMst"
 *           jndi-name="CollectorCategoryCollectMst"
 *           type="CMP"
 *           view-type="local"
 *           schema="CollectorCategoryCollectMst" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.container-configuration
 *     name="Hinemos Config CMP 2.x EntityBean"
 *     
 *  @jboss.persistence
 *     datasource="java:/HinemosDS"
 *     datasource-mapping="PostgreSQL 8.0"
 *     table-name="public.cc_collector_category_collect_mst"
 *     create-table="false"
 *     remove-table="false"
 *     alter-table="false"
 *
 *  @jboss.read-only read-only="true"
 *
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_collector_category_collect_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorCategoryCollectMst as a"  
 *    signature="java.util.Collection findAll()"  
 *  
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM CollectorCategoryCollectMst as a where a.platformId = ?1 AND a.subPlatformId = ?2"  
 *    signature="java.util.Collection findByPlatformIdAndSubPlatformId(java.lang.String platformId, java.lang.String subPlatformId)"
 *
 *  @ejb.pk class="com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstPK"
 *   
 */
public abstract class CollectorCategoryCollectMstBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public CollectorCategoryCollectMstPK ejbCreate(
			String platformId,
			String subPlatformId,
			String categoryCode,
			String collectMethod
			) throws javax.ejb.CreateException {
		
		this.setPlatformId(platformId);
		this.setSubPlatformId(subPlatformId);
		this.setCategoryCode(categoryCode);
		this.setCollectMethod(collectMethod);

		return null;
	}
	
	/**
	 * コンストラクター
	 * @param platformId プラットフォーム
	 * @param subPlatformId サブプラットフォームID
	 * @param categoryCode カテゴリコード
	 * @param collectMethod 収集方法
	 * @throws javax.ejb.CreateException
	 */
	public void ejbPostCreate(
			String platformId,
			String subPlatformId,
			String categoryCode,
			String collectMethod
			) throws javax.ejb.CreateException {
	}
	

	/**
	 * プラットフォームを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the platformId.
	 */
	public abstract String getPlatformId();

	/**
	 * プラットフォームを設定します。
	 * 
	 * @param platformId The platformId to set.
	 */
	public abstract void setPlatformId(String platformId);

	/**
	 * サブプラットフォームを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="sub_platform_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the subPlatformId.
	 */
	public abstract String getSubPlatformId();

	/**
	 * サブプラットフォームを設定します。
	 * 
	 * @param subPlatformId The subPlatformId to set.
	 */
	public abstract void setSubPlatformId(String subPlatformId);
	
	/**
	 * カテゴリコードを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="category_code"
	 *     jdbc-type="CHAR"
	 *     sql-type="CHARACTER(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the categoryCode.
	 */
	public abstract String getCategoryCode();

	/**
	 * カテゴリコードを設定します。
	 * 
	 * @param categoryCode The categoryCode to set.
	 */
	public abstract void setCategoryCode(String categoryCode);

	/**
	 * 収集方法を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="collect_method"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the collectMethod.
	 */
	public abstract String getCollectMethod();

	/**
	 * 収集方法を設定します。
	 * 
	 * @param collectMethod The collectMethod to set.
	 */
	public abstract void setCollectMethod(String collectMethod);

}
