/*
                                                                                                
Copyright (C) since 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.performance.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstUtil;

/**
 * 収集カテゴリ情報マスタ情報追加クラス
 * 
 * @version 1.2.0
 * @since 1.2.0
 * @author uchiyama
 *
 */
public class OperateCollectCategoryMaster {
	
	protected static Log m_log = LogFactory.getLog( OperateCollectCategoryMaster.class );
	
	/**
	 * 収集カテゴリ情報マスタ情報を追加します。
	 * 
	 * @param data 収集カテゴリ情報情報
	 * @return 成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 * 
	 */
	public boolean add(CollectorCategoryMstData data) throws CreateException, NamingException {
		
		// 収集カテゴリ情報情報の追加
		CollectorCategoryMstUtil.getLocalHome().create(
				data.getCategoryCode(),
				data.getCategoryName()
		);
				
		return true;
	}
	
	/**
	 * 収集カテゴリ情報マスタ情報を削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean delete(String categoryCode) throws FinderException, NamingException, EJBException, RemoveException {
		
		CollectorCategoryMstLocal local = CollectorCategoryMstUtil.getLocalHome().findByPrimaryKey(categoryCode);
		// pkが同じデータが登録されている場合は、削除する
		local.remove();
		
		return true;
	}
	
	/**
	 * 収集カテゴリ情報マスタ情報を全て削除します。
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws RemoveException 
	 * @throws EJBException 
	 */
	public boolean deleteAll() throws FinderException, NamingException, EJBException, RemoveException {
		
		Collection<CollectorCategoryMstLocal> col = CollectorCategoryMstUtil.getLocalHome().findAll();
		Iterator<CollectorCategoryMstLocal> itr = col.iterator();
		
		while(itr.hasNext()){
			itr.next().remove();
		}
		
		return true;
	}
	
}
