/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.factory.OperateCollectCalcMaster;
import com.clustercontrol.performance.factory.OperateCollectCategoryCollectMaster;
import com.clustercontrol.performance.factory.OperateCollectCategoryMaster;
import com.clustercontrol.performance.factory.OperateCollectItemCalcMethodMaster;
import com.clustercontrol.performance.factory.OperateCollectItemCodeMaster;
import com.clustercontrol.performance.factory.OperateCollectPollingMaster;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryCollectMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCategoryMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCalcMethodMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorItemCodeMstUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstPK;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorPollingMstUtil;

/**
 * 収集項目マスタ情報を制御するSession Bean <BR>
 * @ejb.bean name="PerformanceCollectMasterController"
 *           jndi-name="PerformanceCollectMasterController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"   
 *     
 */
public abstract class PerformanceCollectMasterControllerBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( PerformanceCollectMasterControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/** 
	 * 計算方法定義を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 計算方法定義情報
	 * @return 登録に成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public boolean addCollectCalcMaster(CollectorCalcMethodMstData data) throws CreateException, NamingException {

		// 計算ロジック情報を登録
		OperateCollectCalcMaster ope = new OperateCollectCalcMaster();
		return ope.add(data);
		
	}
	
	/**
	 * カテゴリ毎の収集方法定義を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data カテゴリ毎の収集方法定義情報
	 * @return 登録に成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public boolean addCollectCategoryCollectMaster(CollectorCategoryCollectMstData data) throws CreateException, NamingException {
		
		//カテゴリ毎の収集方法定義を登録
		OperateCollectCategoryCollectMaster ope = new OperateCollectCategoryCollectMaster();
		return ope.add(data);
		
	}
	
	/**
	 * 収集カテゴリ定義を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集カテゴリ定義情報
	 * @return 登録に成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public boolean addCollectCategoryMaster(CollectorCategoryMstData data) throws CreateException, NamingException {
		
		// 収集カテゴリ定義を登録
		OperateCollectCategoryMaster ope = new OperateCollectCategoryMaster();
		return ope.add(data);
		
	}
	
	/**
	 * 収集項目毎の計算方法を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集項目毎の計算方法定義情報
	 * @return 登録に成功した場合、true 
	 * @throws NamingException 
	 * @throws CreateException 
	 * @throws EJBException
	 */
	public boolean addCollectItemCalcMethodMaster(CollectorItemCalcMethodMstData data) throws CreateException, NamingException, EJBException {
		
		// 収集項目毎の計算方法を登録
		OperateCollectItemCalcMethodMaster ope = new OperateCollectItemCalcMethodMaster();
		return ope.add(data);
	}
	
	/**
	 * 収集項目毎の計算方法を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集項目毎の計算方法定義情報
	 * @return 登録に成功した場合、true 
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public boolean addCollectItemCalcMethodMasterSql(CollectorItemCalcMethodMstData data) throws CreateException, NamingException {
	
		// 収集項目毎の計算方法を登録
		OperateCollectItemCalcMethodMaster ope = new OperateCollectItemCalcMethodMaster();
		return ope.addSql(data);
	}
	
	/**
	 * 収集項目コードを登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集項目コード情報
	 * @return 登録に成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public boolean addCollectItemCodeMaster(CollectorItemCodeMstData data) throws CreateException, NamingException {
		
		// 収集項目コードを登録
		OperateCollectItemCodeMaster ope = new OperateCollectItemCodeMaster();
		return ope.add(data);
		
	}
	
	/**
	 * 収集方法・プラットフォーム毎の収集項目を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集方法・プラットフォーム毎の収集項目情報
	 * @return 登録に成功した場合、true
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	public boolean addCollectPollingMaster(CollectorPollingMstData data) throws CreateException, NamingException {
		
		// 収集方法・プラットフォーム毎の収集項目を登録
		OperateCollectPollingMaster ope = new OperateCollectPollingMaster();
		return ope.add(data);
		
	}
	
	/** 
	 * 計算方法定義を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 計算方法定義情報
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectCalcMaster(String calcMethod) throws EJBException, FinderException, NamingException, RemoveException {

		// 計算ロジック情報を削除
		OperateCollectCalcMaster ope = new OperateCollectCalcMaster();
		return ope.delete(calcMethod);
		
	}
	
	/** 
	 * 計算方法定義を全て削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectCalcMasterAll() throws EJBException, FinderException, NamingException, RemoveException {

		// 計算ロジック情報を削除
		OperateCollectCalcMaster ope = new OperateCollectCalcMaster();
		return ope.deleteAll();
		
	}
	
	/**
	 * カテゴリ毎の収集方法定義を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data カテゴリ毎の収集方法定義情報
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectCategoryCollectMaster(CollectorCategoryCollectMstPK pk) throws EJBException, FinderException, NamingException, RemoveException {
		
		//カテゴリ毎の収集方法定義を削除
		OperateCollectCategoryCollectMaster ope = new OperateCollectCategoryCollectMaster();
		return ope.delete(pk);
		
	}
	
	/**
	 * カテゴリ毎の収集方法定義を全て削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectCategoryCollectMasterAll() throws EJBException, FinderException, NamingException, RemoveException {
		
		//カテゴリ毎の収集方法定義を削除
		OperateCollectCategoryCollectMaster ope = new OperateCollectCategoryCollectMaster();
		return ope.deleteAll();
		
	}
	
	/**
	 * 収集カテゴリ定義を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集カテゴリ定義情報
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectCategoryMaster(String categoryCode) throws EJBException, FinderException, NamingException, RemoveException {
		
		// 収集カテゴリ定義を削除
		OperateCollectCategoryMaster ope = new OperateCollectCategoryMaster();
		return ope.delete(categoryCode);
		
	}
	
	/**
	 * 収集カテゴリ定義を全て削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectCategoryMasterAll() throws EJBException, FinderException, NamingException, RemoveException {
		
		// 収集カテゴリ定義を削除
		OperateCollectCategoryMaster ope = new OperateCollectCategoryMaster();
		return ope.deleteAll();
		
	}
	
	/**
	 * 収集項目毎の計算方法を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集項目毎の計算方法定義情報
	 * @return 削除に成功した場合、true 
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectItemCalcMethodMaster(CollectorItemCalcMethodMstPK pk) throws EJBException, FinderException, NamingException, RemoveException {
		
		// 収集項目毎の計算方法を削除
		OperateCollectItemCalcMethodMaster ope = new OperateCollectItemCalcMethodMaster();
		return ope.delete(pk);
		
	}
	
	/**
	 * 収集項目毎の計算方法を全て削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @return 削除に成功した場合、true 
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectItemCalcMethodMasterAll() throws EJBException, FinderException, NamingException, RemoveException {
		
		// 収集項目毎の計算方法を削除
		OperateCollectItemCalcMethodMaster ope = new OperateCollectItemCalcMethodMaster();
		return ope.deleteAll();
		
	}
	
	/**
	 * 収集項目コードを削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集項目コード情報
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectItemCodeMaster(String itemCode) throws EJBException, FinderException, NamingException, RemoveException {
		
		// 収集項目コードを削除
		OperateCollectItemCodeMaster ope = new OperateCollectItemCodeMaster();
		return ope.delete(itemCode);
		
	}
	
	/**
	 * 収集項目コードを全て削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集項目コード情報
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectItemCodeMasterAll() throws EJBException, FinderException, NamingException, RemoveException {
		
		// 収集項目コードを削除
		OperateCollectItemCodeMaster ope = new OperateCollectItemCodeMaster();
		return ope.deleteAll();
		
	}
	
	/**
	 * 収集方法毎の収集項目を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @param data 収集方法・プラットフォーム毎の収集項目情報
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectPollingMaster(CollectorPollingMstPK pk) throws EJBException, FinderException, NamingException, RemoveException {
	
		// 収集方法・プラットフォーム毎の収集項目を削除
		OperateCollectPollingMaster ope = new OperateCollectPollingMaster();
		return ope.delete(pk);
		
	}
	
	/**
	 * 収集方法毎の収集項目を全て削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectPollingMasterAll() throws EJBException, FinderException, NamingException, RemoveException {
	
		// 収集方法・プラットフォーム毎の収集項目を削除
		OperateCollectPollingMaster ope = new OperateCollectPollingMaster();
		return ope.deleteAll();
		
	}
	
	/**
	 * 収集項目のマスタ情報を全て削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="PerformanceWrite"
     *     method-intf="Remote"
	 * 
	 * @return 削除に成功した場合、true
	 * @throws RemoveException 
	 * @throws NamingException 
	 * @throws FinderException 
	 * @throws EJBException 
	 */
	public boolean deleteCollectMasterAll() throws EJBException, FinderException, NamingException, RemoveException {
		
		// 収集項目に関連する全てのマスタ情報を削除
		OperateCollectCategoryCollectMaster opeCategoryCollect = new OperateCollectCategoryCollectMaster();
		OperateCollectPollingMaster opePolling = new OperateCollectPollingMaster();
		OperateCollectItemCalcMethodMaster opeItemCalc = new OperateCollectItemCalcMethodMaster();
		OperateCollectItemCodeMaster opeItemCode = new OperateCollectItemCodeMaster();
		OperateCollectCategoryMaster opeCategory = new OperateCollectCategoryMaster();
		OperateCollectCalcMaster opeCalc = new OperateCollectCalcMaster();
		
		return opeCategoryCollect.deleteAll() && opePolling.deleteAll() && opeItemCalc.deleteAll() && opeItemCode.deleteAll() && opeCategory.deleteAll() && opeCalc.deleteAll();
		
	}
	
	/**
	 * 全計算方法定義を取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceRead"
     *     method-intf="Remote"
	 * 
	 * @return 全計算方法定義
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList<CollectorCalcMethodMstData> getCollectCalcMasterList() throws FinderException, NamingException {
		
		ArrayList<CollectorCalcMethodMstData> ret = new ArrayList<CollectorCalcMethodMstData>();
		
		Collection<CollectorCalcMethodMstLocal> list = CollectorCalcMethodMstUtil.getLocalHome().findAll();
		Iterator<CollectorCalcMethodMstLocal> itr = list.iterator();
		while(itr.hasNext()) {
			CollectorCalcMethodMstLocal local = itr.next();
			CollectorCalcMethodMstData data = new CollectorCalcMethodMstData(
					local.getCalcMethod(),
					local.getClassName(),
					local.getExpression());
			
			ret.add(data);	
		}
		
		return ret;
	}
	
	/**
	 * カテゴリを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceRead"
     *     method-intf="Remote"
	 * 
	 * @return カテゴリ定義
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList<CollectorCategoryMstData> getCollectCategoryList() throws FinderException, NamingException {
		
		ArrayList<CollectorCategoryMstData> ret = new ArrayList<CollectorCategoryMstData>();
		
		Collection<CollectorCategoryMstLocal> list = CollectorCategoryMstUtil.getLocalHome().findAll();
		Iterator<CollectorCategoryMstLocal> itr = list.iterator();
		while(itr.hasNext()) {
			CollectorCategoryMstLocal local = itr.next();
			CollectorCategoryMstData data = new CollectorCategoryMstData(
					local.getCategoryCode(),
					local.getCategoryName());
			
			ret.add(data);	
		}
		
		return ret;
	}
	
	/**
	 * 収集項目コードを取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceRead"
     *     method-intf="Remote"
	 * 
	 * @return 収集項目コード
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList<CollectorItemCodeMstData> getCollectItemCodeMasterList() throws FinderException, NamingException {
		
		ArrayList<CollectorItemCodeMstData> ret = new ArrayList<CollectorItemCodeMstData>();
		
		Collection<CollectorItemCodeMstLocal> list = CollectorItemCodeMstUtil.getLocalHome().findAll();
		Iterator<CollectorItemCodeMstLocal> itr = list.iterator();
		while(itr.hasNext()) {
			CollectorItemCodeMstLocal local = itr.next();
			CollectorItemCodeMstData data = new CollectorItemCodeMstData(
					local.getItemCode(),
					local.getCategoryCode(),
					local.getParentItemCode(),
					local.getItemName(),
					local.getMeasure(),
					local.getDeviceSupport(),
					local.getDeviceType(),
					local.getGraphRange());
			
			ret.add(data);	
		}
		
		return ret;
	}
	
	/**
	 * 収集項目定義を取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceRead"
     *     method-intf="Remote"
	 * 
	 * @return 収集項目定義
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList<CollectorItemCalcMethodMstData> getCollectItemCalcMasterList() throws FinderException, NamingException {
		
		ArrayList<CollectorItemCalcMethodMstData> ret = new ArrayList<CollectorItemCalcMethodMstData>();
		
		Collection<CollectorItemCalcMethodMstLocal> list = CollectorItemCalcMethodMstUtil.getLocalHome().findAll();
		Iterator<CollectorItemCalcMethodMstLocal> itr = list.iterator();
		while(itr.hasNext()) {
			CollectorItemCalcMethodMstLocal local = itr.next();
			CollectorItemCalcMethodMstData data = new CollectorItemCalcMethodMstData(
					local.getCollectMethod(),
					local.getPlatformId(),
					local.getSubPlatformId(),
					local.getItemCode(),
					local.getCalcMethod());
			
			ret.add(data);	
		}
		
		return ret;
	}
	
	/**
	 * ポーリング対象定義を取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceRead"
     *     method-intf="Remote"
	 * 
	 * @return ポーリング対象定義
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList<CollectorPollingMstData> getCollectPollingList() throws FinderException, NamingException {
		
		ArrayList<CollectorPollingMstData> ret = new ArrayList<CollectorPollingMstData>();
		
		Collection<CollectorPollingMstLocal> list = CollectorPollingMstUtil.getLocalHome().findAll();
		Iterator<CollectorPollingMstLocal> itr = list.iterator();
		while(itr.hasNext()) {
			CollectorPollingMstLocal local = itr.next();
			CollectorPollingMstData data = new CollectorPollingMstData(
					local.getCollectMethod(),
					local.getPlatformId(),
					local.getSubPlatformId(),
					local.getItemCode(),
					local.getVariableId(),
					local.getEntryKey(),
					local.getValueType(),
					local.getPollingTarget(),
					local.getFailureValue());
			
			ret.add(data);	
		}
		
		return ret;
	}
	
	/**
	 * カテゴリ毎の収集方法を取得します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="PerformanceRead"
     *     method-intf="Remote"
	 * 
	 * @return カテゴリ毎の収集方法
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public ArrayList<CollectorCategoryCollectMstData> getCollectCategoryCollectList() throws FinderException, NamingException {
		
		ArrayList<CollectorCategoryCollectMstData> ret = new ArrayList<CollectorCategoryCollectMstData>();
		
		Collection<CollectorCategoryCollectMstLocal> list = CollectorCategoryCollectMstUtil.getLocalHome().findAll();
		Iterator<CollectorCategoryCollectMstLocal> itr = list.iterator();
		while(itr.hasNext()) {
			CollectorCategoryCollectMstLocal local = itr.next();
			CollectorCategoryCollectMstData data = new CollectorCategoryCollectMstData(
					local.getPlatformId(),
					local.getSubPlatformId(),
					local.getCategoryCode(),
					local.getCollectMethod());
			
			ret.add(data);	
		}
		
		return ret;
	}
}
