/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.ejb.session;

import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.CommandNotFoundException;
import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.UsedFacilityException;
import com.clustercontrol.bean.PluginConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.factory.DeleteMaster;
import com.clustercontrol.collectiverun.factory.HistoryFilterProperty;
import com.clustercontrol.collectiverun.factory.ModifyMaster;
import com.clustercontrol.collectiverun.factory.OperationRun;
import com.clustercontrol.collectiverun.factory.ParameterProperty;
import com.clustercontrol.collectiverun.factory.SelectMaster;
import com.clustercontrol.collectiverun.factory.SelectSession;
import com.clustercontrol.commons.ejb.session.CheckFacility;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import com.clustercontrol.util.apllog.AplLogger;


/**
 *
 * <!-- begin-user-doc -->
 * 一括制御の管理を行う Session Bean です。<BR>
 * クライアントからの Entity Bean へのアクセスは、Session Bean を介して行います。
 * <!-- end-user-doc -->
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="CollectiveRunController"	
 *           jndi-name="CollectiveRunController"
 *           type="Stateless" 
 *           transaction-type="Container"
 *           
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunCmdMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunCmdParamMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunEndMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunParamMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunParamSelectMstLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunSessionLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunSessionDetailLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunSessionParamLocal"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CRunTypeMstLocal"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class CollectiveRunControllerBean implements javax.ejb.SessionBean, CheckFacility {
    protected static Log m_log = LogFactory.getLog( CollectiveRunControllerBean.class );
    public static final String GROUP_NAME = "CRUN_MANAGEMENT";
    
    
    /**
     * 一括制御[パラメータ]ビューの表示用プロパティを取得します。<BR>
     * 一括制御[履歴]ビューで選択されている履歴に対応するプロパティ情報を取得します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     * 
     * @param sessionId 選択されている履歴のセッションID
     * @param locale ロケール情報
     * @return 一括制御[パラメータ]ビューの表示用プロパティ
     * 
	 * @see com.clustercontrol.collectiverun.factory.ParameterProperty#getPropertyBySessionId(String, Locale)
	 * 
     */
    public Property getParameterPropertyBySessionId(String sessionId, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getPropertyBySessionId(sessionId, locale);
    }
    
    /**
     * 一括制御[パラメータ]ビューの表示用プロパティを取得します。<BR>
     * 一括制御[パラメータ]ビューで選択されている種別IDに対応するプロパティ情報を取得します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     * 
     * @param typeId 種別ID
     * @param locale ロケール情報
     * 
     * @return 一括制御[パラメータ]ビューの表示用プロパティ
     * 
	 * @see com.clustercontrol.collectiverun.factory.ParameterProperty#getProperty(String, Locale)
     * 
     */
    public Property getParameterProperty(String typeId, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getProperty(typeId, locale);
    }
    
    /**
     * 
     * 一括制御[履歴]ビューで選択されている履歴に対応する種別IDを取得します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     * 
     * @param sessionId 選択されている履歴のセッションID
     * @return 種別ID
     */
    public String getParameterTypeId(String sessionId) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getTypeId(sessionId);
    }
    
	/**
	 * 一括制御[履歴フィルタ]ダイアログ表示用のプロパティを取得します。
	 * 
	 * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
	 * 
	 * @param locale ロケール情報
	 * @return 一括制御[履歴フィルタ]ダイアログ表示用のプロパティ
	 * 
	 * @see com.clustercontrol.collectiverun.factory.HistoryFilterProperty#getProperty(Locale)
 	 *  
	 * @throws FinderException 
	 * @throws NamingException 
	 * 
	 */
	public Property getHistoryFilterProperty(Locale locale) throws FinderException, NamingException {
	    Property historyFilterProperty = null;
		try {
			HistoryFilterProperty history = new HistoryFilterProperty();
			historyFilterProperty = history.getProperty(locale);
		} catch (FinderException e) {
			m_log.debug("getHistoryFilterProperty() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		return historyFilterProperty;
	}
    
    /**
     * 一括制御[履歴]ビューに表示する履歴のリストを取得します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
     * 
     * @param locale ロケール情報
     * @param histories 表示履歴数
     * 
     * @return 一括制御[履歴]情報
     * 
     * @see com.clustercontrol.bean.ViewListInfo
     * @see com.clustercontrol.collectiverun.factory.SelectSession#getHistoryList(Locale, int)
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public ViewListInfo getHistoryList(Locale locale, int histories) throws FinderException, NamingException {
        ViewListInfo historyList = null;
		try {
			SelectSession select = new SelectSession();
			historyList = select.getHistoryList(locale, histories);
		} catch (FinderException e) {
			m_log.debug("getHistoryList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		} 
        return historyList; 
    }
    
    /**
     * 一括制御[履歴]ビューに表示する履歴のリストを取得します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
     * 
     * @param property フィルタのための情報を持つプロパティ
     * @param locale ロケール情報
     * @param histories 表示履歴数
     * 
     * @return 一括制御[履歴]情報
     * 
     * @see com.clustercontrol.bean.ViewListInfo
     * @see com.clustercontrol.collectiverun.factory.SelectSession#getHistoryList(Property, Locale, int)
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public ViewListInfo getHistoryList(Property property, Locale locale, int histories) throws FinderException, NamingException {
        ViewListInfo historyList = null;
		try {
			SelectSession select = new SelectSession();
			historyList = select.getHistoryList(property, locale, histories);
		} catch (FinderException e) {
			m_log.debug("getHistoryList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
        return historyList; 
    }
    
    /**
     * 一括制御[詳細]ビューに表示する情報を取得します。<BR>
     * 
     * 取得されるArrayListは、下記のように生成されます。
     * 
     * <p>
     * ArrayList info = new ArrayList();
     *		info.add(detail.getStatus());
     *		info.add(detail.getEnd_status());
     *		info.add(detail.getEnd_value());
     *		info.add(detail.getFacility_id());
     *		info.add(detail.getFacility_name());
     *		info.add(detail.getStart_date());
     *		info.add(detail.getEnd_date());
     *		StringBuffer message = new StringBuffer();
     *		if(detail.getMessage() != null){ 
     *			message.append(detail.getMessage());
     *		}
     *		if(detail.getError_message() != null){ 
     *			message.append(detail.getError_message());
     *		}
     *		info.add(message.toString());
     *		list.add(info);
     * </p>
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
     * 
     * @param sessionId セッションID
     * 
     * @return 一括制御[詳細]情報
     * 
     * @see com.clustercontrol.collectiverun.factory.SelectSession#getDetailList(String, Locale)
     * 
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
        ArrayList detailList = null;
		try {
			SelectSession select = new SelectSession();
			detailList = select.getDetailList(sessionId, locale);
		} catch (FinderException e) {
			m_log.debug("getDetailList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
        return detailList;
    }
    
    /**
     * 一括制御を実行する際に呼び出される、インタフェースメソッドです。
     * セッションIDを生成し、一括制御を実行します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param typeId 種別ID
     * @param property プロパティ
     * @param locale ロケール情報
     * @throws Exception
     */
    public void run(String typeId, Property property, Locale locale) throws Exception {
        CollectiveRunControllerLocal controller = 
            CollectiveRunControllerUtil.getLocalHome().create();
        
	    //実行履歴データ作成
	    String sessionId;
        try {
            sessionId = controller.createSession(typeId, property, locale);
        } catch (Exception e) {
            AplLogger apllog = new AplLogger("CR","cr");
            apllog.put("SYS","002");
            throw e;
        }
        
        //実行
        try {
            controller.run(sessionId);
	    } catch (Exception e) {
            AplLogger apllog = new AplLogger("CR","cr");
            apllog.put("SYS","001");
	        throw e;
	    }
    }
    
    /**
     * 一括制御の実行履歴情報を作成します。<BR>
     * 返り値としてセッションIDを返します。
     * 
     * @ejb.interface-method
     *     view-type="local"
     * 
	 * @ejb.transaction
	 *     type="RequiresNew"
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param typeId 種別ID
     * @param property プロパティ
     * @param locale ロケール情報
     * 
     * @return セッションID
     * 
     * @throws CreateException
     * @throws NamingException
     * @throws CommandNotFoundException 
     * @throws FacilityNotFoundException 
     */
    public String createSession(String typeId, Property property, Locale locale)
    		throws CreateException, FinderException, NamingException, FacilityNotFoundException, CommandNotFoundException {
        OperationRun operation = new OperationRun();
    	//実行履歴データ作成
        return operation.createSession(typeId, property, locale);
    }
    
    /**
     * 一括制御を実行する際に呼び出される、インタフェースメソッドです。
     * 
     * @ejb.interface-method
     *     view-type="local"
     * 
	 * @ejb.transaction
	 *     type="RequiresNew"
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param sessionId セッションID
     * 
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     * @throws IOException
     */
    public void run(String sessionId) throws CreateException, FinderException, NamingException, IOException {
        OperationRun operation = new OperationRun();
        operation.run(sessionId);
    }
    
    /**
     * 一括制御の終了処理を行います。<BR>
     * 終了状態を、実行履歴・実行履歴詳細情報に設定します。
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param info 実行結果情報
     * 
     * @see com.clustercontrol.collectiverun.factory.OperationRun#endNode(RunResultInfo)
     * @see com.clustercontrol.jobmanagement.message.RunResultInfo
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        OperationRun operation = new OperationRun();
        operation.endNode(info);
    }
    
    /**
     * Quartzからのコールバックメソッド。<BR>
     * セッションの終了状態をチェックします。
     * 
     * @ejb.interface-method
     * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @param info
     * @throws FinderException
     * @throws NamingException
     */
    public void checkEndSession() throws FinderException, NamingException {
    	OperationRun operation = new OperationRun();
    	operation.checkEndSession();
    }
    
    /**
     * 一括制御コマンドの情報を取得します。<BR>
     * コマンド情報はツリー構造で表現されます。
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
     *     read-only="true"
     * 
     * @param locale ロケール情報
     * 
     * @return ツリー構造で表現された一括制御コマンドの情報
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public TreeItem getTree(Locale locale) throws FinderException, NamingException {
    	SelectMaster select = new SelectMaster();
    	return select.getTree(locale);
    }
    
    /**
     * 一括制御のマスタ情報を更新します。
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunWrite"
     *     method-intf="Remote"
     * 
     * @param info 
     * @param parentInfo
     * 
     * @throws NamingException
     * @throws CreateException
     * @throws RemoveException 
     */
    public void updateMaster(ItemInfo info, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException {
    	ModifyMaster modify = new ModifyMaster();

    	try {
	    	modify.update(info, parentInfo);
        } catch (NamingException e) {
        	outputErrorUpdateMaster(info, parentInfo, e);
            throw e;
        } catch (CreateException e) {
        	outputErrorUpdateMaster(info, parentInfo, e);
            throw e;
        } catch (RemoveException e) {
        	outputErrorUpdateMaster(info, parentInfo, e);
            throw e;
        }
    }
    
    /**
     * 一括制御マスタ情報の更新時にエラーを出力します。
     * 
     * @param info
     * @param parentInfo
     * @param e
     */
    protected void outputErrorUpdateMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {

		if(info == null || parentInfo == null){
			return;
		}
		
		String id = "";
		String parentId = "";
		if(info.getType() == ItemConstant.TYPE_TYPE){
			id = ((TypeInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			id = ((CommandInfo)info).getId();
			parentId = ((TypeInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			id = ((CommandParameterInfo)info).getId();
			parentId = ((CommandInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			id = ((ParameterInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
			parentId = ((ParameterSelectInfo)info).getId();
		}
    	
        AplLogger apllog = new AplLogger("CR","cr");
        String[] args = { String.valueOf(info.getType()), id, parentId };
        apllog.put("SYS", "007", args);
        m_log.debug("updateMaster() : " + e.getMessage());
    }
    
    /**
     * 一括制御マスタ情報を削除します。
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunWrite"
     *     method-intf="Remote"
     * 
     * @param info
     * @param parentInfo
     * @throws EJBException
     * @throws FinderException
     * @throws NamingException
     * @throws RemoveException
     */
    public void deleteMaster(ItemInfo info, ItemInfo parentInfo) throws EJBException, FinderException, NamingException, RemoveException {
    	DeleteMaster delete = new DeleteMaster();

    	try {
    		delete.delete(info, parentInfo);
        } catch (EJBException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        } catch (FinderException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        } catch (NamingException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        } catch (RemoveException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        }
    }
    
    /**
     * 一括制御マスタ情報の削除時にエラーを出力します。
     * 
     * @param info
     * @param parentInfo
     * @param e
     */
    protected void outputErrorDeleteMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {

		if(info == null || parentInfo == null){
			return;
		}
		
		String id = "";
		String parentId = "";
		if(info.getType() == ItemConstant.TYPE_TYPE){
			id = ((TypeInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			id = ((CommandInfo)info).getId();
			parentId = ((TypeInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			id = ((CommandParameterInfo)info).getId();
			parentId = ((CommandInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			id = ((ParameterInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
			parentId = ((ParameterSelectInfo)info).getId();
		}
    	
        AplLogger apllog = new AplLogger("CR","cr");
        String[] args = { String.valueOf(info.getType()), id, parentId };
        apllog.put("SYS", "008", args);
        m_log.debug("deleteMaster() : " + e.getMessage());
    }
    
    /**
     * 一括制御マスタ情報を更新します。<BR>
     * 表示順を上下させる際に使用します。
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunWrite"
     *     method-intf="Remote"
     * 
     * @param info1
     * @param info2
     * @param parentInfo
     * 
     * @throws NamingException
     * @throws CreateException
     * @throws RemoveException
     * @throws FinderException
     */
    public void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException, FinderException {
    	ModifyMaster modify = new ModifyMaster();
    	modify.changeOrder(info1, info2, parentInfo);
    }
    
    /**
     * 一括制御[パラメータ]ビューの種別に表示する文字列のリスト取得します。
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
     *     read-only="true"
     * 
     * @param locale ロケール情報
     * @return 種別文字列
     * @throws FinderException
     * @throws NamingException
     */
    public List getTypeStringList(Locale locale) throws FinderException, NamingException {
    	List typeStringList = null;
		try {
			typeStringList = SelectMaster.getTypeStringList(locale);
		} catch (FinderException e) {
			m_log.debug("getTypeStringList() -> " + e.getMessage());
		} catch (NamingException e) {
			throw e;
		}
    	return typeStringList; 
    }
    
    /**
     * 種別のハッシュマップ（key : 種別ID, value : 種別文字列）を取得します。
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
     *     read-only="true"
     * 
     * @param locale ロケール情報
     * 
     * @return 種別IDと種別文字列のハッシュマップ
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public HashMap getTypeHashMap(Locale locale) throws FinderException, NamingException {
    	HashMap typeHashMap = null;
		try {
			typeHashMap = SelectMaster.getTypeHashMap(locale);
		} catch (FinderException e) {
			m_log.debug(e.getMessage());
		} catch (NamingException e) {
			throw e;
		} 
    	return typeHashMap;
    }
    
    /**
     * セッションが終了しているかの定期チェックをQuartzへ登録します。<BR>
     * このメソッドはQuartzSetupからのみ使用されます。
     * 
     * @ejb.interface-method
     * @generated
     * 
 	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @param cronString
     * 
     * @see com.clustercontrol.collectiverun.ejb.session.CollectiveRunController#checkEndSession()
     * 
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     */
    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        //QuartzのSchedulerをルックアップ
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ジョブ削除
        	manager.deleteSchedule(CollectiveRunControllerHome.JNDI_NAME, 
                    GROUP_NAME);
        } catch (SchedulerException e) {
            m_log.debug("addQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
        	//TODO 未実装（例外処理）
		}
        
        //JobDetail作成
        JobDetail job = new JobDetail(
        		CollectiveRunControllerHome.JNDI_NAME, 
                GROUP_NAME, 
                EJBInvokerJob.class);
        
        String serverName = System.getProperty("jboss.server.name");
	    if(serverName.equals("all")){
	        job.getJobDataMap().put(
	                EJBInvokerJob.PROVIDER_URL, 
	                "jnp://localhost:1100");
	    }
	    
        //ジョブ完了時に削除されないようにする。
        job.setDurability(true);
	    //ジョブ実行失敗時に再実行するようにする。
        //JBoss再起動時に複数同時に再実行される可能性があるためこのオプションは設定しないよう変更する
//	    job.setRequestsRecovery(true);
	    
        //JobDetailに呼び出すクラスとメソッドを設定
        job.getJobDataMap().put(
                EJBInvokerJob.EJB_JNDI_NAME_KEY, 
                CollectiveRunControllerHome.JNDI_NAME);
        job.getJobDataMap().put(
                EJBInvokerJob.EJB_METHOD_KEY, 
                "checkEndSession");
        
        //JobDetailに呼び出すメソッドの引数を設定
        Object[] jdArgs = new Object[0];
        job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
        
        //CronTriggerを作成
        CronTrigger cronTrigger = new CronTrigger(CollectiveRunControllerHome.JNDI_NAME, GROUP_NAME);
        
        //起動失敗した場合は、次の起動予定時刻をセットするように設定
        cronTrigger.setMisfireInstruction(CronTrigger.MISFIRE_INSTRUCTION_DO_NOTHING);
        
        //スケジュールを設定
        cronTrigger.setCronExpression(cronString);
        
        //Schedulerにジョブを登録する
        try {
			manager.addSchedule(job, cronTrigger);
		} catch (RemoteException e) {
        	//FIXME RemoteException未実装
		}
    }
    
    /**
     * セッションが終了しているかの定期チェックをQuartzから削除します。<BR>
     * このメソッドはQuartzSetupからのみ使用されます。
     * 
     * @ejb.interface-method
     * @generated
     * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     */
    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        //QuartzのSchedulerをルックアップ
    	QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ジョブ削除
        	manager.deleteSchedule(CollectiveRunControllerHome.JNDI_NAME, 
                    GROUP_NAME);
        } catch (SchedulerException e) {
            m_log.debug("deleteQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
        	//TODO 未実装（例外処理）        	
		}
    }
    
	/**
	 * ファシリティIDが使用されているかチェックします。
	 * <P>
	 * 使用されていたら、UsedFacilityException がスローされる。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="CollectiveRunRead"
	 *     method-intf="Remote"
	 *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ファシリティ
	 * @throws UsedFacilityException
	 * 
	 * @see com.clustercontrol.commons.ejb.session.CheckFacility#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.bean.PluginConstant;
	 */
	public void isUseFacilityId(String facilityId) throws UsedFacilityException {
		try {
			Collection ct = null;
			
			// ファシリティIDが使用されているセッションを取得する。
			ct = CRunSessionUtil.getLocalHome().findByFacilityId(facilityId);
			if(ct != null && ct.size() > 0) {
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					//セッションを取得
					CRunSessionLocal session = (CRunSessionLocal)itr.next();
					//セッションの実行状態が終了の場合、UsedFacilityExceptionをスロー
					if(session.getStatus().intValue() != StatusConstant.TYPE_END){
						throw new UsedFacilityException(PluginConstant.TYPE_COLLECTIVERUN);
					}
				}
			}
			
			// ファシリティIDが使用されているセッションディテールを取得する。
			ct = null;
			ct = CRunSessionDetailUtil.getLocalHome().findByFacilityId(facilityId);
			if(ct != null && ct.size() > 0) {
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					//セッションディテールを取得
					CRunSessionDetailLocal sessionDetail = (CRunSessionDetailLocal)itr.next();
					//セッションディテールの実行状態が終了の場合、UsedFacilityExceptionをスロー
					if(sessionDetail.getStatus().intValue() != StatusConstant.TYPE_END){
						throw new UsedFacilityException(PluginConstant.TYPE_COLLECTIVERUN);
					}
				}
			}
			
		} catch (FinderException e) {
			m_log.info("isUseFacilityId() : " + e.getMessage());
		} catch (NamingException e) {
			m_log.info("isUseFacilityId() : " + e.getMessage());
		}
	}
}
