/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.sql.bean.JdbcDriverInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import com.clustercontrol.sql.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * JDBC情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class GetJdbc {

    /**
     * SQL監視情報を返します。
     * 
     * @param monitorId 監視項目ID
     * @param monitorType 監視判定タイプ
     * @return SQL監視情報
     */
    public static List<List> getJdbcDriverList() {
    	
    	MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getSqlController();

    	List<List> list = new ArrayList();

    	try {
    		ArrayList<JdbcDriverInfo> driverList = sql.getJdbcDriverList();
    		for (JdbcDriverInfo driver : driverList) {
    			ArrayList<String> a = new ArrayList<String>();
    			a.add(driver.getJdbcDriverName());
    			a.add(driver.getJdbcDriverClass());
    			list.add(a);
    		}
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

        return list;
    }
    
}