package com.clustercontrol.repository.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.bean.NodeConstant;
import com.clustercontrol.repository.bean.NodeDeviceInfo;
import com.clustercontrol.repository.bean.NodeFilesystemInfo;
import com.clustercontrol.repository.bean.NodeHostnameInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.bean.NodeNoteInfo;
import com.clustercontrol.repository.bean.RepositoryTableInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

public class NodePropertyUtil {
	
	/** ----- 初期値キャッシュ ----- */
	private static HashMap<Locale, HashMap<Integer, Property>> cachedInitProperty = null;
	
	static {
		cachedInitProperty = new HashMap<Locale, HashMap<Integer, Property>>();
	}
	
	/**
	 * PropertyクラスをNodeInfoクラスに変換するメソッド。
	 * この処理は不可逆なので注意すること。。
	 */
	public static NodeInfo property2node (Property property) {
		NodeInfo nodeInfo = new NodeInfo();
		ArrayList object1 = null;
		ArrayList object2 = null;
		ArrayList object3 = null;
		ArrayList object4 = null;
		ArrayList object5 = null;
		ArrayList object6 = null;
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.FACILITY_ID);
		if (object1.size() > 0) {
			nodeInfo.setFacilityId((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.FACILITY_NAME);
		if (object1.size() > 0) {
			nodeInfo.setFacilityName((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.DESCRIPTION);
		if (object1.size() > 0) {
			nodeInfo.setDescription((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VALID);
		if (object1.size() > 0) {
			nodeInfo.setValid((Boolean)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.CREATOR_NAME);
		if (object1.size() > 0) {
			nodeInfo.setCreateUserId((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.CREATE_TIME);
		if (object1.size() > 0 && object1.get(0) != null && 
				!object1.get(0).toString().equals("")) {
			nodeInfo.setCreateDatetime((Date)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.MODIFIER_NAME);
		if (object1.size() > 0) {
			nodeInfo.setModifyUserId((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.MODIFY_TIME);
		if (object1.size() > 0 && object1.get(0) != null && 
				!object1.get(0).toString().equals("")) {
			nodeInfo.setModifyDatetime((Date)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.PLATFORM_FAMILY_NAME);
		if (object1.size() > 0) {
			nodeInfo.setPlatformFamily((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.HARDWARE_TYPE);
		if (object1.size() > 0) {
			nodeInfo.setHardwareType((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.ICONIMAGE);
		if (object1.size() > 0) {
			nodeInfo.setIconImage((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.SNMP_PORT);
		if (object1.size() > 0 && object1.get(0) != null && 
				!object1.get(0).toString().equals("")) {
			nodeInfo.setSnmpPort((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.SNMP_COMMUNITY);
		if (object1.size() > 0) {
			nodeInfo.setSnmpCommunity((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.SNMP_VERSION);
		if (object1.size() > 0) {
			nodeInfo.setSnmpVersion((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.SNMPTIMEOUT);
		if (object1.size() > 0 && object1.get(0) != null && 
				!object1.get(0).toString().equals("")) {
			nodeInfo.setSnmpTimeout((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.SNMPRETRIES);
		if (object1.size() > 0 && object1.get(0) != null && 
				!object1.get(0).toString().equals("")) {
			nodeInfo.setSnmpRetryCount((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.SNMPPROXY);
		if (object1.size() > 0) {
			nodeInfo.setSnmpProxy((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.WBEM_USER);
		if (object1.size() > 0) {
			nodeInfo.setWbemUser((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.WBEM_USER_PASSWORD);
		if (object1.size() > 0) {
			nodeInfo.setWbemUserPassword((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.WBEM_PORT);
		if (object1.size() > 0 && object1.get(0) != null &&
				!object1.get(0).toString().equals("")) {
			nodeInfo.setWbemPort((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.WBEM_PROTOCOL);
		if (object1.size() > 0) {
			nodeInfo.setWbemProtocol((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.WBEM_TIMEOUT);
		if (object1.size() > 0 && object1.get(0) != null &&
				!object1.get(0).toString().equals("")) {
			nodeInfo.setWbemTimeout((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.WBEM_RETRIES);
		if (object1.size() > 0 && object1.get(0) != null &&
				!object1.get(0).toString().equals("")) {
			nodeInfo.setWbemRetryCount((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.DHCP_CLIENT);
		if (object1.size() > 0) {
			nodeInfo.setDhcpClient((Boolean)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.IP_ADDRESS_TYPE);
		if (object1.size() > 0 && object1.get(0) != null &&
				!object1.get(0).toString().equals("")) {
			nodeInfo.setIpAddressType((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.IP_ADDRESS_VERSION);
		if (object1.size() > 0 && object1.get(0) != null &&
				!object1.get(0).toString().equals("")) {
			nodeInfo.setIpAddressVersion((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.IP_ADDRESS_V4);
		if (object1.size() > 0) {
			nodeInfo.setIpAddressV4((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.IP_ADDRESS_V6);
		if (object1.size() > 0) {
			nodeInfo.setIpAddressV6((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.NODE_NAME);
		if (object1.size() > 0) {
			nodeInfo.setNodeName((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.OS_NAME);
		if (object1.size() > 0) {
			nodeInfo.setOsName((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.OS_RELEASE);
		if (object1.size() > 0) {
			nodeInfo.setOsRelease((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.OS_VERSION);
		if (object1.size() > 0) {
			nodeInfo.setOsVersion((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.CHARACTER_SET);
		if (object1.size() > 0) {
			nodeInfo.setCharacterSet((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VIRTNODETYPE);
		if (object1.size() > 0) {
			nodeInfo.setVirtualizationNodeType((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VMMANAGEMENTNODE);
		if (object1.size() > 0) {
			nodeInfo.setVmManagementNode((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VMINDEX);
		if (object1.size() > 0 && object1.get(0) != null &&
				!object1.get(0).toString().equals("")) {
			nodeInfo.setVmIndex((Integer)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VMNAME);
		if (object1.size() > 0) {
			nodeInfo.setVmName((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VIRTSOLUTION);
		if (object1.size() > 0) {
			nodeInfo.setVirtualizationSolution((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VMID);
		if (object1.size() > 0) {
			nodeInfo.setVmId((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VMUSER);
		if (object1.size() > 0) {
			nodeInfo.setVmUser((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VMUSERPASSWORD);
		if (object1.size() > 0) {
			nodeInfo.setVmUserPassword((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.VMPROTOCOL);
		if (object1.size() > 0) {
			nodeInfo.setVmProtocol((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.ADMINISTRATOR);
		if (object1.size() > 0) {
			nodeInfo.setAdministrator((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.CONTACT);
		if (object1.size() > 0) {
			nodeInfo.setContact((String)object1.get(0));
		}
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.HOST_NAME);
		ArrayList<NodeHostnameInfo> nodeHostnameInfo = new ArrayList<NodeHostnameInfo>();
		for (Object o : object1) {
			nodeHostnameInfo.add(new NodeHostnameInfo((String)o));
		}
		nodeInfo.setNodeHostnameInfo(nodeHostnameInfo);
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.NOTE);
		ArrayList<NodeNoteInfo> nodeNoteInfo = new ArrayList<NodeNoteInfo>();
		int i = 0;
		for (Object o : object1) {
			nodeNoteInfo.add(new NodeNoteInfo(i, (String) o));
			i++;
		}
		nodeInfo.setNodeNoteInfo(nodeNoteInfo);
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.DEVICE_TYPE);
		object2 = PropertyUtil.getPropertyValue(property, NodeConstant.DEVICE_INDEX);
		object3 = PropertyUtil.getPropertyValue(property, NodeConstant.DEVICE_NAME);
		object4 = PropertyUtil.getPropertyValue(property, NodeConstant.DEVICE_DISPLAY_NAME);
		object5 = PropertyUtil.getPropertyValue(property, NodeConstant.DEVICE_OID);
		object6 = PropertyUtil.getPropertyValue(property, NodeConstant.DEVICE_DESCRIPTION);
		ArrayList<NodeDeviceInfo> nodeDeviceInfo = new ArrayList<NodeDeviceInfo>();
		i = 0;
		for (Object o : object1) {
			if (object1.get(i) != null && ! object1.get(i).toString().equals("")
					|| object2.get(i) != null && ! object2.get(i).toString().equals("")
					|| object3.get(i) != null && ! object3.get(i).toString().equals("")
					|| object4.get(i) != null && ! object4.get(i).toString().equals("")
					|| object5.get(i) != null && ! object5.get(i).toString().equals("")
					|| object6.get(i) != null && ! object6.get(i).toString().equals("")) {
				nodeDeviceInfo.add(new NodeDeviceInfo((String)object1.get(i),
						(Integer)object2.get(i),
						(String)object3.get(i),
						(String)object4.get(i),
						(String)object5.get(i),
						(String)object6.get(i)));
			}
			i++;
		}
		nodeInfo.setNodeDeviceInfo(nodeDeviceInfo);
		
		object1 = PropertyUtil.getPropertyValue(property, NodeConstant.FILE_SYSTEM_INDEX);
		object2 = PropertyUtil.getPropertyValue(property, NodeConstant.FILE_SYSTEM_MOUNT_POINT);
		object3 = PropertyUtil.getPropertyValue(property, NodeConstant.FILE_SYSTEM_DISPLAY_NAME);
		object4 = PropertyUtil.getPropertyValue(property, NodeConstant.FILE_SYSTEM_TYPE);
		object5 = PropertyUtil.getPropertyValue(property, NodeConstant.FILE_SYSTEM_OID);
		object6 = PropertyUtil.getPropertyValue(property, NodeConstant.FILE_SYSTEM_DESCRIPTION);
		ArrayList<NodeFilesystemInfo> nodeFilesystemInfo = new ArrayList<NodeFilesystemInfo>();
		i = 0;
		for (Object o : object1) {
			if (object1.get(i) != null && ! object1.get(i).toString().equals("")
					|| object2.get(i) != null && ! object2.get(i).toString().equals("")
					|| object3.get(i) != null && ! object3.get(i).toString().equals("")
					|| object4.get(i) != null && ! object4.get(i).toString().equals("")
					|| object5.get(i) != null && ! object5.get(i).toString().equals("")
					|| object6.get(i) != null && ! object6.get(i).toString().equals("")) {
				nodeFilesystemInfo.add(new NodeFilesystemInfo((Integer)object1.get(i),
						(String)object2.get(i),
						(String)object3.get(i),
						(String)object4.get(i),
						(String)object5.get(i),
						(String)object6.get(i)));
			}
			i++;
		}
		nodeInfo.setNodeFilesystemInfo(nodeFilesystemInfo);
		
		return nodeInfo;
	}
	
	public static Property node2property(NodeInfo node, int mode, Locale locale) {
		/** ローカル変数 */
		Property property = null;
		ArrayList propertyList = null;
		
		/** メイン処理 */
		property = getProperty(mode, locale);
		
		// ----- ファシリティ関連 -----
		// ファシリティID
		propertyList = PropertyUtil.getProperty(property, NodeConstant.FACILITY_ID);
		((Property)propertyList.get(0)).setValue(node.getFacilityId());
		
		// ファシリティ名
		propertyList = PropertyUtil.getProperty(property, NodeConstant.FACILITY_NAME);
		((Property)propertyList.get(0)).setValue(node.getFacilityName());
		
		// 説明
		propertyList = PropertyUtil.getProperty(property, NodeConstant.DESCRIPTION);
		((Property)propertyList.get(0)).setValue(node.getDescription());
		
		// 有効/無効
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VALID);
		((Property)propertyList.get(0)).setValue(node.isValid());
		
		// 登録ユーザID
		propertyList = PropertyUtil.getProperty(property, NodeConstant.CREATOR_NAME);
		((Property)propertyList.get(0)).setValue(node.getCreateUserId());
		
		// 登録日時
		if (node.getCreateDatetime() != null && node.getCreateDatetime().getTime() != 0) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.CREATE_TIME);
			((Property)propertyList.get(0)).setValue(new Date(node.getCreateDatetime().getTime()));
		}
		
		// 最終更新ユーザID
		propertyList = PropertyUtil.getProperty(property, NodeConstant.MODIFIER_NAME);
		((Property)propertyList.get(0)).setValue(node.getModifyUserId());
		
		// 最終更新日時
		if (node.getModifyDatetime() != null && node.getModifyDatetime().getTime() != 0) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.MODIFY_TIME);
			((Property)propertyList.get(0)).setValue(new Date(node.getModifyDatetime().getTime()));
		}
		
		// ----- ノード関連 -----
		// プラットフォーム
		propertyList = PropertyUtil.getProperty(property, NodeConstant.PLATFORM_FAMILY_NAME);
		((Property)propertyList.get(0)).setValue(node.getPlatformFamily());
		
		// H/Wタイプ
		propertyList = PropertyUtil.getProperty(property, NodeConstant.HARDWARE_TYPE);
		((Property)propertyList.get(0)).setValue(node.getHardwareType());
		
		// 画面アイコンイメージ
		propertyList = PropertyUtil.getProperty(property, NodeConstant.ICONIMAGE);
		((Property)propertyList.get(0)).setValue(node.getIconImage());	
		
		// ----- SNMP関連 -----
		// SNMPポート番号
		if (node.getSnmpPort() != null && node.getSnmpPort() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.SNMP_PORT);
			((Property)propertyList.get(0)).setValue(node.getSnmpPort());
		}
		
		// SNMPコミュニティ名
		propertyList = PropertyUtil.getProperty(property, NodeConstant.SNMP_COMMUNITY);
		((Property)propertyList.get(0)).setValue(node.getSnmpCommunity());
		
		// SNMPバージョン
		propertyList = PropertyUtil.getProperty(property, NodeConstant.SNMP_VERSION);
		((Property)propertyList.get(0)).setValue(node.getSnmpVersion());
		
		// SNMPタイムアウト
		if (node.getSnmpTimeout() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.SNMPTIMEOUT);
			((Property)propertyList.get(0)).setValue(node.getSnmpTimeout());
		}
		
		// SNMPリトライ回数
		if (node.getSnmpRetryCount() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.SNMPRETRIES);
			((Property)propertyList.get(0)).setValue(node.getSnmpRetryCount());
		}
		
		// SNMPプロキシ
		propertyList = PropertyUtil.getProperty(property, NodeConstant.SNMPPROXY);
		((Property)propertyList.get(0)).setValue(node.getSnmpProxy());
		
		// ----- WBEM関連 -----
		// WBEM接続ポート番号
		if (node.getWbemPort() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.WBEM_PORT);
			((Property)propertyList.get(0)).setValue(node.getWbemPort());
		}
		
		// WBEM接続ユーザ
		propertyList = PropertyUtil.getProperty(property, NodeConstant.WBEM_USER);
		((Property)propertyList.get(0)).setValue(node.getWbemUser());
		
		// WBEM接続ユーザパスワード
		propertyList = PropertyUtil.getProperty(property, NodeConstant.WBEM_USER_PASSWORD);
		((Property)propertyList.get(0)).setValue(node.getWbemUserPassword());
		
		// WBEM接続プロトコル
		propertyList = PropertyUtil.getProperty(property, NodeConstant.WBEM_PROTOCOL);
		((Property)propertyList.get(0)).setValue(node.getWbemProtocol());
		
		// WBEM接続タイムアウト
		if (node.getWbemTimeout() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.WBEM_TIMEOUT);
			((Property)propertyList.get(0)).setValue(node.getWbemTimeout());
		}
		
		// WBEM接続リトライ回数
		if (node.getWbemRetryCount() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.WBEM_RETRIES);
			((Property)propertyList.get(0)).setValue(node.getWbemRetryCount());
		}
		
		// ----- IPアドレス関連 -----
		// DHCPクライアント
		propertyList = PropertyUtil.getProperty(property, NodeConstant.DHCP_CLIENT);
		((Property)propertyList.get(0)).setValue(node.getDhcpClient());
		
		// IPタイプ
		if (node.getIpAddressType() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.IP_ADDRESS_TYPE);
			((Property)propertyList.get(0)).setValue(node.getIpAddressType());
		}
		
		// IPバージョン
		if (node.getIpAddressVersion() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.IP_ADDRESS_VERSION);
			((Property)propertyList.get(0)).setValue(node.getIpAddressVersion());
		}
		
		// IPアドレスV4
		propertyList = PropertyUtil.getProperty(property, NodeConstant.IP_ADDRESS_V4);
		((Property)propertyList.get(0)).setValue(node.getIpAddressV4());
		
		// IPアドレスV6
		propertyList = PropertyUtil.getProperty(property, NodeConstant.IP_ADDRESS_V6);
		((Property)propertyList.get(0)).setValue(node.getIpAddressV6());
		
		// ----- OS関連 -----
		// ノード名
		propertyList = PropertyUtil.getProperty(property, NodeConstant.NODE_NAME);
		((Property)propertyList.get(0)).setValue(node.getNodeName());
		
		// OS名
		propertyList = PropertyUtil.getProperty(property, NodeConstant.OS_NAME);
		((Property)propertyList.get(0)).setValue(node.getOsName());
		
		// OSリリース
		propertyList = PropertyUtil.getProperty(property, NodeConstant.OS_RELEASE);
		((Property)propertyList.get(0)).setValue(node.getOsRelease());
		
		// OSバージョン
		propertyList = PropertyUtil.getProperty(property, NodeConstant.OS_VERSION);
		((Property)propertyList.get(0)).setValue(node.getOsVersion());
		
		// 文字セット
		propertyList = PropertyUtil.getProperty(property, NodeConstant.CHARACTER_SET);
		((Property)propertyList.get(0)).setValue(node.getCharacterSet());
		
		// ----- VM関連 -----
		// 仮想化ノード種別
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VIRTNODETYPE);
		((Property)propertyList.get(0)).setValue(node.getVirtualizationNodeType());
		
		// 仮想マシン管理ノード
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VMMANAGEMENTNODE);
		((Property)propertyList.get(0)).setValue(node.getVmManagementNode());
		
		// 仮想マシンINDEX
		if (node.getVmIndex() != -1) {
			propertyList = PropertyUtil.getProperty(property, NodeConstant.VMINDEX);
			((Property)propertyList.get(0)).setValue(node.getVmIndex());
		}
		
		// 仮想マシン名
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VMNAME);
		((Property)propertyList.get(0)).setValue(node.getVmName());
		
		// 仮想化ソリューション
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VIRTSOLUTION);
		((Property)propertyList.get(0)).setValue(node.getVirtualizationSolution());
		
		// 仮想マシンID
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VMID);
		((Property)propertyList.get(0)).setValue(node.getVmId());
		
		// 仮想化ソフト接続ユーザ
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VMUSER);
		((Property)propertyList.get(0)).setValue(node.getVmUser());
		
		// 仮想化ソフト接続ユーザパスワード
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VMUSERPASSWORD);
		((Property)propertyList.get(0)).setValue(node.getVmUserPassword());
		
		// 仮想化ソフト接続プロトコル
		propertyList = PropertyUtil.getProperty(property, NodeConstant.VMPROTOCOL);
		((Property)propertyList.get(0)).setValue(node.getVmProtocol());
		
		// ----- 管理情報関連 -----
		// 連絡先
		propertyList = PropertyUtil.getProperty(property, NodeConstant.CONTACT);
		((Property)propertyList.get(0)).setValue(node.getContact());
		
		// 管理者
		propertyList = PropertyUtil.getProperty(property, NodeConstant.ADMINISTRATOR);
		((Property)propertyList.get(0)).setValue(node.getAdministrator());
		
		// ----- ホスト名 -----
		propertyList = PropertyUtil.getProperty(property, NodeConstant.HOST_NAME);
		Property parentHost = (Property)((Property)propertyList.get(0)).getParent();
		
		if (node.getNodeHostnameInfo() != null) {
			int index = PropertyUtil.getPropertyIndex(parentHost, (Property)propertyList.get(0));
			int cnt = 0;
			for (NodeHostnameInfo hostname : node.getNodeHostnameInfo()) {
				Property target = null;
				if (cnt == 0) {
					target = (Property)propertyList.get(0);
				} else {
					target = PropertyUtil.copy((Property)propertyList.get(0));
					parentHost.addChildren(target, index + cnt);
				}
				// ホスト名
				target.setValue(hostname.getHostname());
				cnt++;
			}
		}
				
		// ----- 備考 -----
		propertyList = PropertyUtil.getProperty(property, NodeConstant.NOTE);
		Property noteProperty = (Property)propertyList.get(0);
		if (node.getNodeNoteInfo() != null) {
			int index = PropertyUtil.getPropertyIndex(property, noteProperty);
			int cnt = 0;
			for (NodeNoteInfo note : node.getNodeNoteInfo()) {
				Property target = null;
				if (cnt == 0) {
					target = noteProperty;
				} else {
					target = PropertyUtil.copy(noteProperty);
					property.addChildren(target, index + cnt);
				}
				// 備考
				target.setValue(note.getNote());
				cnt++;
			}
		}
		
		// ----- デバイス情報 -----
		propertyList = PropertyUtil.getProperty(property, NodeConstant.DEVICE);
		Property deviceProperty = (Property)propertyList.get(0);
		if (node.getNodeDeviceInfo() != null) {
			int index = PropertyUtil.getPropertyIndex(property, deviceProperty);
			int cnt = 0;
			for (NodeDeviceInfo device : node.getNodeDeviceInfo()) {
				Property target = null;
				if (cnt == 0) {
					target = deviceProperty;
				} else {
					target = PropertyUtil.copy(deviceProperty);
					property.addChildren(target, index + cnt);
				}
				cnt++;
				
				// トップ表示情報（デバイス表示名）
				target.setValue(device.getDeviceDisplayName());
				
				// デバイス種別
				propertyList = PropertyUtil.getProperty(target, NodeConstant.DEVICE_TYPE);
				((Property)propertyList.get(0)).setValue(device.getDeviceType());
				
				// デバイスINDEX
				propertyList = PropertyUtil.getProperty(target, NodeConstant.DEVICE_INDEX);
				((Property)propertyList.get(0)).setValue(device.getDeviceIndex());
				
				// デバイス名
				propertyList = PropertyUtil.getProperty(target, NodeConstant.DEVICE_NAME);
				((Property)propertyList.get(0)).setValue(device.getDeviceName());
				
				// デバイス表示名
				propertyList = PropertyUtil.getProperty(target, NodeConstant.DEVICE_DISPLAY_NAME);
				((Property)propertyList.get(0)).setValue(device.getDeviceDisplayName());
				
				// デバイスOID
				propertyList = PropertyUtil.getProperty(target, NodeConstant.DEVICE_OID);
				((Property)propertyList.get(0)).setValue(device.getDeviceSnmpOid());
				
				// 説明
				propertyList = PropertyUtil.getProperty(target, NodeConstant.DEVICE_DESCRIPTION);
				((Property)propertyList.get(0)).setValue(device.getDeviceDescription());
			}	
		}
		
		// ---- ファイルシステム情報 -----
		propertyList = PropertyUtil.getProperty(property, NodeConstant.FILE_SYSTEM);
		Property fileSystemProperty = (Property)propertyList.get(0);
		if (node.getNodeFilesystemInfo() != null) {
			int index = PropertyUtil.getPropertyIndex(property, fileSystemProperty);
			int cnt = 0;
			for (NodeFilesystemInfo filesystem : node.getNodeFilesystemInfo()) {
				Property target = null;
				if (cnt == 0) {
					target = fileSystemProperty;
				} else {
					target = PropertyUtil.copy(fileSystemProperty);
					property.addChildren(target, index + cnt);
				}
				cnt++;
				
				// ファイルシステム表示名を表示
				target.setValue(filesystem.getFsDisplayName());
				
				// ファイルシステムINDEX
				propertyList = PropertyUtil.getProperty(target, NodeConstant.FILE_SYSTEM_INDEX);
				((Property)propertyList.get(0)).setValue(filesystem.getFsIndex());
				
				// マウント位置
				propertyList = PropertyUtil.getProperty(target, NodeConstant.FILE_SYSTEM_MOUNT_POINT);
				((Property)propertyList.get(0)).setValue(filesystem.getFsMountPoint());
				
				// ファイルシステム表示名
				propertyList = PropertyUtil.getProperty(target, NodeConstant.FILE_SYSTEM_DISPLAY_NAME);
				((Property)propertyList.get(0)).setValue(filesystem.getFsDisplayName());
				
				// ファイルシステム種別
				propertyList = PropertyUtil.getProperty(target, NodeConstant.FILE_SYSTEM_TYPE);
				((Property)propertyList.get(0)).setValue(filesystem.getFsType());
				
				// ファイルシステムOID
				propertyList = PropertyUtil.getProperty(target, NodeConstant.FILE_SYSTEM_OID);
				((Property)propertyList.get(0)).setValue(filesystem.getFsSnmpOid());
				
				// 説明
				propertyList = PropertyUtil.getProperty(target, NodeConstant.FILE_SYSTEM_DESCRIPTION);
				((Property)propertyList.get(0)).setValue(filesystem.getFsDescription());
			}
		}
		return property;
	}
	
	/**
	 * ノード用プロパティを返します。
	 * 
	 * @param mode
	 * @return ノード用プロパティ
	 */
	public static Property getProperty(int mode, Locale locale) {
		// 初期値のキャッシュが存在すれば、それを返す
		if (cachedInitProperty.containsKey(locale)) {
			if (cachedInitProperty.get(locale).containsKey(mode)) {
				return PropertyUtil.copy(cachedInitProperty.get(locale).get(mode));
			}
		} else {
			cachedInitProperty.put(locale, new HashMap<Integer, Property>());
		}
		
	    //ファシリティID
		Property facilityId =
			new Property(NodeConstant.FACILITY_ID, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//ファシリティ名
		Property facilityName =
			new Property(NodeConstant.FACILITY_NAME, Messages.getString("facility.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//説明
		Property description =
			new Property(NodeConstant.DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//有効/無効
		Property valid =
			new Property(NodeConstant.VALID, Messages.getString("management.object", locale), PropertyConstant.EDITOR_BOOL);
		
		//DHCPクライアント
		Property dhcpClient =
			new Property(NodeConstant.DHCP_CLIENT, Messages.getString("dhcp.client", locale), PropertyConstant.EDITOR_BOOL);
		//IPタイプ
		Property ipAddressType =
			new Property(NodeConstant.IP_ADDRESS_TYPE, Messages.getString("ip.address.type", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.SMALLINT_HIGH, 0);
		//IPバージョン
		Property ipAddressVersion =
			new Property(NodeConstant.IP_ADDRESS_VERSION, Messages.getString("ip.address.version", locale), PropertyConstant.EDITOR_SELECT);
		
		//IPアドレスV4
		Property ipAddressV4 =
			new Property(NodeConstant.IP_ADDRESS_V4, Messages.getString("ip.address.v4", locale), PropertyConstant.EDITOR_IPV4);
		//IPアドレスV6
		Property ipAddressV6 =
			new Property(NodeConstant.IP_ADDRESS_V6, Messages.getString("ip.address.v6", locale), PropertyConstant.EDITOR_IPV6);
		//ホスト名
		Property hostName =
			new Property(NodeConstant.HOST_NAME, Messages.getString("host.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//H/Wタイプ
		Property hardwareType =
			new Property(NodeConstant.HARDWARE_TYPE, Messages.getString("hardware.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//プラットフォーム
		Property platformFamilyName =
			new Property(NodeConstant.PLATFORM_FAMILY_NAME, Messages.getString("platform.family.name", locale), PropertyConstant.EDITOR_SELECT);
		//OS名
		Property osName =
			new Property(NodeConstant.OS_NAME, Messages.getString("os.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ノード名
		Property nodeName =
			new Property(NodeConstant.NODE_NAME, Messages.getString("node.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OSリリース
		Property osRelease =
			new Property(NodeConstant.OS_RELEASE, Messages.getString("os.release", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OSバージョン
		Property osVersion =
			new Property(NodeConstant.OS_VERSION, Messages.getString("os.version", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//文字セット
		Property characterSet =
			new Property(NodeConstant.CHARACTER_SET, Messages.getString("character.set", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//管理者
		Property administrator =
			new Property(NodeConstant.ADMINISTRATOR, Messages.getString("administrator", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//連絡先
		Property contact =
			new Property(NodeConstant.CONTACT, Messages.getString("contact", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//登録者
		Property createTime =
			new Property(NodeConstant.CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録日時
		Property creatorName =
			new Property(NodeConstant.CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//更新者
		Property modifyTime =
			new Property(NodeConstant.MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新日時
		Property modifierName =
			new Property(NodeConstant.MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);

		//デバイス表示名
		Property deviceDisplayName =
			new Property(NodeConstant.DEVICE_DISPLAY_NAME, Messages.getString("device.display.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイス名
		Property deviceName =
			new Property(NodeConstant.DEVICE_NAME, Messages.getString("device.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイスOID
		Property deviceOID =
			new Property(NodeConstant.DEVICE_OID, Messages.getString("device.oid", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイスINDEX
		Property deviceIndex =
			new Property(NodeConstant.DEVICE_INDEX, Messages.getString("device.index", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//デバイス種別
		Property deviceType =
			new Property(NodeConstant.DEVICE_TYPE, Messages.getString("device.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//説明
		Property deviceDescription =
			new Property(NodeConstant.DEVICE_DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//ファイルシステム表示名
		Property fileSystemDisplayName =
			new Property(NodeConstant.FILE_SYSTEM_DISPLAY_NAME, Messages.getString("file.system.display.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//マウント位置
		Property fileSystemMountPoint =
			new Property(NodeConstant.FILE_SYSTEM_MOUNT_POINT, Messages.getString("file.system.mount.point", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ファイルシステムOID
		Property fileSystemOID =
			new Property(NodeConstant.FILE_SYSTEM_OID, Messages.getString("file.system.oid", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ファイルシステムINDEX
		Property fileSystemIndex =
			new Property(NodeConstant.FILE_SYSTEM_INDEX, Messages.getString("file.system.index", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//ファイルシステム種別
		Property fileSystemType =
			new Property(NodeConstant.FILE_SYSTEM_TYPE, Messages.getString("file.system.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//説明
		Property fileSystemDescription =
			new Property(NodeConstant.FILE_SYSTEM_DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//SNMPポート番号
		Property snmpPort =
			new Property(NodeConstant.SNMP_PORT, Messages.getString("snmp.port.number", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.PORT_NUMBER_MAX, 0);
		//SNMPコミュニティ名
		Property snmpCommunity =
			new Property(NodeConstant.SNMP_COMMUNITY, Messages.getString("community.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//SNMPバージョン
		Property snmpVersion =
			new Property(NodeConstant.SNMP_VERSION, Messages.getString("snmp.version", locale), PropertyConstant.EDITOR_SELECT);
		
		//ネットワーク
		Property network = 
			new Property(NodeConstant.NETWORK, Messages.getString("network", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OS
		Property os = 
			new Property(NodeConstant.OS, Messages.getString("os", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//保守
		Property maintenance =
			new Property(NodeConstant.MAINTENANCE, Messages.getString("maintenance", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイス
		Property device =
			new Property(NodeConstant.DEVICE, Messages.getString("device", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ファイルシステム
		Property fileSystem =
			new Property(NodeConstant.FILE_SYSTEM, Messages.getString("file.system", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//SNMP
		Property snmp =
			new Property(NodeConstant.SNMP, Messages.getString("snmp", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//WBEM
		Property wbem =
			new Property(NodeConstant.WBEM, Messages.getString("wbem", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//SNMPタイムアウト
		Property snmpTimeout =
			new Property(NodeConstant.SNMPTIMEOUT, Messages.getString("snmp.timeout", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);

		//SNMPリトライ回数
		Property snmpRetries = 
			new Property(NodeConstant.SNMPRETRIES, Messages.getString("snmp.retries", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);

		//SNMPプロキシ
		Property snmpProxy = 
			new Property(NodeConstant.SNMPPROXY, Messages.getString("snmp.proxy", locale), PropertyConstant.EDITOR_SELECT);

		//備考
		Property note =
			new Property(NodeConstant.NOTE, Messages.getString("note", locale), PropertyConstant.EDITOR_TEXTAREA, DataRangeConstant.TEXT);
		
		//画面アイコンイメージ
		Property iconImage =
			new Property(NodeConstant.ICONIMAGE, Messages.getString("icon.image", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		Property virtualization = 
			new Property(NodeConstant.VIRTUALIZATION, Messages.getString("virtualization", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		
		//仮想化ノード種別
		Property virtNodeType =
			new Property(NodeConstant.VIRTNODETYPE, Messages.getString("virtualization.node.type", locale), PropertyConstant.EDITOR_SELECT);
		
		//仮想マシン管理ノード
		Property vmManagementNode =
			new Property(NodeConstant.VMMANAGEMENTNODE, Messages.getString("vm.management.node", locale), PropertyConstant.EDITOR_SELECT);
		
		//仮想マシンID
		Property vmIndex =
			new Property(NodeConstant.VMINDEX, Messages.getString("vm.index", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//仮想マシン名
		Property vmName =
			new Property(NodeConstant.VMNAME, Messages.getString("vm.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//仮想化ソリューション
		Property virtSolution =
			new Property(NodeConstant.VIRTSOLUTION, Messages.getString("virtualization.solution", locale), PropertyConstant.EDITOR_SELECT);

		
		//20090114
		
		//仮想マシンID
		Property vmId =
			new Property(NodeConstant.VMID, Messages.getString("vm.id", locale),  PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		//仮想化ソフト接続ユーザ
		Property vmUser =
			new Property(NodeConstant.VMUSER, Messages.getString("vm.user", locale),  PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		//仮想化ソフト接続ユーザパスワード
		Property vmUserPassword =
			new Property(NodeConstant.VMUSERPASSWORD, Messages.getString("vm.userpassword", locale),  PropertyConstant.EDITOR_PASSWORD, DataRangeConstant.VARCHAR_64);
		
		//仮想化ソフト接続プロトコル
		Property vmProtocol =
			new Property(NodeConstant.VMPROTOCOL, Messages.getString("vm.protocol", locale),  PropertyConstant.EDITOR_SELECT);

		//WBEM接続ユーザ
		Property wbemUser =
			new Property(NodeConstant.WBEM_USER, Messages.getString("wbem.user", locale),  PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//WBEM接続ユーザパスワード
		Property wbemUserPassword =
			new Property(NodeConstant.WBEM_USER_PASSWORD, Messages.getString("wbem.user.password", locale),  PropertyConstant.EDITOR_PASSWORD, DataRangeConstant.VARCHAR_64);
		//WBEM接続ポート番号
		Property wbemPort =
			new Property(NodeConstant.WBEM_PORT, Messages.getString("wbem.port.number", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.PORT_NUMBER_MAX, 0);
		//WBEM接続プロトコル
		Property wbemProtocol =
			new Property(NodeConstant.WBEM_PROTOCOL, Messages.getString("wbem.protocol", locale),  PropertyConstant.EDITOR_SELECT);
		//WBEM接続タイムアウト
		Property wbemTimeout =
			new Property(NodeConstant.WBEM_TIMEOUT, Messages.getString("wbem.timeout", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);
		//WBEM接続リトライ回数
		Property wbemRetries = 
			new Property(NodeConstant.WBEM_RETRIES, Messages.getString("wbem.retries", locale), PropertyConstant.EDITOR_NUM, Integer.MAX_VALUE, 0);

		
		
		//値を初期化
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
		valid.setValue(new Boolean(true));
		dhcpClient.setValue(new Boolean(false));
		ipAddressType.setValue("");
		
		Object ipVersionValue[][] = {
				{ "4", "6" },
				{ 4, 6 }
		};
		
		ipAddressVersion.setSelectValues(ipVersionValue);
		ipAddressVersion.setValue(4);
		ipAddressV4.setValue("");
		ipAddressV6.setValue("");
		hostName.setValue("");
		hardwareType.setValue("");
		
		platformFamilyName.setSelectValues(getPlatformNames());
		platformFamilyName.setValue("");
		
		osName.setValue("");
		nodeName.setValue("");
		osRelease.setValue("");
		osVersion.setValue("");
		characterSet.setValue("");
		administrator.setValue("");
		contact.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");
		
		deviceDisplayName.setValue("");
		deviceName.setValue("");
		deviceOID.setValue("");
		deviceIndex.setValue("");
		deviceType.setValue("");
		deviceDescription.setValue("");

		fileSystemDisplayName.setValue("");
		fileSystemMountPoint.setValue("");
		fileSystemOID.setValue("");
		fileSystemIndex.setValue("");
		fileSystemType.setValue("");
		fileSystemDescription.setValue("");
		
		Object snmpVersionValue[][] = {
				{ "", SnmpVersionConstant.STRING_V1, SnmpVersionConstant.STRING_V2 },
				{ "", SnmpVersionConstant.STRING_V1, SnmpVersionConstant.STRING_V2 }
		};
		snmpPort.setValue("");
		snmpCommunity.setValue("");
		snmpVersion.setSelectValues(snmpVersionValue);
		snmpVersion.setValue("");
		
		os.setValue("");
		network.setValue("");
		maintenance.setValue("");
		device.setValue("");
		fileSystem.setValue("");
		snmp.setValue("");
		
		snmpProxy.setSelectValues(getFacilityIdAndFacilityName());
		snmpProxy.setValue("");
		snmpTimeout.setValue("");
		snmpRetries.setValue("");
		snmpPort.setValue("");
		
		note.setValue("");
		
		iconImage.setValue("");
		
		virtNodeType.setValue("");
		Object vmNodeTypeValue[][] = {
				{ "", "controller", "host", "guest" },
				{ "", "controller", "host", "guest" }
		};
		
		virtualization.setValue("");
		virtNodeType.setSelectValues(vmNodeTypeValue);
		virtNodeType.setValue("");
		vmManagementNode.setSelectValues(getHostFacilityIdAndFacilityName());
		vmManagementNode.setValue("");
		vmIndex.setValue("");
		vmName.setValue("");
		virtSolution.setSelectValues(getVmSolutionNames());
		virtSolution.setValue("");
		
		//20090114
		vmId.setValue("");
		vmUser.setValue("");
		vmUserPassword.setValue("");
		vmProtocol.setSelectValues(getVmProtocol());
		vmProtocol.setValue("");
		
		Object wbemProtocolValue[][] = {
				{"", "http"},
				{"", "http"}
		};
		
		wbem.setValue("");
		wbemUser.setValue("");
		wbemUserPassword.setValue("");
		wbemPort.setValue("");
		wbemProtocol.setSelectValues(wbemProtocolValue);
		wbemProtocol.setValue("");
		wbemTimeout.setValue("");
		wbemRetries.setValue("");
		

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			facilityId.setModify(PropertyConstant.MODIFY_OK);
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			valid.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceDisplayName.setModify(PropertyConstant.MODIFY_OK);
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			fileSystemDisplayName.setModify(PropertyConstant.MODIFY_OK);
			fileSystemMountPoint.setModify(PropertyConstant.MODIFY_OK);
			fileSystemOID.setModify(PropertyConstant.MODIFY_OK);
			fileSystemIndex.setModify(PropertyConstant.MODIFY_OK);
			fileSystemType.setModify(PropertyConstant.MODIFY_OK);
			fileSystemDescription.setModify(PropertyConstant.MODIFY_OK);
			
			snmpPort.setModify(PropertyConstant.MODIFY_OK);
			snmpCommunity.setModify(PropertyConstant.MODIFY_OK);
			snmpVersion.setModify(PropertyConstant.MODIFY_OK);
			
			snmpTimeout.setModify(PropertyConstant.MODIFY_OK);
			snmpRetries.setModify(PropertyConstant.MODIFY_OK);
			snmpProxy.setModify(PropertyConstant.MODIFY_OK);
			
			note.setModify(PropertyConstant.MODIFY_OK);
			
			iconImage.setModify(PropertyConstant.MODIFY_OK);

			virtNodeType.setModify(PropertyConstant.MODIFY_OK);
			vmManagementNode.setModify(PropertyConstant.MODIFY_OK);
			vmIndex.setModify(PropertyConstant.MODIFY_OK);
			vmName.setModify(PropertyConstant.MODIFY_OK);
			virtSolution.setModify(PropertyConstant.MODIFY_OK);
			
			//20090114 add
			vmId.setModify(PropertyConstant.MODIFY_OK);
			vmUser.setModify(PropertyConstant.MODIFY_OK);
			vmUserPassword.setModify(PropertyConstant.MODIFY_OK);
			vmProtocol.setModify(PropertyConstant.MODIFY_OK);
			
			wbemUser.setModify(PropertyConstant.MODIFY_OK);
			wbemUserPassword.setModify(PropertyConstant.MODIFY_OK);
			wbemPort.setModify(PropertyConstant.MODIFY_OK);
			wbemProtocol.setModify(PropertyConstant.MODIFY_OK);
			wbemTimeout.setModify(PropertyConstant.MODIFY_OK);
			wbemRetries.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			note.setCopy(PropertyConstant.COPY_OK);
			note.setModify(PropertyConstant.MODIFY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
			fileSystem.setCopy(PropertyConstant.COPY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
			valid.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceDisplayName.setModify(PropertyConstant.MODIFY_OK);
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			fileSystemDisplayName.setModify(PropertyConstant.MODIFY_OK);
			fileSystemMountPoint.setModify(PropertyConstant.MODIFY_OK);
			fileSystemOID.setModify(PropertyConstant.MODIFY_OK);
			fileSystemIndex.setModify(PropertyConstant.MODIFY_OK);
			fileSystemType.setModify(PropertyConstant.MODIFY_OK);
			fileSystemDescription.setModify(PropertyConstant.MODIFY_OK);
			
			snmpPort.setModify(PropertyConstant.MODIFY_OK);
			snmpCommunity.setModify(PropertyConstant.MODIFY_OK);
			snmpVersion.setModify(PropertyConstant.MODIFY_OK);
			
			snmpTimeout.setModify(PropertyConstant.MODIFY_OK);
			snmpRetries.setModify(PropertyConstant.MODIFY_OK);
			snmpProxy.setModify(PropertyConstant.MODIFY_OK);
			
			note.setModify(PropertyConstant.MODIFY_OK);
			
			iconImage.setModify(PropertyConstant.MODIFY_OK);

			virtNodeType.setModify(PropertyConstant.MODIFY_OK);
			vmManagementNode.setModify(PropertyConstant.MODIFY_OK);
			vmIndex.setModify(PropertyConstant.MODIFY_OK);
			vmName.setModify(PropertyConstant.MODIFY_OK);
			virtSolution.setModify(PropertyConstant.MODIFY_OK);
			
			//20090114 add
			vmId.setModify(PropertyConstant.MODIFY_OK);
			vmUser.setModify(PropertyConstant.MODIFY_OK);
			vmUserPassword.setModify(PropertyConstant.MODIFY_OK);
			vmProtocol.setModify(PropertyConstant.MODIFY_OK);

			wbemUser.setModify(PropertyConstant.MODIFY_OK);
			wbemUserPassword.setModify(PropertyConstant.MODIFY_OK);
			wbemPort.setModify(PropertyConstant.MODIFY_OK);
			wbemProtocol.setModify(PropertyConstant.MODIFY_OK);
			wbemTimeout.setModify(PropertyConstant.MODIFY_OK);
			wbemRetries.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			note.setCopy(PropertyConstant.COPY_OK);
			note.setModify(PropertyConstant.MODIFY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
			fileSystem.setCopy(PropertyConstant.COPY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		property.addChildren(platformFamilyName);
		property.addChildren(hardwareType);
		property.addChildren(iconImage);
		property.addChildren(valid);
		property.addChildren(network);
		property.addChildren(os);
		property.addChildren(virtualization);
		property.addChildren(maintenance);
		property.addChildren(device);
		property.addChildren(fileSystem);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);
		property.addChildren(note);
		
		// ネットワークツリー
		network.removeChildren();
		network.addChildren(snmp);
		network.addChildren(wbem);
		network.addChildren(dhcpClient);
		network.addChildren(ipAddressType);
		network.addChildren(ipAddressVersion);
		network.addChildren(ipAddressV4);
		network.addChildren(ipAddressV6);
		network.addChildren(hostName);
		
		// SNMPツリー
		snmp.removeChildren();
		snmp.addChildren(snmpPort);
		snmp.addChildren(snmpCommunity);
		snmp.addChildren(snmpVersion);
		snmp.addChildren(snmpTimeout);
		snmp.addChildren(snmpRetries);
		snmp.addChildren(snmpProxy);

		// WBEMツリー
		wbem.removeChildren();
		wbem.addChildren(wbemUser);
		wbem.addChildren(wbemUserPassword);
		wbem.addChildren(wbemPort);
		wbem.addChildren(wbemProtocol);
		wbem.addChildren(wbemTimeout);
		wbem.addChildren(wbemRetries);
		
		// OSツリー
		os.removeChildren();
		os.addChildren(nodeName);
		os.addChildren(osName);
		os.addChildren(osRelease);
		os.addChildren(osVersion);
		os.addChildren(characterSet);
		
		
		// 仮想化ツリー
		virtualization.removeChildren();
		virtualization.addChildren(virtNodeType);
		virtualization.addChildren(vmManagementNode);
		virtualization.addChildren(vmIndex);
		virtualization.addChildren(vmName);
		virtualization.addChildren(virtSolution);
		
		virtualization.addChildren(vmId);
		virtualization.addChildren(vmUser);
		virtualization.addChildren(vmUserPassword);
		virtualization.addChildren(vmProtocol);

		
		// 保守ツリー
		maintenance.removeChildren();
		maintenance.addChildren(administrator);
		maintenance.addChildren(contact);
		
		// デバイスツリー
		device.removeChildren();
		device.addChildren(deviceDisplayName);
		device.addChildren(deviceName);
		device.addChildren(deviceOID);
		device.addChildren(deviceIndex);
		device.addChildren(deviceType);
		device.addChildren(deviceDescription);
		
		
		// ファイルシステムツリー
		fileSystem.removeChildren();
		fileSystem.addChildren(fileSystemDisplayName);
		fileSystem.addChildren(fileSystemIndex);
		fileSystem.addChildren(fileSystemMountPoint);
		fileSystem.addChildren(fileSystemOID);
		fileSystem.addChildren(fileSystemType);
		fileSystem.addChildren(fileSystemDescription);
		
		// 初期値をキャッシュに登録（次回から高速化に初期値を取得）
		cachedInitProperty.get(locale).put(mode, PropertyUtil.copy(property));
		
		return property;
	}
	/**
	 * プラットフォーム情報（プラットフォームIDおよびプラットフォーム名）を返す。<BR>
	 * 戻り値は、下記の構成の2次元配列（Object[][]）である。<BR>
	 * <PRE>
	 * {
	 *    {platformId1, platformId2, ...},  
	 *    {platformName1, platformName2, ...}
	 * }
	 * </PRE>
	 * 
	 * @return プラットフォーム情報の2次元配列
	 */
	private static Object[][] getPlatformNames() {
		/** ローカル変数 */
		Object[][] table = null;
		//Collection platforms = null;
		ArrayList<RepositoryTableInfo> platforms = null;
		ArrayList<String> platformIdList = null;
		ArrayList<String> platformNameList = null;
		
		/** メイン処理 */
		try {
			platformIdList = new ArrayList<String>();
			platformNameList = new ArrayList<String>();
			table = new Object[2][platformIdList.size()];
			
			RepositoryController repository = EjbConnectionManager
					.getConnectionManager().getRepositoryController();
			
			platforms = repository.getPlatformList();
			
			if (platforms != null) {
				for (RepositoryTableInfo platform : platforms) {
					platformIdList.add(platform.getId());
					platformNameList.add(platform.getName() + "(" + platform.getId() + ")");
				}
			}
			
			table[PropertyConstant.SELECT_VALUE] = platformIdList.toArray();
			table[PropertyConstant.SELECT_DISP_TEXT] = platformNameList.toArray();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		
		return table;
	}
	
	/**
	 * ファシリティ情報（ファシリティIDおよびファシリティ名）を返す。<BR>
	 * 戻り値は、下記の構成の2次元配列（Object[][]）である。<BR>
	 * <PRE>
	 * {
	 *    {facilityId1, facilityId2, ...}, 
	 *    {facilityName1(facilityId1), facilityName2(facilityId2), ...}
	 * }
	 * </PRE>
	 * 
	 * @return ファシリティ情報の2次元配列
	 */
	private static Object[][] getFacilityIdAndFacilityName() {
		/** ローカル変数 */
		Object[][] table = null;
		ArrayList<NodeInfo> nodes = null;
		ArrayList<String> facilityIdList = null;
		ArrayList<String> facilityNameList = null;
		
		/** メイン処理 */
		try {
			facilityIdList = new ArrayList<String>();
			facilityNameList = new ArrayList<String>();
			table = new Object[2][facilityIdList.size()];
			
			RepositoryController repository = EjbConnectionManager
			.getConnectionManager().getRepositoryController();
			
			nodes = repository.getNodeList("", 0);
			
			facilityIdList.add("");
			facilityNameList.add("");
			if (nodes != null) {
				for (NodeInfo node : nodes) {
					facilityIdList.add(node.getFacilityId());
					facilityNameList.add(node.getFacilityName() + "(" + node.getFacilityId() + ")" );
				}
			}
			
			table[PropertyConstant.SELECT_VALUE] = facilityIdList.toArray();
			table[PropertyConstant.SELECT_DISP_TEXT] = facilityNameList.toArray();
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		
		return table;
	}
	/**
	 * 仮想化->ノード種別がhost, controllerのファシリティ情報（ファシリティIDおよびファシリティ名）を返す。<BR>
	 * 戻り値は、下記の構成の2次元配列（Object[][]）である。<BR>
	 * <PRE>
	 * {
	 *    {facilityId1, facilityId2, ...}, 
	 *    {facilityName1(facilityId1), facilityName2(facilityId2), ...}
	 * }
	 * </PRE>
	 * 
	 * @return ファシリティ情報の2次元配列
	 */
	private static Object[][] getHostFacilityIdAndFacilityName() {
		/** ローカル変数 */
		Object[][] table = null;
		ArrayList<RepositoryTableInfo> nodes = null;
		ArrayList<String> facilityIdList = null;
		ArrayList<String> facilityNameList = null;
		
		/** メイン処理 */
		try {
			facilityIdList = new ArrayList<String>();
			facilityNameList = new ArrayList<String>();
			table = new Object[2][facilityIdList.size()];
			
			RepositoryController repository = EjbConnectionManager
			.getConnectionManager().getRepositoryController();
			
			nodes = repository.getHostList();
			
			facilityIdList.add("");
			facilityNameList.add("");
			if (nodes != null) {
				for (RepositoryTableInfo node : nodes) {
					facilityIdList.add(node.getId());
					facilityNameList.add(node.getName() + "(" + node.getId() + ")" );
				}
			}
			facilityIdList.add("UNALLOCATED");
			facilityNameList.add(Messages.getString("vm.scope.unallocated") +
					"(UNALLOCATED)");
			
			table[PropertyConstant.SELECT_VALUE] = facilityIdList.toArray();
			table[PropertyConstant.SELECT_DISP_TEXT] = facilityNameList.toArray();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		
		return table;
	}
	
	
	/**
	 * 仮想化ソリューション情報（仮想化ソフトソリューションIDおよび仮想化ソリューション名）を返す。<BR>
	 * 戻り値は、下記の構成の2次元配列（Object[][]）である。<BR>
	 * <PRE>
	 * {
	 *    {vmSolutionId1, vmSolutionId2, ...}, 
	 *    {vmSolutionName1(vmSolutionId1), vmSolutionName2(vmSolutionId2), ...}
	 * }
	 * </PRE>
	 * 
	 * @return 仮想化ソリューション情報の2次元配列
	 */
	private static Object[][] getVmSolutionNames() {
		/** ローカル変数 */
		Object[][] table = null;
		ArrayList<RepositoryTableInfo> vmSolutions = null;
		ArrayList<String> vmSolutionIdList = new ArrayList<String>();
		ArrayList<String> vmSolutionNameList = new ArrayList<String>();
		
		/** メイン処理 */
		try {
			table = new Object[2][vmSolutionIdList.size()];
			
			RepositoryController repository = EjbConnectionManager
					.getConnectionManager().getRepositoryController();

			vmSolutions = repository.getVmSolutionMstList();
		
			new ArrayList<String>();	vmSolutionIdList.add("");
			vmSolutionNameList.add("");
			if (vmSolutions != null) {
				for (RepositoryTableInfo vmSolution : vmSolutions) {
					vmSolutionIdList.add(vmSolution.getId());
					vmSolutionNameList.add(vmSolution.getName() + "(" + vmSolution.getId() + ")");
				}
			}
			
			table[PropertyConstant.SELECT_VALUE] = vmSolutionIdList.toArray();
			table[PropertyConstant.SELECT_DISP_TEXT] = vmSolutionNameList.toArray();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		
		return table;
	}
	
	/**
	 * 仮想化プロトコル情報（仮想化プロトコル名）を返す。<BR>
	 * 戻り値は、下記の構成の2次元配列（Object[][]）である。<BR>
	 * <PRE>
	 * {
	 *    {vmProtocolName1, vmProtocolName2, ...}, 
	 *    {vmProtocolName1, vmProtocolName2, ...}
	 * }
	 * </PRE>
	 * 
	 * @return 仮想化プロトコル情報の2次元配列
	 */
	private static Object[][] getVmProtocol() {
		/** ローカル変数 */
		Object[][] table = null;
		ArrayList<RepositoryTableInfo> vmProtocols = null;
		ArrayList<String> vmProtocolList = new ArrayList<String>();
		
		/** メイン処理 */
		try {
			table = new Object[2][vmProtocolList.size()];
			
			RepositoryController repository = EjbConnectionManager
					.getConnectionManager().getRepositoryController();

			vmProtocolList = repository.getVmProtocolMstList();
			
			vmProtocolList.add("");
			if (vmProtocols != null) {
				for (RepositoryTableInfo vmProtocol : vmProtocols) {
					vmProtocolList.add(vmProtocol.getName());
				}
			}
			
			table[PropertyConstant.SELECT_VALUE] = vmProtocolList.toArray();
			table[PropertyConstant.SELECT_DISP_TEXT] = vmProtocolList.toArray();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		
		return table;
	}
	
}
