/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.EJBException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.repository.util.NodePropertyUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ノードの変更などを行うクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 1.0.0
 */
public class ModifyNodeProperty {

    // ----- instance メソッド ----- //

    /**
     * 指定したノードについて、属性の変更を行います。<BR>
     * 
     * @param property
     *            属性情報
     * @return 変更に成功した場合、true
     */
    public boolean edit(Property property) {
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);

        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        boolean result = false;
        try {
        	NodeInfo nodeinfo = NodePropertyUtil.property2node(copy);
            repository.modifyNode(nodeinfo);
            result = true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
	            
			} else if (e.getCause() instanceof EJBException) {
				String errMsg = "";
				Throwable cause = e.getCause();
				while (cause != null) {
					errMsg += cause.getMessage() + "\n";
					cause = cause.getCause();
				}
				MessageDialog.openError(null, Messages.getString("failed"), Messages.getString("message.repository.11") + "\n\n--\n" + errMsg);
				return result;
			}
        } catch (Exception e) {
        	e.printStackTrace();
        }
        
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.repository.10"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.repository.11"));
		}
    	
		// リポジトリキャッシュの更新
		if(result)
			FacilityTree.reflesh();
		
    	return result;
    }

    /**
     * 指定したスコープに属する全てのノードについて、属性の変更を行います。
     * 
     * @param property
     * @param facilityId
     * @return
     */
    public boolean editAllInScope(Property property, String facilityId) {
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);

        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        boolean result = false;
        try {
        	NodeInfo nodeinfo = NodePropertyUtil.property2node(copy);
            repository.modifyNode(nodeinfo, facilityId);
            result = true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.repository.10"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.repository.11"));
		}
    	
		// リポジトリキャッシュの更新
		if(result)
			FacilityTree.reflesh();

    	return result;
    }
}