/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.repository.action;

import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;


import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.repository.util.NodePropertyUtil;
import com.clustercontrol.util.Messages;

/**
 * SNMPを利用してノードの情報を取得するクライアント側アクションクラス<BR>ޤ���
 * 
 * @version 2.3.0
 * @since 2.1.2
 */
public class GetNodePropertyBySNMP {
	
	// ----- instance メソッド ----- //
	 
  /**
   *SNMPを利用してノード情報を生成します。<BR>
   *
   * @param pollingData SNMPポーリングのためのIPアドレスなど
   * @param mode 編集可否モード
   * @return ノード情報のプロパティ
   */
	public Property  search(String ipAddress, int port, String community, String version,int mode) {
		
		RepositoryController repository = EjbConnectionManager
		.getConnectionManager().getRepositoryController();
		
		try {
			NodeInfo nodeInfo = repository.getNodePropertyBySNMP(ipAddress, port, community, version);
			return NodePropertyUtil.node2property(nodeInfo, mode, Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
			
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
        } catch (UnknownHostException e) {
		} catch (FacilityNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}
		return null;
	}
}