/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.repository.util.NodePropertyUtil;
import com.clustercontrol.util.Messages;

/**
 * ノード属性情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeProperty {

    /**
     * ノード属性情報を取得します。
     * 
     * @param facilityId
     * @param property
     * @return ノード属性情報
     */
    public Property getProperty(String facilityId, int mode) {
        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        Property property = null;
        try {
            NodeInfo nodeInfo = repository.getNode(facilityId);
            property = NodePropertyUtil.node2property(nodeInfo, mode, Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FacilityNotFoundException e) {
			// FIXME
        	// 指定のファシリティがマネージャに存在しない。
        	// 何も表示しない。
		}
        return property;
    }
}