/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.UsedFacilityException;
import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.PluginConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * スコープを削除するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteScopeProperty {

    /**
     * 指定したスコープを削除します。
     * 
     * @param facilityId
     *            ファシリティID
     * @return 削除に成功した場合、true
     */
    public boolean delete(String facilityId) {
        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        boolean result = false;
        try {
            repository.deleteScope(facilityId);
            result = true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (UsedFacilityException e) {
			// ファシリティが使用されている場合のエラーダイアログを表示する
        	Object[] args ={facilityId, PluginConstant.typeToString(e.getPlugin())};
            MessageDialog.openInformation(null, Messages.getString("message"),
                    Messages.getString("message.repository.27", args));
        }
        
		// リポジトリキャッシュの更新
		if(result)
			FacilityTree.reflesh();
		
        return result;
    }
}