/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import java.util.Date;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.dialog.RealtimeSetDialog2;
import com.clustercontrol.performance.view.RecordGraphView;

/**
 * 収集済みデータのリスト表示を行うViewクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class RecordSetGraphAction2 implements IViewActionDelegate {
	
	/** アクションID */
	public static final String ID = "com.clustercontrol.performance.view.action.RecordSetGraphAction2";
	
    private RealtimeSetDialog2 dialog;

    private static RecordGraphView performanceView = new RecordGraphView();

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
    	//        this.viewPart = view;
    }

    /**
     * 実績グラフの設定ダイアログ（プロット数）を表示します。
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.com.realtimemonitor.action.IAction)
     */
    //グラフ表示する条件を登録するダイアログの表示とアクション。
    public void run(IAction action) {
        /*
         * 呼び出し元のViewを持ってきます。
         */
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        RecordGraphView view = (RecordGraphView) page.findView(RecordGraphView.ID);

        if (view.collectorInfo.getCollectStartTime() == null) {
        	return; //何もしない.
        }

        Shell shell = new Shell();
        dialog = new RealtimeSetDialog2(shell);
        
        
        Date local_startTime = view.collectorInfo.getGraphStartTime();
        Date local_endTime = view.collectorInfo.getGraphEndTime();
        int local_graphPlotNum = view.collectorInfo.getGraphPlotNum();
        
        
        dialog.setCollectorInfo(view.collectorInfo);
        dialog.setCollectorItemInfo(view.collectorItemInfo);
        dialog.setInterval(false);
        dialog.update();
        
        int ret = dialog.open();
        
        // 条件設定ダイアログでOKボタンが押下されたときの処理
        if (ret == IDialogConstants.OK_ID) {
            /*
             * サブスコープ数が10を超えかつサブスコープ代表値を表示しようとした時の警告ダイアログ
             *     いちいちダイアログがでると面倒。基本的にはエラーダイアログは表示しない。
             */
        	if (local_startTime != view.collectorInfo.getGraphStartTime()
        			|| local_endTime != view.collectorInfo.getGraphEndTime()
      			  || local_graphPlotNum != view.collectorInfo.getGraphPlotNum()) {
      		  view.update();
      	  }
        } else if (ret == IDialogConstants.CANCEL_ID) {
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.com.realtimemonitor.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}