/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.performance.monitor.util.EjbConnectionManager;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfController;
import com.clustercontrol.util.Messages;

/**
 * リソース監視情報を削除するクラス
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class DeletePerformance {

    /**
     * リソース監視情報を削除します。
     * 
     * @param monitorId 状態監視ID
     * @return 削除に成功した場合、true
     */
    public boolean delete(String monitorId) {
    	
    	MonitorPerfController ctr = EjbConnectionManager.getConnectionManager()
				.getMonitorPerfController();

		boolean result = false;
		try {
			result = ctr.deletePerformance(monitorId);
			return result;
		} catch (RemoteException e) {
			if (e instanceof AccessException) {
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages
						.getString("message"), Messages
						.getString("message.accesscontrol.16"));
			}
		} catch (MonitorNotFoundException e) {
			e.printStackTrace();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		}

		return false;
    }
}