/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite;

import java.util.Date;
import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performance.util.Messages;

/**
 * 複数の実績グラフのコンポジットをまとめて表示するコンポジットクラス
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class RecordGraphHolderComposite extends Composite {
    private Label collectorIdLabel;

//    private Label scopeLabel;

    private Composite baseComposite = null;

    private RecordGraphComposite[] graphCompList = null;

//    private String collectorID; // 表示対象の収集ID

//    private String currentPath; // グラフ表示しているスコープパス
    
    // グラフ表示の開始時刻
    private Date graphStartTime;
    
    // グラフ表示の終了時刻
    private Date graphEndTime;

    // 表示対象となる収集プロファイル
    CollectorProperty collectorProperty;
    
    // グラフの設定
//    private GraphProperty[] graphPropertys;

//    DrawRecordGraphAction で持つためここで保持する必要はない
//    // グラフ表示用データ
//    private RecordCollectorData collectorData;
//
//    private List itemInfoList;
//
//    private FacilityTreeItem facilityTree;

    /**
     * コンストラクター
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     */
    public RecordGraphHolderComposite(Composite parent, int style,
            int maxGraphSize) {
        super(parent, style);
        
        graphCompList = new RecordGraphComposite[maxGraphSize]; // グラフ表示領域を生成
               
        initialize();
    }

    /**
     * GUIを初期化
     *  
     */
    private void initialize() {
    	
    	this.setLayoutData(new GridData(GridData.FILL_BOTH));
    	
        collectorIdLabel = new Label(this, SWT.NONE);
        collectorIdLabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        baseComposite = new Composite(this, SWT.NONE);
        baseComposite.setLayout(new FillLayout(SWT.VERTICAL));
        baseComposite.setLayoutData(new GridData(GridData.FILL_BOTH));
        
    	// RecordGraphCompositeを生成
//        for(int graphIndex=0; graphIndex < graphCompList.length; graphIndex++){
//        	if (graphCompList[graphIndex] == null) {
//        		// グラフを表示する各々のcompositeを生成
//        		graphCompList[graphIndex] = new RecordGraphComposite(baseComposite);
//        		graphCompList[graphIndex].setVisible(false);
//        	}
//        }

        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;	
        this.setLayout(gridLayout);
    }

    /**
     * グラフ描画用のデータを設定します。
     *  
     * @param collectorData 実績収集定義
     * @param itemInfoList 収集項目
     * @param facilityTree ファシリティツリー
     */
    public void setMasterData(
    		CollectorProperty collectorProperty){
        this.collectorProperty = collectorProperty;
    	
        // 収集開始時刻をグラフ表示の基点とする
        graphStartTime = collectorProperty.getCollectorData().getStartDate();
        
        // 現時点での最終収集時刻
        graphEndTime = collectorProperty.getCollectorData().getLastCollectDate();
        
//    	RecordCollectorData collectorData = collectorProperty.getCollectorData();
//    	List<CollectorItemInfo> itemInfoList = collectorProperty.getItemList();

//    	// グラフ表示領域を消去
//    	if (graphCompList != null) {
//    		for (int i = 0; i < this.graphCompList.length; i++) {
//    			if(graphCompList[i] != null){
//    				graphCompList[i].dispose();
//    				graphCompList[i] = null;
//    			}
//    		}
//    	}

    	// RecordGraphCompositeを生成
//    	initialize();
    }
    
    /**
     * 指定の設定でグラフを再表示します。
     *  
     * @param graphProperty グラフ描画設定（グラフの数分のリスト）
     */
    public void redrawGraph(
    		int graphNum , 
    		String facilityId, 
    		String itemCode, 
    		String displayName, 
    		int graphType,
    		int graphForm,
    		Date startTime, 
    		Date endTime,
    		boolean isXRangeAuto,
    		int graphPlotNum) {
//        this.graphPropertys = graphProperty;
//   		baseComposite.setLayout(new FillLayout(SWT.VERTICAL));
//   		baseComposite.setLayoutData(new GridData(GridData.FILL_BOTH));
    	
        // 表示対象スコープの要素をツリーから見つける
		FacilityTreeItem targetFacility = selectFacilityTreeItem(
				collectorProperty.getCollectorData().getFacilityTree(),
				facilityId);

		// ラベルを設定
        setLabel(collectorProperty.getCollectorData().getCollectorID(),
        		targetFacility);
		
		// 表示対象の収集項目
		CollectorItemInfo targetItem = null;

		// 収集対象プロパティの収集項目リストの中から対象の要素を抽出する
		Iterator<CollectorItemInfo> itr = collectorProperty.getItemList().iterator();
		while(itr.hasNext()){
			CollectorItemInfo itemInfo = itr.next();
			if(itemInfo.getItemCode().equals(itemCode) && 
					itemInfo.getDisplayName().equals(displayName)){
				targetItem = itemInfo;
			}
		}

		// 対象のファシリティもしくは収集項目が見つからない場合はグラフ表示しない
        if(targetFacility == null || targetItem == null){
        	return;
        }
		
        // グラフ描画
        // グラフ種別が非表示の場合
        if (graphType == GraphProperty.INVISIBLE){
        	// ここでは何もしない。
        }
        // グラフ種別がサブスコープ代表値であるが、サブスコープの数が0の場合
        else if (graphType == GraphProperty.TYPE3
        		&& targetFacility.getChildren().length == 0) {

        	graphCompList[graphNum] = new RecordGraphComposite(baseComposite, 
        			Messages.getString("NOT_EXIST_SUBSCOPE"));	// "サブスコープが存在しないので表示されません."
        } 
        // グラフ種別がサブスコープ代表値であるが、サブスコープの数が10以上の場合
        else if (graphType == GraphProperty.TYPE3 
        		&& targetFacility.getChildren().length > 10){
    		// グラフ表示しない。(現行仕様)
			// ラベルで「スコープ数が10を超えているので表示しない」旨を表示する。
			// 今は仮決めで10を固定で条件指定している。あとで変数(定数)の持ち方を決める。

    		graphCompList[graphNum] = new RecordGraphComposite(baseComposite,
    				Messages.getString("MSG_SUB_SCOPE_COUNTS_OVER_10"));	// "サブスコープが10を超えて存在するので表示されません."        	
        } else {
        	// グラフを表示する各々のcompositeを生成
        	if (graphCompList[graphNum] == null) {
        		// グラフを表示する各々のcompositeを生成
        		graphCompList[graphNum] = new RecordGraphComposite(baseComposite);
        		// 収集情報を設定
    			graphCompList[graphNum].setMasterData(collectorProperty.getCollectorData(), 
    					collectorProperty.getItemList());
        		
//        		graphCompList[graphNum].setVisible(true);
//        		graphCompList[graphNum].layout();
//        		baseComposite.layout();
//        		this.layout();
//        		baseComposite.layout();
//        		graphCompList[graphNum].layout();
        	}
        	
        	// 描画開始時刻がnullの場合は収集開始時刻とする
        	if(startTime == null){
        		startTime = graphStartTime;
        	}

        	// 描画終了時刻がnullの場合は最終収集時刻とする
        	if(endTime == null){
        		endTime = graphEndTime;
        	}
        	
        	// プロット数を設定する
        	// プロットで自動が選択されていない場合
        	if(!isXRangeAuto) {
        		graphCompList[graphNum].setPlot(graphPlotNum);
        		endTime = graphEndTime;
        	}
        		
        	// compositeに対する操作であることに注意。
        	// RecordGraphCompositeの描画処理を実行
        	graphCompList[graphNum].drawGraph(
        			new GraphProperty(targetFacility, targetItem, graphType, graphForm), 
        			startTime,
        			endTime);
        }
    }

    /**
     * 同じファシリティIDの要素があった場合（ノードの場合）は初めに見つけたものを返す。
     * @param tree
     * @param facilityId
     * @return
     */
    private FacilityTreeItem selectFacilityTreeItem(FacilityTreeItem treeItem, String facilityId){
    	
    	if(treeItem.getData().getFacilityId().equals(facilityId)){
    		return treeItem;
    	}
    	
    	for(int i=0; i<treeItem.getChildren().length; i++){
    		FacilityTreeItem child = treeItem.getChildren()[i];
    		
    		// 子要素を再帰的に捜査する
    		FacilityTreeItem ret = selectFacilityTreeItem(child, facilityId);
    		
    		// 子要素でマッチするものが見つかった場合
    		if(ret != null){
    			return ret;
    		}
    	}
    	
    	// 一致するものが見つからなかった場合はnullを返す
    	return null;
    }

    /**
     * 指定のグラフ領域を削除する
     * 
     * @param index
     */
    public void disposeGraph() {
    	
    	for(int i=0; i<graphCompList.length; i++){
    		if (graphCompList[i] != null) {
    			graphCompList[i].dispose();
    			graphCompList[i] = null;
    		}
    	}
    }

    /**
     * ラベルを設定します。
     */
    private void setLabel(String collectorId, FacilityTreeItem targetFacility) {
//        FacilityPath fp = new FacilityPath(Messages.getString("SEPARATOR"));
//    	String currentPath = fp.getPath(targetFacility);
    	
        collectorIdLabel.setText(Messages.getString("COLLECTION_ID") + " : " + collectorId);
//        scopeLabel.setText(Messages.getString("SCOPE") +  " : "  + currentPath);
    }

//    /**
//     * グラフの表示設定を返します。
//     * 
//     * @return GraphProperty
//     */
//    public GraphProperty[] getGraphPropertys() {
//        return this.graphPropertys;
//    }

    /**
     * 収集IDを取得します。
     * 
     * @return collectorID
     */
//    public String getCollectorID() {
//        return collectorID;
//    }

//	public Date getGraphEndTime() {
//		return graphEndTime;
//	}
//
//	public Date getGraphStartTime() {
//		return graphStartTime;
//	}
}