/*
 
 Copyright (C) 2009 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.util.Messages;

/**
 * 収集を実行した際にDBに格納されるデータの物理サイズ見積りを表示するコンポジット
 */
public class EstimationComposite extends Composite {
	// 見積り表示用ラベル
	private Label estimationLabel1 = null;

	public EstimationComposite(Composite parent, int style, boolean checkEstimationSize) {
		super(parent, style);
		
		this.createContents();
	}

	/**
	 * コンポジットを生成します。
	 */
	protected void createContents() {
		this.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		GridLayout layout = new GridLayout(22, true);
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		this.setLayout(layout);

		GridData gridData = null;

		// 見積りラベル（自身のサイズ見積りを表示）
		Label label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 3;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("SIZE_ESTIMATION") +":");
		
		estimationLabel1 = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		estimationLabel1.setLayoutData(gridData);
		estimationLabel1.setAlignment(SWT.RIGHT); // 右寄せで表示
	}
	
	/**
	 * 更新します。
	 */
	public void update(CollectorProperty property) {
		super.update();
		
		RecordController controller = RecordController.getInstance();

		if(controller != null){
			// 指定の収集プロパティのサイズ見積りを実施
			if(property != null){
				long calcDataSize = controller.getEstimation(property);
				if(calcDataSize >= 0){
					double calcDataSizeMB = ((double)calcDataSize) / 1024 / 1024;
					estimationLabel1.setText(
							String.format("%.0f MByte", Math.ceil(calcDataSizeMB))
					);
				} else {
					// 見積りに失敗した場合は、-1が返る
					estimationLabel1.setText("-1 MByte");
				}
			}
		}
	}
}
