/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.action;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jnp.interfaces.NamingContext;
import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.performance.composite.RealtimeGraphComposite;
import com.clustercontrol.performance.util.CollectorItemCodeFactory;
import com.clustercontrol.performance.util.RealtimeCollectThread;
import com.clustercontrol.performance.util.RealtimeCollectorInfo;
import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.bean.CollectorItemInfo;
import com.clustercontrol.performance.ejb.session.CollectorController;
import com.clustercontrol.performance.ejb.session.CollectorControllerHome;
import com.clustercontrol.util.LoginManager;
//FIXME　解読困難

/**
 * マネージャとのやり取りを行うコントローラクラス（リアルタイムグラフ用）
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class RealtimeController {
    private static int RETRYCOUNT = 1; // エラー発生時のリトライ回数

    private Collection<CollectedDataInfo> dataCollection;

    private static RealtimeController m_instance = null;

    private CollectorController bean;

    private boolean isRun = false;
    
    private static boolean running = false;
    
//    private RealtimeGraphView view;
    
//    private static Composite local_parent = null;
    
	private RealtimeCollectorInfo collectorInfo = null;
    
    private Date startTimestamp;

    private Iterator<CollectedDataInfo> itr;

    public static final String KEY_EJB_URL = "ejbUrl";

    public static final String VALUE_EJB_URL = "jnp://localhost:1099";

    /**
     * コンストラクター
     * シングルトンとするため他のクラスからインスタンスの生成ができないようにします。
     */
    private RealtimeController() {
    	initialize();
    }
    private void initialize() {
    }
    
    /**
     * インスタンスを生成して返します(セッションビーンの生成に失敗した場合は、nullを返します)。
     * 
     * @return マネージャとのやり取りを行うコントローラクラスのインスタンス
     */
    public static synchronized RealtimeController getInstance() {
        if (m_instance == null) {
            m_instance = new RealtimeController();
            m_instance.createBean();
        }
        // セッションビーンを取得できない場合は、エラー値としてnullを返します。
        if (m_instance.bean == null) {
            m_instance = null;
            return null;
        } else {
            return m_instance;
        }    
    }
    
    /**
     * リアルタイムグラフ描画設定情報を設定します。
     * 
     * @param collectorInfo リアルタイムグラフ描画設定情報
     */
    public void setCollectorInfo(RealtimeCollectorInfo collectorInfo) {
    	this.collectorInfo = collectorInfo;
    }
    
    /**
     * マネージャにSessionBeanを生成します。
     *  
     */
    private void createBean() {
        try {
            // EJBオブジェクトを生成する。
            this.bean = getCollectorControllerHome().create();
        } catch (RemoteException e) {
            this.bean = null;
        } catch (CreateException e) {
            this.bean = null;
        } catch (NamingException e) {
            this.bean = null;
        }
    }
    
    
    /**
     * ホームインターフェースを取得します
     * 
     * @return ホームインターフェース
     * @throws NamingException
     */
    private CollectorControllerHome getCollectorControllerHome()
            throws NamingException {
        return (CollectorControllerHome) getContext().lookup(
                CollectorControllerHome.JNDI_NAME);
    }

    /**
     * NamingContextを取得します。
     * 
     * @return NamingContext
     * @throws NamingException
     */
    private NamingContext getContext() throws NamingException {

    	NamingContext namingContext = LoginManager.getContextManager().getNamingContext();
        
        return namingContext;
    }

    /**
     * 接続先URLを取得します。
     * 
     * @return String 接続先URL
     */
    private String getUrl() {

        //リソースストアから接続先URLを取得
        IPreferenceStore store = ClusterControlPlugin.getDefault()
                .getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }

        return url;
    }

// FIXME タイムスタンプを利用している理由を調査する
    /**
     * リアルタイム収集を開始します。
     * 
     * @param timestamp
     * @param timestampId
     * @param interval
     * @param requestInterval
     * @param collector
     * @param itemCode
     * @param deviceIndex
     * @param deviceName
     * @param displayType
     * @param facilityId
     * @param check 今は使われていない
     * @param graphComposite
     */
    public void startCollect(
    		Date timestamp,
    		int timestampId,    		
    		int interval,
    		int requestInterval,
    		RealtimeCollectThread collector,
    		//checkは今では使われていないと判断。呼び出しもとは常にfalseをセット。
    		String itemCode,
    		String displayName,
    		String displayType,
    		String displayForm,
    		String facilityId,
    		boolean check,
    		RealtimeGraphComposite graphComposite) {

    	ArrayList<CollectorItemInfo> itemList = new ArrayList<CollectorItemInfo>();

    	if (displayType.equals("SelectedScope") || displayType.equals("SubScope")) {
    		// (subScopeNumber > 0)のチェックは、グラフを作成する前(スコープ選択時)に
    		//チェックすべき。(内訳がないものはグラフ表示ない旨画面表示できるようにする)

    		itemList.add(new CollectorItemInfo(
    				null,	// collectionID,
    				itemCode,	//collectorItemCode,
    				displayName));
    	} else if (displayType.equals("Detail")) {
    		// 内訳表示に必要な収集項目コードを取得
    		List<String> itemCodeList = CollectorItemCodeFactory.getSubItemCode(itemCode);

    		for (int i = 0; i < itemCodeList.size(); i++) {
    			itemList.add(new CollectorItemInfo(
    					null,	// collectionID,
    					itemCodeList.get(i),	//collectorItemCode,
    					displayName));
    		}
    	}

        CollectorController myBean = null;
        CollectorItemInfo[] cii = null;

        // 収集条件の通知
        try {
            // EJBオブジェクトを生成する。
            myBean = getCollectorControllerHome().create();

            // 収集を開始する。
            cii = new CollectorItemInfo[itemList.size()];
            itemList.toArray(cii);
            // ここで指定するinterval(収集間隔)は、マネージャ側での収集間隔。
            // クライアントからのデータ収集実行の実行間隔とは分離して扱う。
            myBean.createRealtimeColletor(facilityId, requestInterval, itemList);
        } catch (CreateException e) {
        } catch (NamingException e) {
        } catch (RemoteException e) {
        }
        
        running = true;
        
        setStartTimestamp();

  	  //synchronizedにするため、dataCollectionをArrayListで初期化
  	  dataCollection = new ArrayList();
      while (collectorInfo.isCurrentCollect(timestamp, timestampId)) {
    	  
    	  // 上記のcreate()の結果、やはり生成できない可能性があるため、再度チェック
        	if (myBean != null) {
        		try {
        			//dataCollectionを複数スレッドが共有するため、描画までロックする
        			synchronized (dataCollection) {
        				// 特定の項目の収集値を取得する。戻り値は CollectedDataInfo 型のCollection。
        				if (displayType.equals("SelectedScope")) {
        					dataCollection = myBean.getRealtimeCollectedData(
        							facilityId,
        							itemCode,
        							displayName);
        				} else if (displayType.equals("Detail")) {
        					dataCollection = myBean.getRealtimeCollectedDataAll(
        							facilityId);
        					
        				} else if (displayType.equals("SubScope")) {
        					dataCollection = myBean.getSubScopeRealtimeCollectedData(facilityId, itemCode, displayName);
        					
        				}

	                    if (dataCollection != null) { //nullの場合の動作ロジックを後で記述する.
	                    	itr = dataCollection.iterator();
	                    	isRun = collector.setDataList(itr, displayType, displayForm); // 取得した情報を渡す
	                    }

                    }	//end synchronized
                    
                    try {
                    	Thread.sleep(interval * 1000); 
                    } catch (InterruptedException e) {
                    	return;
                    } // end try
                    
                } catch (RemoteException e) {
                	e.printStackTrace();
                    myBean = null;
                    dataCollection = new ArrayList<CollectedDataInfo>();
                } // end try.
            } // end if.

            // while文のくり返しでのsleep。この方式だと、処理時間分だけグラフ表示がずれていく。対処する。
        } // end while
    }

//FIXME 同じ処理をするメソッドが違う名前で定義されている。
    /**
     * run状態(ループで収集するときにくり返すか否かをチェックするステータス情報)を変更します。
     * 
     * @param _running ループで収集するときにくり返すか否かをチェックするステータス情報
     */
    public void changeRunning(boolean _running) {
    	running = _running;
    }

    /**
     * run状態(ループで収集するときにくり返すか否かをチェックするステータス情報)を確認します。
     * 
     * @return ループで収集するときにくり返すか否かをチェックするステータス情報
     */
    public static boolean isRunning() {
		return running;
	}

    /**
     * run状態(ループで収集するときにくり返すか否かをチェックするステータス情報)を設定します。
     * 
     * @param _running ループで収集するときにくり返すか否かをチェックするステータス情報
     */
	public static void setRunning(boolean _running) {
		running = _running;
	}

	/**
	 * 収集開始時刻を取得します。
	 * 
	 * @return 収集開始時刻
	 */
	public Date getStartTimestamp() {
		return this.startTimestamp;
	}

	/**
	 * 収集開始時刻を設定します。
	 * 
	 * @return 収集開始時刻
	 */
	public void setStartTimestamp() {
		startTimestamp = new Date(System.currentTimeMillis());
	}
}