/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.clustercontrol.ClusterControlPlugin;

/**
 * 性能管理プラグインクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class PerformancePlugin extends AbstractUIPlugin {

    /** プラグインのインスタンス */
    private static PerformancePlugin plugin;

    /** リソースバンドルインスタンス */
    private ResourceBundle resourceBundle;

    /**
     * 性能管理プラグインのインスタンスを返します。
     * 
     * @return 性能管理プラグインのインスタンス
     */ 
    public PerformancePlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("com.clustercontrol.performance.PerformancePluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    /**
     * プラグイン 開始。
     * プラグインの活性化の際に呼ばれます。
     * 
     * @param context BundleContextオブジェクト
     * @throws Exception
     * 
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    @Override
	public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * プラグイン 停止。
     * プラグインの非活性化の際に呼ばれます。
     * 
     * @param context BundleContextオブジェクト
     * @throws Exception
     * 
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    @Override
	public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * 性能管理プラグインのインスタンスを返します。
     * 
     * @return 性能管理プラグインのインスタンス
     */ 
    public static PerformancePlugin getDefault() {
        return plugin;
    }

    /**
     * 性能管理プラグインのリソースバンドルから、
     * キーに該当する文字列を返します。
     * 
     * @param key キー
     * @return 文字列。リソースバンドルが無い場合、もしくは指定した文字列 が存在しない場合は、keyを返します。
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = ClusterControlPlugin.getDefault()
                .getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
	 * 性能管理プラグインのリソースバンドルを返します。
	 * 
	 * @return リソースバンドル
	 */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }
}