/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.mail.bean.MailTemplateTableDefine;
import com.clustercontrol.util.Messages;

/**
 * メールテンプレート情報一覧のテーブル定義情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class GetMailTemplateListTableDefine {

    /**
     * メールテンプレート情報一覧のテーブル定義情報を返します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * 
     * @see com.clustercontrol.notify.mail.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerBean#getMailTemplateListTableDefine(java.util.Locale)
     */
    public static ArrayList<TableColumnInfo> get() {
		/** テーブル情報定義配列 */
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();
		
		tableDefine.add(MailTemplateTableDefine.MAIL_TEMPLATE_ID,
				new TableColumnInfo(Messages.getString("mail.template.id", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		
		tableDefine.add(MailTemplateTableDefine.DESCRIPTION,
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		
		tableDefine.add(MailTemplateTableDefine.CREATE_USER,
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		tableDefine.add(MailTemplateTableDefine.CREATE_TIME,
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		
		tableDefine.add(MailTemplateTableDefine.UPDATE_USER,
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		tableDefine.add(MailTemplateTableDefine.UPDATE_TIME,
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
				
		return tableDefine;
    }
}