/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.bean.NotifyTableDefine;
import com.clustercontrol.util.Messages;

/**
 * 通知情報一覧のテーブル定義情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNotifyListTableDefine {

    /**
     * 通知情報一覧のテーブル定義情報を返します。<BR>
     * マネージャにSessionBean経由でアクセスします。
     * 
     * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * 
     * @see com.clustercontrol.notify.util.EjbConnectionManager
	 * @see com.clustercontrol.notify.ejb.session.NotifyController
	 * @see com.clustercontrol.notify.ejb.session.NotifyControllerBean#getNotifyListTableDefine(java.util.Locale)
     */
    public static ArrayList<TableColumnInfo> get() {
		/** テーブル情報定義配列 */
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();
				
		tableDefine.add(NotifyTableDefine.SELECTION,
				new TableColumnInfo("", TableColumnInfo.CHECKBOX, 30, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.VALID_FLG,
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.NOTIFY_ID, 
				new TableColumnInfo(Messages.getString("notify.id", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 250, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.NOTIFY_TYPE, 
				new TableColumnInfo(Messages.getString("notify.type.list", locale), TableColumnInfo.NOTIFY_TYPE, 100, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.CREATE_USER, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.UPDATE_USER, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(NotifyTableDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		
		return tableDefine;
    }
}