/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.ConvertListUtil;
import com.clustercontrol.monitor.util.EjbConnectionManager;

/**
 * 監視[スコープ]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、スコープ一覧情報を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetFilterScope {

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //

    /**
     * マネージャにSessionBean経由でアクセスし、スコープ情報一覧を取得します。
     * 
     * @param facilityId 取得対象の親ファシリティID
	 * @return スコープ情報一覧（Objectの2次元配列）
     * @throws AccessException
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getScopeList(String)
     */
    public ArrayList getFilterInfo(String facilityId) throws AccessException {

        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        ArrayList records = null;
        try {
            records = monitor.getScopeList(facilityId, true, true, false);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合
				throw (AccessException) e;
			}
        } catch (CreateException e) {
        } catch (NamingException e) {
        } catch (FacilityNotFoundException e) {
		} catch (HinemosUnknownException e) {
		}
        return ConvertListUtil.scopeInfoDataListToArrayList(records);
    }
    
}