/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.ConvertListUtil;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ステータス情報を削除するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、ステータス情報を削除します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class DeleteStatus {

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定されたステータス情報一覧を削除します。
     * <p>指定されたリストには、各ステータス情報のリスト（{@link ArrayList}）が格納されています。
	 * また、１ステータス情報の各値は、テーブルのカラム順（{@link com.clustercontrol.monitor.bean.StatusTableDefine}）にリストに格納されています。
	 * <p>
	 * <dl>
	 *  <dt>ステータス情報一覧（Objectの2次元配列）</dt>
	 *  <dd>{ ステータス情報1 {カラム1の値, カラム2の値, … }, ステータス情報2{カラム1の値, カラム2の値, …}, … }</dd>
	 * </dl>
	 * 
     * @param list 削除対象のステータス情報一覧（Objectの2次元配列）
	 * @return 削除に成功した場合、</code> true </code>
	 * 
	 * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
	 * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#deleteStatus(List)
     */
    public boolean delete(List list) {
    	
    	
    	ArrayList statusList = new ArrayList();
    	statusList = ConvertListUtil.listToStatusInfoDataList(list);

//      if (list != null && list.size()>0) {
    	if (statusList != null && statusList.size()>0) {
        	
            MonitorController monitor = EjbConnectionManager
                    .getConnectionManager().getMonitorController();

            try {
//                monitor.deleteStatus(list);
                monitor.deleteStatus(statusList);
                return true;
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// アクセス権なしの場合、エラーダイアログを表示する
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
            } catch (RemoveException e) {
            } catch (FinderException e) {
            } catch (NamingException e) {
            } catch (Exception e) {
            }
        }
        return false;
    }
}