/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.composite;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.maintenance.action.GetMaintenanceListTableDefine;
import com.clustercontrol.maintenance.action.GetSchedule;
import com.clustercontrol.maintenance.bean.MaintenanceTableDefine;
import com.clustercontrol.maintenance.bean.ScheduleTableDefine;

/**
 * メンテナンス情報一覧コンポジットクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 */
public class MaintenanceListComposite extends Composite {

    // ----- instance フィールド ----- //

    /** テーブルビューア */
    private CommonTableViewer tableViewer = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent
     *            親のコンポジット
     * @param style
     *            スタイル
     */
    public MaintenanceListComposite(Composite parent, int style) {
        super(parent, style);

        this.initialize();
    }

    // ----- instance メソッド ----- //

    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // テーブルビューアの作成
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetMaintenanceListTableDefine.get(),
        		MaintenanceTableDefine.SORT_COLUMN_INDEX,
        		MaintenanceTableDefine.SORT_ORDER);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;

        this.update();
    }

    /**
     * tableViewerを返します。
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * コンポジットを更新します。
     * <p>
     * 
     */
    @Override
	@SuppressWarnings("unchecked")
	public void update() {
        // データ取得
    	
    	/*
    	 * メンテナンス情報とスケジュール情報が別テーブルにあるため、それぞれ取得する。
    	 * 一覧テーブルのスケジュールカラムに表示するための情報を、
    	 * maintenanceListにセットしてtableViewerに渡す
    	 */
    	ArrayList<ArrayList> maintenanceList = new GetMaintenance().getMaintenanceList();
    	ArrayList<ArrayList> scheduleList = new GetSchedule().getScheduleList();

       	for (int i = 0; i < maintenanceList.size(); i++) {
       		ArrayList maintenanceInfo = maintenanceList.get(i);
       		String maintenaneId = (String) maintenanceInfo.get(0);
       		for (int j = 0; j < scheduleList.size(); j++){
       			ArrayList schedule = scheduleList.get(j);
       			if (maintenaneId.equals(schedule.get(ScheduleTableDefine.JOB_ID))) {
       				maintenanceInfo.set(MaintenanceTableDefine.SCHEDULE, schedule.get(ScheduleTableDefine.SCHEDULE));
       			}
       		}
//       		System.out.println("maintenanceinfo : " + maintenanceInfo.toString());
       	}
	
        // テーブル更新
        this.tableViewer.setInput(maintenanceList);
    }
    
    
    /**
     * 選択された行のメンテナンスIDを取得する
     * 
     * @return 
     */
    public ArrayList<String> getSelectionData() {
    	
    	ArrayList<String> data = new ArrayList<String>();
    	
    	//選択されたアイテムを取得
    	StructuredSelection selection = 
    		(StructuredSelection)tableViewer.getSelection();
    	List list = selection.toList();
    	
    	if (list != null) {
    		for(int index = 0; index < list.size(); index++){
    			
    			ArrayList info = (ArrayList)list.get(index);
    			if (info != null && info.size() > 0) {
    				String maintenanceId = (String)info.get(MaintenanceTableDefine.MAINTENANCE_ID);
    				data.add(maintenanceId);
    			}
    		}
    	}
    	
    	return data;
    }
}