/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.logtransfer.bean.LogTransferFileTabelDefine;
import com.clustercontrol.util.Messages;

/**
 * 転送対象ログファイル一覧テーブル定義情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetLogTransferFileListTableDefine {
	
	/**
	 * 転送対象ログファイル一覧のテーブル定義情報を返します。
	 * 
	 * @return 転送対象ログファイル一覧テーブル定義情報
	 */
	public static ArrayList<TableColumnInfo> get() {
		
		/** テーブル情報定義配列 */
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(LogTransferFileTabelDefine.FILE_PATH, 
				new TableColumnInfo(Messages.getString("file.path", locale), TableColumnInfo.NONE, 300, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.RUN_INTERVAL, 
				new TableColumnInfo(Messages.getString("semantics.interval.sec", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.FILE_EXISTENCE_CHECK, 
				new TableColumnInfo(Messages.getString("file.first.existence.check", locale), TableColumnInfo.CHECKBOX, 170, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));
		
		return tableDefine;
	}
}