/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.jobmanagement.composite.NodeDetailComposite;
import com.clustercontrol.jobmanagement.view.action.StartJobAction;
import com.clustercontrol.jobmanagement.view.action.StopJobAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * ジョブ[ノード詳細]ビュークラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobNodeDetailView extends CommonViewPart {
	/** ビューID */
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobNodeDetailView";
    /** ジョブ[ノード詳細]ビュー用のコンポジット */
    private NodeDetailComposite m_nodeDetail = null;

    /**
     * コンストラクタ
     */
    public JobNodeDetailView() {
        super();
    }

    /**
     * ビューを構築します。
     * 
     * @param parent 親コンポジット
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     * @see #createContextMenu()
     * @see #update(String, String)
     */
    @Override
	public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_nodeDetail = new NodeDetailComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_nodeDetail.setLayoutData(gridData);

        //ポップアップメニュー作成
        createContextMenu();

        //ビューの更新
        this.update(null, null, null);
    }

    /**
     * コンテキストメニューを作成します。
     * 
     * @see org.eclipse.jface.action.MenuManager
     * @see org.eclipse.swt.widgets.Menu
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //メニュー項目設定
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_nodeDetail.getTable());
        m_nodeDetail.getTable().setMenu(menu);
    }

    /**
     * コンテキストメニューに項目を追加します。
     * 
     * @param manager メニューマネージャ
     * 
     * @see org.eclipse.jface.action.IToolBarManager
     * @see org.eclipse.jface.action.IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ビューのアクションのインスタンスを取得
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem startJobAction = (ActionContributionItem) toolbar
                .find(StartJobAction.ID);
        ActionContributionItem stopJobAction = (ActionContributionItem) toolbar
                .find(StopJobAction.ID);

        //ポップアップメニューにアクションを追加
        manager.add(startJobAction.getAction());
        manager.add(stopJobAction.getAction());
    }

    /**
     * ビューを更新します。
     * 
     * @param sessionId セッションID
     * @param jobunitId 所属ジョブユニットのジョブID
     * @param jobuId ジョブID
     * 
     * @see com.clustercontrol.jobmanagement.composite.NodeDetailComposite#update(String, String)
     */
    public void update(String sessionId, String jobunitId, String jobId) {
        m_nodeDetail.update(sessionId, jobunitId, jobId);
    }

    /**
     * ジョブ[ノード詳細]ビュー用のコンポジットを返します。
     * 
     * @return ジョブ[ノード詳細]ビュー用のコンポジット
     */
    public NodeDetailComposite getComposite() {
        return m_nodeDetail;
    }
    
    /**
     * ビューのアクションの有効/無効を設定します。
     * 
     * @param num 選択イベント数
     * @param selection ボタン（アクション）を有効にするための情報
     */
    public void setEnabledAction(int num, ISelection selection) {
    	//ビューアクションの使用可/不可を設定
    	super.setEnabledAction(StartJobAction.ID, selection);
    	super.setEnabledAction(StopJobAction.ID, selection);
    	
    	if (num > 0){
        	super.setEnabledAction(StartJobAction.ID, true);
        	super.setEnabledAction(StopJobAction.ID, true);
    	} else {
        	super.setEnabledAction(StartJobAction.ID, false);
        	super.setEnabledAction(StopJobAction.ID, false);
    	}
    }
}