/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.clustercontrol.jobmanagement.composite.RunScheduleListComposite;
import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;

/**
 * ジョブ[実行予定]ビューのテーブルビューア用のSelectionChangedListenerです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunScheduleSelectionChangedListener implements ISelectionChangedListener {
    /** ジョブ[実行予定]ビューの左側用のコンポジット */
	protected RunScheduleListComposite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite ジョブ[実行予定]ビューの左側用のコンポジット
     */
    public RunScheduleSelectionChangedListener(RunScheduleListComposite composite) {
        m_composite = composite;
    }

    /**
     * 選択変更時に呼び出されます。<BR>
     * ジョブ[実行予定]ビューのテーブルビューアを選択した際に、選択した行の内容でジョブ[実行予定詳細]ビューを更新します。
     * <P>
     * <ol>
	 * <li>選択変更イベントから選択行を取得し、選択行からスケジュールIDを取得します。</li>
	 * <li>スケジュールIDをジョブ[実行予定]ビューの左側用のコンポジットに設定します。</li>
	 * <li>ジョブ[実行予定詳細]ビューを更新します。</li>
	 * </ol>
	 * 
     * @param event 選択変更イベント
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        String scheduleId = null;
        String jobunitId = null;
        
        //ジョブIDを取得
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            scheduleId = (String) info.get(RunScheduleListTableDefine.SCHE_ID);
            jobunitId = (String) info.get(RunScheduleListTableDefine.JOBUNIT_ID);
            //スケジュールIDを設定
            m_composite.setScheduleId(scheduleId);
            
        }

        //アクティブページを手に入れる
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        //ビューを更新する
        IViewPart viewPart = page.findView(RunScheduleDetailListView.ID);
        if (viewPart != null) {
        	RunScheduleDetailListView view = (RunScheduleDetailListView) viewPart
                    .getAdapter(RunScheduleDetailListView.class);
            view.update(scheduleId, jobunitId);
        }
    }
}

