/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.util.Messages;

/**
 * 通知先の指定タブ用のコンポジットクラスです。
 * 
 * @version 3.0.0
 * @since 2.0.0
 */
public class NotificationsComposite extends Composite {
	/** 正常重要度用コンボボックス */
    protected Combo m_normalPriority = null;
    /** 警告重要度用コンボボックス */
    protected Combo m_warningPriority = null;
    /** 異常重要度用コンボボックス */
    protected Combo m_abnormalPriority = null;
    /** 開始重要度用コンボボックス */
    protected Combo m_startPriority = null;
    /** 通知ID */
    protected NotifyIdListComposite m_notifyId = null;
    /** ジョブ通知情報のリスト */
    protected ArrayList m_notifications = null;

    /**
     * コンストラクタ
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * 
     * @see org.eclipse.swt.SWT
     * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
     * @see #initialize()
     */
    public NotificationsComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * コンポジットを構築します。
     */
    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 1;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;
        
        //タイトル
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label dummy = new Label(composite, SWT.NONE);
        dummy.setLayoutData(new RowData(40, SizeConstant.SIZE_LABEL_HEIGHT));

        Label importanceDegreeTitle = new Label(composite, SWT.CENTER);
        importanceDegreeTitle.setText(Messages.getString("priority"));
        importanceDegreeTitle.setLayoutData(new RowData(80,
                SizeConstant.SIZE_LABEL_HEIGHT));

        //開始
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label beginningTitle = new Label(composite, SWT.CENTER);
        beginningTitle.setText(EndStatusConstant.STRING_BEGINNING + " : ");
        beginningTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));

        m_startPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_startPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_startPriority.add(PriorityConstant.STRING_INFO);
        m_startPriority.add(PriorityConstant.STRING_WARNING);
        m_startPriority.add(PriorityConstant.STRING_CRITICAL);
        m_startPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_startPriority.add(PriorityConstant.STRING_NONE);

        //正常
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label normalTitle = new Label(composite, SWT.CENTER);
        normalTitle.setText(EndStatusConstant.STRING_NORMAL + " : ");
        normalTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        normalTitle.setBackground(EndStatusColorConstant.COLOR_NORMAL);

        m_normalPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_normalPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_normalPriority.add(PriorityConstant.STRING_INFO);
        m_normalPriority.add(PriorityConstant.STRING_WARNING);
        m_normalPriority.add(PriorityConstant.STRING_CRITICAL);
        m_normalPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_normalPriority.add(PriorityConstant.STRING_NONE);

        //警告
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label warningTitle = new Label(composite, SWT.CENTER);
        warningTitle.setText(EndStatusConstant.STRING_WARNING + " : ");
        warningTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        warningTitle.setBackground(EndStatusColorConstant.COLOR_WARNING);

        m_warningPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_warningPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_warningPriority.add(PriorityConstant.STRING_INFO);
        m_warningPriority.add(PriorityConstant.STRING_WARNING);
        m_warningPriority.add(PriorityConstant.STRING_CRITICAL);
        m_warningPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_warningPriority.add(PriorityConstant.STRING_NONE);
        
        //異常
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);

        Label abnormalTitle = new Label(composite, SWT.CENTER);
        abnormalTitle.setText(EndStatusConstant.STRING_ABNORMAL + " : ");
        abnormalTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        abnormalTitle.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);

        m_abnormalPriority = new Combo(composite, SWT.CENTER | SWT.READ_ONLY);
        m_abnormalPriority.setLayoutData(new RowData(100,
                SizeConstant.SIZE_COMBO_HEIGHT));
        m_abnormalPriority.add(PriorityConstant.STRING_INFO);
        m_abnormalPriority.add(PriorityConstant.STRING_WARNING);
        m_abnormalPriority.add(PriorityConstant.STRING_CRITICAL);
        m_abnormalPriority.add(PriorityConstant.STRING_UNKNOWN);
        m_abnormalPriority.add(PriorityConstant.STRING_NONE);
        
        //通知ID
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout(rowLayout);
        
        Label notifyIdTitle = new Label(composite, SWT.CENTER);
        notifyIdTitle.setText(Messages.getString("notify.id") + " : ");
        notifyIdTitle.setLayoutData(new RowData(50,
                SizeConstant.SIZE_LABEL_HEIGHT));
        
        m_notifyId = new NotifyIdListComposite(composite, SWT.NONE, false);
        m_notifyId.setLayoutData(new RowData(330,
                SizeConstant.SIZE_BUTTON_HEIGHT + 60 ));
    }

    /**
     * ジョブ通知情報をコンポジットに反映します。
     * 
     * @see com.clustercontrol.jobmanagement.bean.JobNotificationsInfo
     */
    public void reflectNotificationsInfo() {
        if (m_notifications instanceof ArrayList) {
            JobNotificationsInfo infoNormal = null;
            JobNotificationsInfo infoWarning = null;
            JobNotificationsInfo infoAbnormal = null;
            JobNotificationsInfo infoStart = null;

            for (int i = 0; i < m_notifications.size(); i++) {
                if (((JobNotificationsInfo) m_notifications.get(i)).getType() == EndStatusConstant.TYPE_BEGINNING) {
                    infoStart = (JobNotificationsInfo) m_notifications.get(i);
                } else if (((JobNotificationsInfo) m_notifications.get(i))
                        .getType() == EndStatusConstant.TYPE_NORMAL) {
                    infoNormal = (JobNotificationsInfo) m_notifications.get(i);
                } else if (((JobNotificationsInfo) m_notifications.get(i))
                        .getType() == EndStatusConstant.TYPE_WARNING) {
                    infoWarning = (JobNotificationsInfo) m_notifications.get(i);
                } else if (((JobNotificationsInfo) m_notifications.get(i))
                        .getType() == EndStatusConstant.TYPE_ABNORMAL) {
                    infoAbnormal = (JobNotificationsInfo) m_notifications
                            .get(i);
                }
            }

            if (infoNormal instanceof JobNotificationsInfo) {
                //正常時の重要度設定
                setSelectPriority(m_normalPriority, 
                		infoNormal.getPriority());
                
                if(infoNormal.getNotifyId() != null
                        && infoNormal.getNotifyId().size() > 0) {
                	m_notifyId.setNotify(infoNormal.getNotifyId());
                }
                
            }

            if (infoWarning instanceof JobNotificationsInfo) {
                //警告時の重要度設定
                setSelectPriority(m_warningPriority, 
                		infoWarning.getPriority());
                //警告時の通知ID設定
                /*if (infoWarning.getNotify_id() != null
                        && infoWarning.getNotify_id().length() > 0) {
                	m_notifyId.setText(infoNormal.getNotify_id());
                }*/
            }

            if (infoAbnormal instanceof JobNotificationsInfo) {
                //異常時の重要度設定
                setSelectPriority(m_abnormalPriority, 
                		infoAbnormal.getPriority());
                //異常時の通知ID設定
                /* if(infoAbnormal.getNotifyId() != null
                        && infoAbnormal.getNotifyId().size() > 0) {
                	m_notifyId.setNotify(infoNormal.getNotifyId());
                }*/
              }

            if (infoStart instanceof JobNotificationsInfo) {
                //開始時の重要度設定
                setSelectPriority(m_startPriority, 
                		infoStart.getPriority());
                //開始時の通知ID設定
               /* if (infoStart.getNotify_id() != null
                        && infoStart.getNotify_id().length() > 0) {
                	m_notifyId.setText(infoNormal.getNotify_id());
                }*/
            }

        } else {
            m_normalPriority.select(0);
            m_warningPriority.select(1);
            m_abnormalPriority.select(2);
            m_startPriority.select(0);
          //  m_notifyId.setText("");
        }
    }

    /**
     * ジョブ通知情報を設定します。
     * 
     * @param notifications ジョブ通知情報のリスト
     */
    public void setNotificationsInfo(ArrayList<JobNotificationsInfo> notifications) {
        m_notifications = notifications;
    }

    /**
     * ジョブ通知情報を返します。
     * 
     * @return ジョブ通知情報のリスト
     */
    public ArrayList<JobNotificationsInfo> getNotificationsInfo() {
        return m_notifications;
    }

    /**
     * コンポジットの情報から、ジョブ通知情報を作成します。
     * 
     * @return 入力値の検証結果
     * 
     * @see com.clustercontrol.jobmanagement.bean.JobNotificationsInfo
     */
    @SuppressWarnings("unchecked")
	public ValidateResult createNotificationsInfo() {
        @SuppressWarnings("unused")
        ValidateResult result = null;

        JobNotificationsInfo infoNormal = null;
        JobNotificationsInfo infoWarning = null;
        JobNotificationsInfo infoAbnormal = null;
        JobNotificationsInfo infoStart = null;

        //メッセージ指定情報クラスのインスタンスを作成・取得
        m_notifications = new ArrayList();
        infoStart = new JobNotificationsInfo();
        infoStart.setType(EndStatusConstant.TYPE_BEGINNING);
        m_notifications.add(infoStart);
        infoNormal = new JobNotificationsInfo();
        infoNormal.setType(EndStatusConstant.TYPE_NORMAL);
        m_notifications.add(infoNormal);
        infoWarning = new JobNotificationsInfo();
        infoWarning.setType(EndStatusConstant.TYPE_WARNING);
        m_notifications.add(infoWarning);
        infoAbnormal = new JobNotificationsInfo();
        infoAbnormal.setType(EndStatusConstant.TYPE_ABNORMAL);
        m_notifications.add(infoAbnormal);

        //正常時の重要度取得
        infoNormal.setPriority(getSelectPriority(m_normalPriority));
        //正常時のメール通知取得
       if (m_notifyId.getNotify() != null) {
            infoNormal.setNotifyId(m_notifyId.getNotify());
        }
        

        //警告時の重要度取得
        infoWarning.setPriority(getSelectPriority(m_warningPriority));
        //警告時のメール通知取得
       /* if (m_notifyId.getNotify() != null) {
            infoWarning.setNotifyId(m_notifyId.getNotify());
        }*/
        

        //異常時の重要度取得
        infoAbnormal.setPriority(getSelectPriority(m_abnormalPriority));
        //異常時のメール通知取得
      /*  if (m_notifyId.getNotify() != null) {
            infoAbnormal.setNotifyId(m_notifyId.getNotify());
        }*/
      

        //開始時の重要度取得
        infoStart.setPriority(getSelectPriority(m_startPriority));
        //開始時のメール通知取得
       /* if (m_notifyId.getNotify() != null) {
            infoStart.setNotifyId(m_notifyId.getNotify());
        }*/
        
        return null;
    }

	/**
	 * 指定した重要度に該当する重要度用コンボボックスの項目を選択します。
	 * 
	 * @param combo 重要度用コンボボックスのインスタンス
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public void setSelectPriority(Combo combo, int priority) {
        String select = "";

        if (priority == PriorityConstant.TYPE_CRITICAL) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == PriorityConstant.TYPE_WARNING) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == PriorityConstant.TYPE_INFO) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == PriorityConstant.TYPE_UNKNOWN) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == PriorityConstant.TYPE_NONE) {
            select = PriorityConstant.STRING_NONE;
        }

        combo.select(0);
        for (int i = 0; i < combo.getItemCount(); i++) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
        }
    }

	/**
	 * 重要度用コンボボックスにて選択している重要度を取得します。
	 * 
	 * @param combo 重要度用コンボボックスのインスタンス
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
    public int getSelectPriority(Combo combo) {
        String select = combo.getText();

        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return PriorityConstant.TYPE_CRITICAL;
        } else if (select.equals(PriorityConstant.STRING_WARNING)) {
            return PriorityConstant.TYPE_WARNING;
        } else if (select.equals(PriorityConstant.STRING_INFO)) {
            return PriorityConstant.TYPE_INFO;
        } else if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return PriorityConstant.TYPE_UNKNOWN;
        } else if (select.equals(PriorityConstant.STRING_NONE)) {
            return PriorityConstant.TYPE_NONE;
        }

        return -1;
    }
}