/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.ParameterTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ジョブ変数タブのテーブル定義を取得するクライアント側アクションクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetParameterTableDefine {
	
	/**
	 * ジョブ変数タブのテーブル定義を作成する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	@SuppressWarnings("unchecked")
	public static ArrayList get() {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(ParameterTableDefine.PARAM_ID, 
				new TableColumnInfo(Messages.getString("name"), TableColumnInfo.NONE, 110, SWT.LEFT));
		tableDefine.add(ParameterTableDefine.TYPE, 
				new TableColumnInfo(Messages.getString("type"), TableColumnInfo.JOB_PARAM_TYPE, 70, SWT.LEFT));
		tableDefine.add(ParameterTableDefine.VALUE, 
				new TableColumnInfo(Messages.getString("value"), TableColumnInfo.NONE, 60, SWT.LEFT));
		tableDefine.add(ParameterTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description"), TableColumnInfo.NONE, 150, SWT.LEFT));
		
		return tableDefine;
	}
}
