/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.CalendarNotFountException;
import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * カレンダIDのリストを取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、カレンダIDのリスト取得します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetCalendarIdList {

	/**
	 * マネージャにSessionBean経由でアクセスし、カレンダIDのリスト取得します。<BR>
	 * 
	 * @return カレンダIDのリスト
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getCalendarIdList()
	 */
	public ArrayList<String> getCalendarIdList() {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		ArrayList<String> list = null;
		try {
			list = job.getCalendarIdList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (CalendarNotFountException e) {
			e.printStackTrace();
		}

		return list;
	}
}
