/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;

/**
 * 一括制御階層ツリー上下移動のSelectionListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class UpDownTreeItemSelectionListener extends BaseTreeItemSelectionListener {
    protected boolean up;
    
    /**
     * コンストラクタ
     * 
     * @param composite
     */
    public UpDownTreeItemSelectionListener(TreeComposite composite, boolean up) {
    	super(composite);
        this.up=up;
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    @Override
	public void widgetSelected(SelectionEvent e) {
    	
    	//作成中アイテムのチェック
    	if(!checkCreateItem())
    		return;
    	
    	//更新中アイテムのチェック
    	if(!checkUpdateItem())
    		return;
    	
    	TreeItem item = this.composite.getSelectItem();
    	TreeItem parent = item.getParent();
    	if (!(item instanceof TreeItem) || 
    			!(parent instanceof TreeItem))
    		return ;
    		
    	TreeItem target = null;
    	
		if(this.up){
			target = TreeItemUtil.getUpDownTargetItem(item, true);
		}
		else{
			target = TreeItemUtil.getUpDownTargetItem(item, false);
		}
		
    	if (!(target instanceof TreeItem))
    		return ;
    	
    	ItemInfo info = item.getInfo();
    	ItemInfo parentInfo = parent.getInfo();
    	ItemInfo targetInfo = target.getInfo();

        //選択したアイテムと移動ターゲットアイテムの順序を更新
    	ModifyMaster modify = new ModifyMaster();
        if(modify.changeOrder(info, targetInfo, parentInfo)){
        	int orderNo = info.getOrderNo();
        	info.setOrderNo(targetInfo.getOrderNo());
        	targetInfo.setOrderNo(orderNo);
        	
        	this.composite.setCreateItem(null);
        	this.composite.setUpdateItem(null);
    		this.composite.getTreeViewer().refresh(parent);
    		this.composite.getTreeViewer().setSelection(
    				new StructuredSelection(item), true);
        }
        else{
        	//エラー時、エラーダイアログを表示する
        	Object[] args = { info.getName(), targetInfo.getName() };
			MessageDialog.openError(null, 
					Messages.getString("message"), 
					Messages.getString("message.collective.run.15", args));
        	return ;
        }
    }
}

