/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.util.Messages;

/**
 * 一括制御[履歴]テーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistoryTabelDefine {

    /**
     * 履歴テーブル定義を取得します。<BR>
     * 
     * @return 履歴テーブル定義
     */
    public static ArrayList<TableColumnInfo> get() {
        //テーブル定義配列
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        Locale locale = Locale.getDefault();
        
        tableDefine.add(HistoryTableDefine.STATUS, 
                new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.CRUN_STATUS, 80, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.SESSION_ID, 
                new TableColumnInfo(Messages.getString("session.id", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.START_TIME, 
                new TableColumnInfo(Messages.getString("start.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.END_TIME, 
                new TableColumnInfo(Messages.getString("end.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.TYPE, 
                new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.NAME, 
                new TableColumnInfo(Messages.getString("name", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.FACILITY_ID, 
                new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.SCOPE, 
                new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.TOTAL, 
                new TableColumnInfo(Messages.getString("total", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.NORMAL, 
                new TableColumnInfo(Messages.getString("successful", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.WARNING, 
                new TableColumnInfo(Messages.getString("warning", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.ABNORMAL, 
                new TableColumnInfo(Messages.getString("failed", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.WAITING, 
                new TableColumnInfo(Messages.getString("waiting", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.RUNNING, 
                new TableColumnInfo(Messages.getString("running", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        
        return tableDefine;
    }
}