/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.preference;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.util.LoginManager;
import com.clustercontrol.util.Messages;

/**
 * ジョブ管理機能の設定ページクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ClusterControlCorePreferencePage extends FieldEditorPreferencePage
        implements IWorkbenchPreferencePage {

    /** EJB接続先URL */
    public static final String EJB_URL = LoginManager.KEY_EJB_URL;

    /** EJB接続の死活監視間隔 */
    public static final String KEY_INTERVAL = LoginManager.KEY_INTERVAL;
    public static final int VALUE_INTERVAL_MAX = 60;
    public static final int VALUE_INTERVAL_MIN = 1;

    /** 接続先URL */
    StringFieldEditor url = null;
    
    /** 接続先チェック間隔 */
    IntegerFieldEditor managerPollingInterval = null;
    
    /** EJB接続先URL */
    public static final String EJB_UID = LoginManager.KEY_EJB_UID;
    
    
    /** 接続先URL */
    StringFieldEditor uid = null;

    /**
     * 初期値が設定されたインスタンスを返します。
     */
    public ClusterControlCorePreferencePage() {
        super(GRID);
        this.setPreferenceStore(ClusterControlPlugin.getDefault()
                .getPreferenceStore());

    }

    /**
     * 設定フィールドを生成します。
     */
    @Override
	public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        // ジョブ[履歴]ビュー関連
        Group group = new Group(parent, SWT.SHADOW_NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        group.setLayoutData(gridData);

        group.setText(Messages.getString("jboss.connection.setting"));

        // 接続先URL
        url = new StringFieldEditor(EJB_URL, Messages.getString("connection.url"), group);
        url.setTextLimit(DataRangeConstant.VARCHAR_256);
        this.addField(url);
        
        // 接続死活間隔
        managerPollingInterval = new IntegerFieldEditor(KEY_INTERVAL, Messages.getString("manager.polling.interval"), group);
        managerPollingInterval.setValidRange(VALUE_INTERVAL_MIN, VALUE_INTERVAL_MAX);
        String[] args = { 
        		Integer.toString(VALUE_INTERVAL_MIN), 
        		Integer.toString(VALUE_INTERVAL_MAX) };
        managerPollingInterval.setErrorMessage(Messages.getString("message.hinemos.8", args ));
        this.addField(managerPollingInterval);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    @Override
	public boolean performOk() {
    	//System.out.println("ClusterControlCorePreferencePage.performOk() start");
    	
    	// 接続先URLの書式確認
		if (url.getStringValue().length() >= 0 && 
				!url.getStringValue().startsWith("jnp://")) {
    		//エラーメッセージ
    		MessageDialog.openWarning(
    				null, 
    				Messages.getString("message.hinemos.1"), 
    				Messages.getString("message.hinemos.9"));
    		return false;
        }

    	// 接続死活間隔の更新
		LoginManager.restartChecktask(managerPollingInterval.getIntValue());

		
        boolean result = super.performOk();

        //セッションに接続先URLを格納
        IPreferenceStore store = this.getPreferenceStore();
        store.getString(EJB_URL);

        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    public void init(IWorkbench workbench) {

    }
}