/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.factory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.util.DataTable;
import com.clustercontrol.repository.util.SearchNodeProperties;
import com.clustercontrol.repository.util.SnmpPoller;
import com.clustercontrol.util.PropertyUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchNodeBySNMP {
    protected static Log m_log = LogFactory.getLog(SearchNodeBySNMP.class);
    private static final String OID_NAME = ".1.3.6.1.2.1.1.5.0";
    private static final String OID_DESCR = ".1.3.6.1.2.1.1.1.0";
    private static final String OID_CONTACT = ".1.3.6.1.2.1.1.4.0";
    private static final String OID_DISK_INDEX = ".1.3.6.1.4.1.2021.13.15.1.1.1";
    private static final String OID_DISK_NAME = ".1.3.6.1.4.1.2021.13.15.1.1.2";
    private static final String OID_NIC_INDEX = ".1.3.6.1.2.1.2.2.1.1";
    private static final String OID_NIC_NAME = ".1.3.6.1.2.1.2.2.1.2";
    private static final String OID_FILESYSTEM_INDEX = ".1.3.6.1.2.1.25.2.3.1.1";
    private static final String OID_FILESYSTEM_TYPE = ".1.3.6.1.2.1.25.2.3.1.2";
    private static final String OID_FILESYSTEM_NAME = ".1.3.6.1.2.1.25.2.3.1.3";

    public static Property searchNode(Hashtable pollingData, int mode, Locale locale) throws FinderException, NamingException, UnknownHostException {
        SearchNodeProperties pollingProp = SearchNodeProperties.getProperties();
        int port = pollingProp.getPort();
        int version = pollingProp.getVersion();
        String community = pollingProp.getCommunity();
        InetAddress ipAddress = pollingProp.getAddress();
        int retries = pollingProp.getRetry();
        int timeout = pollingProp.getTimeOut();
        ArrayList oidList = pollingProp.getOidList();
        try {
            ipAddress = InetAddress.getByName((String)pollingData.get("IPAddress"));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        port = Integer.parseInt((String)pollingData.get("port"));
        community = (String)pollingData.get("community");
        version = (Integer)pollingData.get("version");
        DataTable ret = new DataTable();
        SnmpPoller poller = new SnmpPoller();
        poller.polling(ipAddress, port, version, community, retries, timeout, oidList, ret);
        return SearchNodeBySNMP.stractProperty(pollingData, ret, mode, locale);
    }

    private static Property stractProperty(Hashtable pollingData, DataTable ret, int mode, Locale locale) throws FinderException, NamingException, UnknownHostException {
        String description;
        String hostname;
        ArrayList propertyList;
        Property property = new NodeProperty().getProperty(mode, locale);
        if (ret.getValue(OID_DESCR) != null && ((String)ret.getValue(OID_DESCR).getValue()).length() != 0) {
            propertyList = PropertyUtil.getProperty((Property)property, (String)"description");
            ((Property)propertyList.get(0)).setValue((Object)("Auto detect at " + new Date().toString()));
        }
        try {
            String ipAddressString = (String)pollingData.get("IPAddress");
            InetAddress address = InetAddress.getByName(ipAddressString);
            int ipAddressVersion = 0;
            if (address instanceof Inet4Address) {
                if (ipAddressString.matches(".{1,3}?\\..{1,3}?\\..{1,3}?\\..{1,3}?")) {
                    propertyList = PropertyUtil.getProperty((Property)property, (String)"ipAddressV4");
                    ((Property)propertyList.get(0)).setValue((Object)((String)pollingData.get("IPAddress")));
                    ipAddressVersion = 4;
                }
            } else if (address instanceof Inet6Address) {
                propertyList = PropertyUtil.getProperty((Property)property, (String)"ipAddressV6");
                ((Property)propertyList.get(0)).setValue((Object)((String)pollingData.get("IPAddress")));
                ipAddressVersion = 6;
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)"ipAddressVersion");
            ((Property)propertyList.get(0)).setValue((Object)new Integer(ipAddressVersion));
        }
        catch (UnknownHostException e) {
            m_log.error((Object)e.getMessage());
            throw e;
        }
        propertyList = PropertyUtil.getProperty((Property)property, (String)"snmpPort");
        ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)pollingData.get("port")));
        propertyList = PropertyUtil.getProperty((Property)property, (String)"snmpCommunity");
        ((Property)propertyList.get(0)).setValue((Object)((String)pollingData.get("community")));
        propertyList = PropertyUtil.getProperty((Property)property, (String)"snmpVersion");
        ((Property)propertyList.get(0)).setValue((Object)SnmpVersionConstant.typeToString((Integer)((Integer)pollingData.get("version"))));
        if (ret.getValue(OID_NAME) != null && (hostname = (String)ret.getValue(OID_NAME).getValue()).length() != 0) {
            if (hostname.indexOf(".") != -1) {
                hostname = hostname.substring(0, hostname.indexOf("."));
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)"hostName");
            ((Property)propertyList.get(0)).setValue((Object)hostname);
            propertyList = PropertyUtil.getProperty((Property)property, (String)"nodeName");
            ((Property)propertyList.get(0)).setValue((Object)hostname);
        }
        if (ret.getValue(OID_CONTACT) != null && ((String)ret.getValue(OID_CONTACT).getValue()).length() != 0) {
            propertyList = PropertyUtil.getProperty((Property)property, (String)"administrator");
            ((Property)propertyList.get(0)).setValue((Object)((String)ret.getValue(OID_CONTACT).getValue()));
        }
        boolean isWindows = false;
        String platform = "OTHER";
        if (ret.getValue(OID_DESCR) != null && (description = (String)ret.getValue(OID_DESCR).getValue()).length() != 0) {
            String OsName = "";
            if (description.matches(".*indows.*")) {
                OsName = "Windows";
                platform = "WINDOWS";
                isWindows = true;
            } else if (description.matches(".*inux.*")) {
                OsName = "Linux";
                platform = "LINUX";
            } else if (description.matches(".*SunOS.*") || description.matches("Solaris")) {
                OsName = "Solaris";
                platform = "SOLARIS";
            } else if (description.indexOf(" ") != -1) {
                OsName = description.substring(0, description.indexOf(" "));
            }
            propertyList = PropertyUtil.getProperty((Property)property, (String)"osName");
            ((Property)propertyList.get(0)).setValue((Object)OsName);
            propertyList = PropertyUtil.getProperty((Property)property, (String)"osVersion");
            ((Property)propertyList.get(0)).setValue((Object)description);
        }
        propertyList = PropertyUtil.getProperty((Property)property, (String)"platformFamilyName");
        ((Property)propertyList.get(0)).setValue((Object)platform);
        propertyList = PropertyUtil.getProperty((Property)property, (String)"device");
        Property deviceProperty = (Property)propertyList.get(0);
        int index = PropertyUtil.getPropertyIndex((Property)property, (Property)deviceProperty);
        HashMap<String, Boolean> diskNameDuplicateSet = SearchNodeBySNMP.createDiskNameDuplicateSet(ret);
        HashMap<String, Boolean> nicNameDuplicateSet = SearchNodeBySNMP.createNicNameDuplicateSet(ret, isWindows);
        int deviceCount = 0;
        int maxI = 1;
        for (Object tmpOid : ret.keySet()) {
            String tmpI;
            String tmpStr = (String)tmpOid;
            if (tmpStr.indexOf(OID_DISK_INDEX) == -1 || maxI >= Integer.parseInt(tmpI = tmpStr.substring(tmpStr.lastIndexOf(".") + 1))) continue;
            maxI = Integer.parseInt(tmpI);
        }
        m_log.info((Object)("stractProperty maxI(disk)=" + maxI));
        for (int i = 1; i <= maxI; ++i) {
            String disk;
            String oidCounter = ".1.3.6.1.4.1.2021.13.15.1.1.1." + i;
            if (ret.getValue(oidCounter) == null || ((String)ret.getValue(oidCounter).getValue()).length() == 0 || (disk = (String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue()).startsWith("ram")) continue;
            Property diskProperty = null;
            diskProperty = deviceCount == 0 ? deviceProperty : PropertyUtil.copy((Property)deviceProperty);
            if (diskNameDuplicateSet != null && diskNameDuplicateSet.get(disk) != null && diskNameDuplicateSet.get(disk).booleanValue()) {
                disk = disk + "(" + i + ")";
            }
            diskProperty.setValue((Object)disk);
            propertyList = PropertyUtil.getProperty((Property)diskProperty, (String)"deviceName");
            ((Property)propertyList.get(0)).setValue((Object)disk);
            propertyList = PropertyUtil.getProperty((Property)diskProperty, (String)"deviceIndex");
            ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(".1.3.6.1.4.1.2021.13.15.1.1.1." + i).getValue()));
            propertyList = PropertyUtil.getProperty((Property)diskProperty, (String)"deviceType");
            ((Property)propertyList.get(0)).setValue((Object)"disk");
            if (deviceCount != 0) {
                property.addChildren((PropertyTreeItem)diskProperty, index + deviceCount);
            }
            ++deviceCount;
        }
        for (String fullOid : ret.keySet()) {
            if (!fullOid.startsWith(OID_NIC_INDEX)) continue;
            String tmpIndex = fullOid.substring(fullOid.lastIndexOf("."));
            String deviceName = "";
            if (((String)ret.getValue(fullOid).getValue()).length() == 0) continue;
            deviceName = SearchNodeBySNMP.convString((String)ret.getValue(OID_NIC_NAME + tmpIndex).getValue(), isWindows);
            Property nicProperty = null;
            nicProperty = deviceCount == 0 ? deviceProperty : PropertyUtil.copy((Property)deviceProperty);
            if (nicNameDuplicateSet != null && nicNameDuplicateSet.get(deviceName) != null && nicNameDuplicateSet.get(deviceName).booleanValue()) {
                deviceName = deviceName + "(" + tmpIndex + ")";
            }
            nicProperty.setValue((Object)deviceName);
            propertyList = PropertyUtil.getProperty((Property)nicProperty, (String)"deviceName");
            ((Property)propertyList.get(0)).setValue((Object)deviceName);
            propertyList = PropertyUtil.getProperty((Property)nicProperty, (String)"deviceIndex");
            ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(OID_NIC_INDEX + tmpIndex).getValue()));
            propertyList = PropertyUtil.getProperty((Property)nicProperty, (String)"deviceType");
            ((Property)propertyList.get(0)).setValue((Object)"nic");
            if (deviceCount != 0) {
                property.addChildren((PropertyTreeItem)nicProperty, index + deviceCount);
            }
            ++deviceCount;
        }
        propertyList = PropertyUtil.getProperty((Property)property, (String)"fileSystem");
        Property fileSystemProperty = (Property)propertyList.get(0);
        index = PropertyUtil.getPropertyIndex((Property)property, (Property)fileSystemProperty);
        deviceCount = 0;
        maxI = 1;
        for (Object tmpOid : ret.keySet()) {
            String tmpI;
            String tmpStr = (String)tmpOid;
            if (tmpStr.indexOf(OID_FILESYSTEM_INDEX) == -1 || maxI >= Integer.parseInt(tmpI = tmpStr.substring(tmpStr.lastIndexOf(".") + 1))) continue;
            maxI = Integer.parseInt(tmpI);
        }
        m_log.info((Object)("stractProperty maxI(FS)=" + maxI));
        for (int i = 0; i <= maxI; ++i) {
            String strageType;
            String oidCounter = ".1.3.6.1.2.1.25.2.3.1.1." + i;
            if (ret.getValue(oidCounter) == null || ((String)ret.getValue(oidCounter).getValue()).length() == 0 || !(strageType = ret.getValue(".1.3.6.1.2.1.25.2.3.1.2." + i).getValue().toString()).equals(".1.3.6.1.2.1.25.2.1.4")) continue;
            Property copyOfFileSystemProperty = null;
            copyOfFileSystemProperty = deviceCount == 0 ? fileSystemProperty : PropertyUtil.copy((Property)fileSystemProperty);
            copyOfFileSystemProperty.setValue((Object)SearchNodeBySNMP.convStringFilessystem((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.3." + i).getValue()));
            propertyList = PropertyUtil.getProperty((Property)copyOfFileSystemProperty, (String)"fileSystemMountPoint");
            ((Property)propertyList.get(0)).setValue((Object)SearchNodeBySNMP.convStringFilessystem((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.3." + i).getValue()));
            propertyList = PropertyUtil.getProperty((Property)copyOfFileSystemProperty, (String)"fileSystemIndex");
            ((Property)propertyList.get(0)).setValue((Object)Integer.parseInt((String)ret.getValue(".1.3.6.1.2.1.25.2.3.1.1." + i).getValue()));
            if (deviceCount != 0) {
                property.addChildren((PropertyTreeItem)copyOfFileSystemProperty, index + deviceCount);
            }
            ++deviceCount;
        }
        return property;
    }

    private static String convString(String str, boolean isWindows) {
        if (!isWindows) {
            String ret = str.replaceAll("/", " ");
            ret = ret.replaceAll("\\\\", " ");
            ret = ret.replaceAll(";", " ");
            ret = ret.replaceAll(",", " ");
            ret = ret.replaceAll("<", " ");
            ret = ret.replaceAll(">", " ");
            ret = ret.replaceAll("\\\\+", " ");
            ret = ret.replaceAll("\"", " ");
            return ret;
        }
        char[] chars = str.toCharArray();
        StringBuffer retStr = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < chars.length) {
            short first = (short)(chars[i] - 48);
            short second = (short)(chars[i + 1] - 48);
            if (second > 10) {
                second = (short)(second - 7);
            }
            retStr.append((char)(first * 16 + second));
            i += 3;
            ++j;
        }
        String ret = retStr.substring(0, retStr.length() - 1);
        ret = ret.replaceAll("/", " ");
        ret = ret.replaceAll("\\\\", " ");
        ret = ret.replaceAll(";", " ");
        ret = ret.replaceAll(",", " ");
        ret = ret.replaceAll("<", " ");
        ret = ret.replaceAll(">", " ");
        ret = ret.replaceAll("\\\\+", " ");
        ret = ret.replaceAll("\"", " ");
        return ret;
    }

    private static String convStringFilessystem(String str) {
        if (str.matches("/.*")) {
            return str;
        }
        if (str.matches("[A-Z]:\\\\.*")) {
            String returnString = str.substring(0, 3);
            return returnString;
        }
        System.out.println(str);
        char[] chars = str.toCharArray();
        StringBuffer ret = new StringBuffer();
        int j = 0;
        int i = 0;
        while (i < chars.length) {
            short first = (short)(chars[i] - 48);
            short second = (short)(chars[i + 1] - 48);
            if (second > 10) {
                second = (short)(second - 7);
            }
            ret.append((char)(first * 16 + second));
            i += 3;
            ++j;
        }
        return ret.substring(0, 3);
    }

    private static HashMap<String, Boolean> createDiskNameDuplicateSet(DataTable dataTable) {
        String oidCounter;
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int i = 1;
        while (dataTable.getValue(oidCounter = ".1.3.6.1.4.1.2021.13.15.1.1.1." + i) != null && ((String)dataTable.getValue(oidCounter).getValue()).length() != 0) {
            String disk = (String)dataTable.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue();
            if (!disk.startsWith("ram")) {
                String diskName = (String)dataTable.getValue(".1.3.6.1.4.1.2021.13.15.1.1.2." + i).getValue();
                Boolean isDuplicate = ret.get(diskName);
                if (isDuplicate == null) {
                    ret.put(diskName, false);
                } else if (!isDuplicate.booleanValue()) {
                    ret.put(diskName, true);
                }
            }
            ++i;
        }
        return ret;
    }

    private static HashMap<String, Boolean> createNicNameDuplicateSet(DataTable dataTable, boolean isWindows) {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        for (String fullOid : dataTable.keySet()) {
            if (!fullOid.startsWith(OID_NIC_INDEX)) continue;
            String tmpIndex = fullOid.substring(fullOid.lastIndexOf("."));
            if (((String)dataTable.getValue(fullOid).getValue()).length() == 0) continue;
            String nicName = SearchNodeBySNMP.convString((String)dataTable.getValue(OID_NIC_NAME + tmpIndex).getValue(), isWindows);
            Boolean isDuplicate = ret.get(nicName);
            if (isDuplicate == null) {
                ret.put(nicName, false);
                continue;
            }
            if (isDuplicate.booleanValue()) continue;
            ret.put(nicName, true);
        }
        return ret;
    }
}

