/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.ejb.session;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.repository.ejb.entity.DeviceInfoData;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.repository.ejb.entity.FacilityUtil;
import com.clustercontrol.repository.factory.DeleteFacility;
import com.clustercontrol.repository.factory.ModifyFacility;
import com.clustercontrol.repository.factory.NodeFilterProperty;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.factory.ScopeProperty;
import com.clustercontrol.repository.factory.SearchNodeBySNMP;
import com.clustercontrol.repository.factory.SelectFacility;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(RepositoryControllerBean.class);
    private SessionContext m_context;
    public static final int ALL = 0;
    public static final int ONE_LEVEL = 1;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public FacilityTreeItem getFacilityTree(Locale locale) throws FinderException, NamingException {
        FacilityTreeItem item = null;
        try {
            SelectFacility select = new SelectFacility();
            item = select.getFacilityTree(locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getFacilityTree() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return item;
    }

    public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
        FacilityTreeItem item = null;
        try {
            SelectFacility select = new SelectFacility();
            item = select.getScopeFacilityTree(locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getScopeFacilityTree() -> " + e.getMessage()));
        }
        catch (NamingException e) {
            throw e;
        }
        return item;
    }

    public ArrayList getNodeListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), 12, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"facility.name", (Locale)locale), 13, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        return tableDefine;
    }

    public ArrayList getNodeScopeTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), -1, 300, 16384));
        return tableDefine;
    }

    public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeScopeList(facilityId);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeScopeList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getScopeListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), 12, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"facility.name", (Locale)locale), 13, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 200, 16384));
        return tableDefine;
    }

    public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getScopeList(parentFacilityId);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getScopeList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getNodeList() throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeList();
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeList(parentFacilityId, level);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getNodeList(Property property) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeList(property);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getFacilityIdList(parentFacilityId, level, false);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getFacilityIdList(parentFacilityId, level, sort);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList<String> getExecTargetFacilityIdList(String facilityId) throws FinderException, NamingException {
        ArrayList ret = null;
        if (this.isNode(facilityId)) {
            ret = new ArrayList();
            FacilityLocal facility = FacilityUtil.getLocalHome().findByFacilityId(facilityId);
            if (facility.getValid().booleanValue()) {
                ret.add(facilityId);
            }
        } else {
            ret = this.getNodeFacilityIdList(facilityId, 0);
        }
        return ret;
    }

    public ArrayList getNodeFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, false, new Boolean(true));
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort, Boolean valid) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, sort, valid);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getNodeFacilityIdList() throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeFacilityIdList(false);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList list = select.getNodeFacilityIdList(sort);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getDeviceList(String facilityId) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            ArrayList<DeviceInfoData> list = select.getDeviceList(facilityId);
            return list;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getDeviceFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            HashMap map = select.getNodeDetail(facilityId, attributes);
            return map;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeDetail() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            HashMap map = select.getNodeDetail(facilityIdList, attributes);
            return map;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getNodeDetail() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
        ModifyFacility modify = new ModifyFacility();
        modify.setNodeDetail(facilityId, attributes);
    }

    public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
        ModifyFacility modify = new ModifyFacility();
        modify.addScope(parentFacilityId, property);
    }

    public void modifyScope(Property property) throws NamingException, FinderException {
        try {
            ModifyFacility modify = new ModifyFacility();
            modify.modifyScope(property);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.modifyScope() -> " + e.getMessage()));
            throw e;
        }
    }

    public void addNode(Property property) throws NamingException, CreateException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        this.checkFacilityInfo(property);
        ModifyFacility modify = new ModifyFacility();
        modify.addNode(property, pri.getName());
        ArrayList values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
        String[] facilityId = new String[]{(String)values.get(0)};
        modify.assignNodeScope("REGISTERED", facilityId);
    }

    public void modifyNode(Property property) throws NamingException, FinderException, CreateException {
        try {
            Principal pri = this.m_context.getCallerPrincipal();
            this.checkFacilityInfo(property);
            ModifyFacility modify = new ModifyFacility();
            modify.modifyNode(property, pri.getName());
            modify.modifyFacilityTreeValid(property);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.modifyNode() -> " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
    }

    public void modifyNode(Property property, String parentFacilityId) throws NamingException, FinderException {
        try {
            Principal pri = this.m_context.getCallerPrincipal();
            this.checkFacilityInfo(property);
            ModifyFacility modify = new ModifyFacility();
            modify.modifyAllNode(property, parentFacilityId, pri.getName());
        }
        catch (NamingException e) {
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.modifyNode() -> " + e.getMessage()));
            throw e;
        }
    }

    public void deleteNode(String facilityId) throws FinderException, RemoveException, NamingException, UsedFacilityException {
        try {
            DeleteFacility delete = new DeleteFacility();
            delete.deleteNode(facilityId);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.deleteNode() -> " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (UsedFacilityException e) {
            throw e;
        }
    }

    public void deleteScope(String facilityId) throws FinderException, NamingException, RemoveException, UsedFacilityException {
        try {
            DeleteFacility delete = new DeleteFacility();
            delete.deleteScope(facilityId);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.deleteScope() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
        catch (UsedFacilityException e) {
            throw e;
        }
    }

    public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException, FinderException {
        try {
            ModifyFacility modify = new ModifyFacility();
            modify.assignNodeScope(parentFacilityId, facilityIds);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
        catch (FinderException e) {
            throw e;
        }
    }

    public void releaseNodeScope(String parentFacilityId, String[] facilityIds) throws FinderException, NamingException, RemoveException {
        try {
            DeleteFacility delete = new DeleteFacility();
            delete.releaseNodeScope(parentFacilityId, facilityIds);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.releaseNodeScope() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoveException e) {
            throw e;
        }
    }

    public Property getScopeProperty(String facilityId, int mode, Locale locale) throws FinderException, NamingException {
        try {
            ScopeProperty scope = new ScopeProperty();
            return scope.getProperty(facilityId, mode, locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getScopeProperty() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public Property getNodeProperty(String facilityId, int mode, Locale locale) throws FinderException, NamingException {
        try {
            NodeProperty node = new NodeProperty();
            return node.getProperty(facilityId, mode, locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getScopeProperty() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public Property getNodeFilterProperty(Locale locale) {
        NodeFilterProperty node = new NodeFilterProperty();
        return node.getProperty(locale);
    }

    public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            return select.getFacilityPath(facilityId, parentFacilityId);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getFacilityPath() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            return select.getFacilityIdList(hostName, ipAddress);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.getFacilityIdList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public boolean isNode(String facilityId) throws FinderException, NamingException {
        try {
            SelectFacility select = new SelectFacility();
            return select.isNode(facilityId);
        }
        catch (FinderException e) {
            m_log.debug((Object)("RepositoryControllerBean.isNode() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
    }

    public String getSeparator() {
        return ">";
    }

    public Property getNodePropertyBySNMP(Hashtable pollingData, int mode, Locale locale) throws FinderException, NamingException, UnknownHostException {
        return SearchNodeBySNMP.searchNode(pollingData, mode, locale);
    }

    private void checkFacilityInfo(Property property) throws EJBException {
        String nodeName;
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityId");
        String facilityId = this.checkString(values.get(0));
        if (facilityId == null) {
            throw new EJBException("facilityId is null");
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"facilityName");
        String facilityName = this.checkString(values.get(0));
        if (facilityName == null) {
            throw new EJBException("facilityId=" + facilityId + " : facilityName is null");
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"platformFamilyName");
        String platform = this.checkString(values.get(0));
        if (platform == null) {
            throw new EJBException("facilityId=" + facilityId + " : platform is null");
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressVersion");
        Object obj = values.get(0);
        Integer ipAddressVersion = null;
        if (obj.getClass() == Integer.class) {
            ipAddressVersion = (Integer)obj;
        }
        if (ipAddressVersion == null || ipAddressVersion == 4) {
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV4");
            String ip4Address = this.checkString(values.get(0));
            if (ip4Address == null) {
                throw new EJBException("facilityId=" + facilityId + " : ip4Address is null");
            }
        } else if (ipAddressVersion == 6) {
            values = PropertyUtil.getPropertyValue((Property)property, (String)"ipAddressV6");
            String ip6Address = this.checkString(values.get(0));
            if (ip6Address == null) {
                throw new EJBException("facilityId=" + facilityId + " : ip6Address is null");
            }
        } else {
            throw new EJBException("facilityId=" + facilityId + " : ipAddressVersion is incorrect");
        }
        if ((nodeName = this.checkString((values = PropertyUtil.getPropertyValue((Property)property, (String)"nodeName")).get(0))) == null) {
            throw new EJBException("facilityId=" + facilityId + " : nodeName is null");
        }
        ArrayList deviceList = PropertyUtil.getProperty((Property)property, (String)"device");
        for (int i = 0; i < deviceList.size(); ++i) {
            Property deviceProperty = (Property)deviceList.get(i);
            String deviceName = this.checkString(PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceName").get(0));
            Integer deviceIndex = this.checkInteger(PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceIndex").get(0));
            String deviceType = this.checkString(PropertyUtil.getPropertyValue((Property)deviceProperty, (String)"deviceType").get(0));
            if ((deviceName == null || deviceName.equals("")) && deviceIndex == null && (deviceType == null || deviceType.equals(""))) continue;
            if (deviceName == null) {
                throw new EJBException("facilityId=" + facilityId + " : deviceName is null");
            }
            if (deviceIndex == null) {
                throw new EJBException("facilityId=" + facilityId + ", deviceName=" + deviceName + " : deviceIndex is null");
            }
            if (deviceType != null) continue;
            throw new EJBException("facilityId=" + facilityId + ", deviceName=" + deviceName + " : deviceType is null");
        }
        ArrayList filesystemList = PropertyUtil.getProperty((Property)property, (String)"fileSystem");
        for (int i = 0; i < filesystemList.size(); ++i) {
            Property filesystemProperty = (Property)filesystemList.get(i);
            String mountPoint = this.checkString(PropertyUtil.getPropertyValue((Property)filesystemProperty, (String)"fileSystemMountPoint").get(0));
            Integer filesystemIndex = this.checkInteger(PropertyUtil.getPropertyValue((Property)filesystemProperty, (String)"fileSystemIndex").get(0));
            if ((mountPoint == null || mountPoint.equals("")) && filesystemIndex == null) continue;
            if (mountPoint == null) {
                throw new EJBException("facilityId=" + facilityId + " : fileSystemMountPoint is null");
            }
            if (filesystemIndex != null) continue;
            throw new EJBException("facilityId=" + facilityId + ", fileSystemMountPoint=" + mountPoint + " : fileSystemIndex is null");
        }
    }

    private Integer checkInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    private String checkString(Object value) {
        if (value instanceof String) {
            if (((String)value).compareTo("") == 0) {
                return null;
            }
            return (String)value;
        }
        return null;
    }
}

