#!/bin/sh

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み
export EXEC_PATH=${0%/*}

. ${EXEC_PATH}/install.cfg

EXEC_USER=`/usr/bin/whoami`

# check for incorrect user
if [ $EXEC_USER != "root" ]; then
	echo "rootユーザで実行してください。"
	exit
fi

#locale情報を設定
LOCALE=ja_JP.UTF-8

##
## カーネルリソースの確認
##
kernel_resurce_check(){
	# SHMMAXの確認
	if [ "${CURRENT_SHMMAX}" -lt "${SHMMAX}" ] ;then
		echo "共有メモリセグメントの最大サイズは "\
		`echo ${CURRENT_SHMMAX}`" です。"
		while [ 1 ] ;
		do
			echo ${SHMMAX}"(512MB) に変更してもよろしいですか? (Y/N default:Y)"
			read ANS
			ANS=${ANS:-Y}
			
			case ${ANS} in
				y|Y)
					echo ${SHMMAX} > /proc/sys/kernel/shmmax
					echo "" >> /etc/sysctl.conf
					echo "#add for Hinemos Manager" >> /etc/sysctl.conf
					echo "kernel.shmmax=${SHMMAX}" >> /etc/sysctl.conf
					break
					;;
				n|N)
					echo "インストールを中止します。"
					exit 1
					;;
				*)
					echo ""
					;;
			esac
		done	
	fi
	
	# SHMALLの変更
	if [ "${CURRENT_SHMALL}" -lt "${SHMALL}" ] ;then
		echo "システム全体の共有メモリの最大サイズは "\
		`echo $CURRENT_SHMALL`" です。"
		while [ 1 ] ;
		do
			echo $SHMALL"(512MB) に変更してもよろしいですか? (Y/N default:Y)"
			read ANS
			ANS=${ANS:-Y}
			
			case ${ANS} in
				y|Y)
					echo $SHMALL > /proc/sys/kernel/shmall
					echo "" >> /etc/sysctl.conf
					echo "#add for Hinemos Manager" >> /etc/sysctl.conf
					echo "kernel.shmall=${SHMALL}" >> /etc/sysctl.conf
					break
					;;
				n|N)
					echo "インストールを中止します。"
					exit 1
					;;
				*)
					echo ""
					;;
			esac
		done
	fi
}

##
## hinemosユーザの確認
##
make_user() {
	echo "ユーザ ${HINEMOS_USER} を作成します。"
	TMP=0
	id ${HINEMOS_USER} > /dev/null 2>&1 && TMP=1
	
	#${HINEMOS_USER}が存在する場合
	if [ "$TMP" -eq "1" ] ; then
		echo "ユーザ ${HINEMOS_USER} は既に存在します。"
		
		mkdir -p ${HINEMOS_HOME}
		chown -R ${HINEMOS_USER}:${HINEMOS_USER} ${HINEMOS_HOME}
		cp ${EXEC_PATH}/bash_profile.conf ${HINEMOS_HOME}/.bash_profile
		echo "インストールディレクトリ ${HINEMOS_HOME} を作成しました。"
	else
		/usr/sbin/useradd ${HINEMOS_USER} -d ${HINEMOS_HOME}
		/usr/bin/passwd ${HINEMOS_USER}
		cp ${EXEC_PATH}/bash_profile.conf ${HINEMOS_HOME}/.bash_profile
		echo "ユーザ ${HINEMOS_USER} を作成しました。"
		echo "インストールディレクトリ ${HINEMOS_HOME} を作成しました。"
	fi
	sleep 2
}

##
## インストールディレクトリの確認
##
make_installdir_check() {
	if [ -d ${HINEMOS_HOME} ] ; then
		echo "警告：インストールディレクトリ ${HINEMOS_HOME} は既に存在します。"
		echo "ディレクトリ名を変更するか、削除してください。"
		echo ""
		echo "インストールを中止します。"
		sleep 2
		exit 1
	fi
}

##
## 一括制御スクリプトの設定
##
crun_setting() {
	#ftpサーバのIPアドレスを一括制御スクリプトに挿入
	echo "一括制御で利用するFTPサーバのIPアドレスを入力してください。(default:127.0.0.1)"
	read FTP_SERVER
	FTP_SERVER=${FTP_SERVER:-"127.0.0.1"}
	sed "s/%%hinemos_ftp_host%%/${FTP_SERVER}/"  ${EXEC_PATH}/hinemos/lib/cr/cp.sh > ${HINEMOS_HOME}/lib/cr/cp.sh
	sed "s/%%hinemos_ftp_host%%/${FTP_SERVER}/"  ${EXEC_PATH}/hinemos/lib/cr/rpminstall.sh > ${HINEMOS_HOME}/lib/cr/rpminstall.sh
	
	#JREのバージョンを一括制御スクリプトに挿入
	sed "s/%%jre_version%%/${JRE_NAME}/"  ${EXEC_PATH}/hinemos/lib/cr/agent_install.sh > ${HINEMOS_HOME}/lib/cr/tmp_agent_install.sh
	
	#Hinemosのバージョンを一括制御スクリプトに挿入
	HINEMOS_VERSION=`cat ${EXEC_PATH}/hinemos/_version`
	sed "s/%%hinemos_version%%/${HINEMOS_VERSION}/"  ${HINEMOS_HOME}/lib/cr/tmp_agent_install.sh > ${HINEMOS_HOME}/lib/cr/agent_install.sh
	rm ${HINEMOS_HOME}/lib/cr/tmp_agent_install.sh
}

##
## syslog-ngの設定
##
syslogng_install() {
	HINEMOS_VERSION=`cat ${HINEMOS_HOME}/_version`
	#syslog-ngインストール
	echo "syslog-ngのインストールを行います。"
	echo ""
	
	#インストールチェック
	TMP=0
	rpm -q syslog-ng > /dev/null
	
	if [ "${?}" -eq "1" ] ; then
		
		
		# rpmインストール
		rpm -ivh --force ${SYSLOG_NG_RPM}
		
		# syslog-ng.conf の編集
		sed -e "s%__HINEMOS_HOME__%${HINEMOS_HOME}%g" -e "s%__JRE__%${JRE_NAME}%g" -e "s%__VERSION__%${HINEMOS_VERSION}%g" ./syslog-ng_setup.conf >> /etc/syslog-ng/syslog-ng.conf
		
		echo "syslog-ngをインストールしました。"
		
		# syslogの停止、syslog-ng の起動
		echo "syslogを停止し、syslog-ngを起動します。"
		/etc/init.d/syslog stop
		/etc/init.d/syslog-ng start
		/sbin/chkconfig --level 2345 syslog off
		/sbin/chkconfig --level 2345 syslog-ng on
	else
		echo "警告：syslog-ngは既にインストールされています。"
		echo "インストールマニュアルを参照し、設定を変更して下さい。"
		sleep 2
	fi
}

##
## /etc/hostsの確認
##
hosts_check() {

	#/etc/hostsの設定
	HOSTS_FILE=/etc/hosts
	HOST=`hostname`
	IPADDRESS=${1}
	
	while [ 1 ] ;
	do
		echo ""
		echo "${HOSTS_FILE}ファイルを変更します。"
		echo "変更してもよろしいですか?(Y/N)"
		read ANS
		echo ""
		case ${ANS} in
			y|Y)
				#hostsファイルのバックアップを取る
				#バックアップ用時刻を取得
				DATE=`date +%m%d%H%M`
				cp -pr ${HOSTS_FILE} ${HOSTS_FILE}.bk_${DATE}
				_FLAG=0
				
				#hostsファイルにホスト名とlocalhostの記述が一行に存在するか確認する
				#ただし、ホスト名とlocalhostの間に「#」が含まれる場合は、検出しない
				TMP_HOST=`cat ${HOSTS_FILE} | grep "${HOST}[^\#]*localhost\|localhost[^\#]*${HOST}" | grep -v "^\s*\#"`
				
				#TMP_HOSTが空でない場合
				if [ "${TMP_HOST}" != "" ] ; then
					TMP_INSERT=`echo ${TMP_HOST} | sed "s/\s${HOST}\s/\t/g"`
					sed "s/${TMP_HOST}/#${TMP_HOST}\n${TMP_INSERT}/g" ${HOSTS_FILE} > ${HOSTS_FILE}_tmp
					mv -f ${HOSTS_FILE}_tmp ${HOSTS_FILE}
					_FLAG=1
				fi
				
				#hostsファイルに、ホスト名に対するIPアドレスが振られていない場合
				if [ "`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#"`" = "" ]; then
					echo "${IPADDRESS}      ${HOST}" >> ${HOSTS_FILE}
					_FLAG=1
				fi
				
				#ホスト名とIPアドレス対応の最終確認
				#ホスト名に対し、入力されたIPアドレス以外のアドレスが登録されていた場合
				if [ "${IPADDRESS}" != "`grep ${HOST} ${HOSTS_FILE} | grep -v "^\s*\#" | awk '{print $1}'`" ]; then
					echo "警告：${HOSTS_FILE} の ホスト名 ${HOST} には入力されたIPアドレスと異なるIPアドレスが設定されています。"
					echo "インストールマニュアルに従い設定を変更して下さい。"
					mv -f ${HOSTS_FILE}.bk_${DATE} ${HOSTS_FILE}
					break
				fi
				
				if [ "${_FLAG}" != "0" ]; then
					echo "${HOSTS_FILE} ファイルを変更しました。"
					echo "インストーラ終了後に確認して下さい。"
				else
					echo "${HOSTS_FILE} ファイルを変更する必要はありません。"
				fi
				rm -f ${HOSTS_FILE}.bk_${DATE}
				
				break
				;;
			n|N)
				echo "${HOSTS_FILE}ファイルの変更は行いませんでした。"
				echo "インストールマニュアルに従い設定を変更して下さい。"
				sleep 1
				break
				;;
			*)
				echo "YかNを入力して下さい。"
				;;
		esac
	done
}




##
## インストール本編(始)
##
echo ""
echo "Hinemosマネージャのインストールを開始します。よろしいですか？(Y/N default:Y)"
while [ 1 ] ;
do
	read ANS
	ANS=${ANS:-Y}
	case ${ANS} in
		y|Y)
			echo ""
			echo "インストールユーザとインストールディレクトリを作成します。"
			echo ""
			
			# インストールディレクトリの確認
			make_installdir_check
			echo ""
			
			# インストールユーザとインストールディレクトリの作成
			make_user
			echo ""
			
			# IPアドレスの取得
			echo "マネージャのIPアドレスを設定します。"
			while [ 1 ] ;
			do
				echo "現在マネージャをインストールしているマシンのIPアドレスを入力してください。"
				read IP_ADDRESS
				echo "${IP_ADDRESS} でよろしいですか? (Y/N default:Y)"
				read IP_ANS
				IP_ANS=${IP_ANS:-Y}
				echo ""
				case ${IP_ANS} in
					y|Y)
						break
						;;
					n|N)
						;;
					*)
						echo "YかNを入力して下さい。"
						;;
				esac
			done			
			
			#JBoss起動ユーザの指定
			echo ""
			while [ 1 ] ;
			do
				echo "JBoss 起動ユーザを入力してください。(hinemos/root default:hinemos)"
				read JBOSS_USER
				JBOSS_USER=${JBOSS_USER:-hinemos}
				case ${JBOSS_USER} in
					hinemos|root)
						echo "${JBOSS_USER} でよろしいですか？ (Y/N default:Y)"
						read JBOSS_USER_ANS
						JBOSS_USER_ANS=${JBOSS_USER_ANS:-Y}
						case ${JBOSS_USER_ANS} in
							y|Y)
								break
								;;
							n|N)
								echo ""
								;;
							*)
								echo "YかNを入力してください。"
								;;
						esac
						;;
					*)
						echo "hinemosかrootを指定してください。"
						;;
				esac
			done
			
			# /opt/hinemos以下にコピー
			echo "必要なファイルをインストールディレクトリにコピーします。"
			cp -pr ${EXEC_PATH}/hinemos /opt
			cp -pr ${EXEC_PATH}/manager_uninstaller* ${HINEMOS_HOME}/sbin
			cp -pr ${EXEC_PATH}/install.cfg ${HINEMOS_HOME}/sbin
			
			# 一括制御の設定
			crun_setting
			
			#インストールディレクトリに応じて各設定ファイルを変更
			REPLACE_PATH=`echo ${HINEMOS_HOME} | sed 's/\//\\\\\//g'`
			sed -e "s/%%hinemos_install_dir%%/${REPLACE_PATH}/" -e "s/%%jre_name%%/${JRE_NAME}/" -e "s/%%ip_address%%/${IP_ADDRESS}/" -e "s/%%locale%%/${LOCALE}/" -e "s/%%JBOSS_USER%%/${JBOSS_USER}/" ${EXEC_PATH}/hinemos.cfg > ${HINEMOS_HOME}/hinemos.cfg
			sed -e "s/%%ip_address%%/${IP_ADDRESS}/" ${EXEC_PATH}/hinemos/lib/syslogforward/LogForward.properties > ${HINEMOS_HOME}/lib/syslogforward/LogForward.properties
			
			echo "必要なファイルのコピーが終了しました。"
			echo ""
			
			
			# JREのインストール
			echo "JREのインストールを行います。"
			sleep 2
			echo ""
			cp ${EXEC_PATH}/${JRE_VERSION}-linux-i586.bin ${HINEMOS_HOME}
			CURRENT_DIR=`pwd`
			cd ${HINEMOS_HOME}
			${HINEMOS_HOME}/${JRE_VERSION}-linux-i586.bin
			rm ${HINEMOS_HOME}/${JRE_VERSION}-linux-i586.bin
			cd ${CURRENT_DIR}
			
			
			# ${HINEMOS_HOME}のオーナーをhinemosユーザに変更する
			chown -R ${HINEMOS_USER}:${HINEMOS_USER} ${HINEMOS_HOME}
			
			# fpingのオーナーはrootユーザである必要があるため変更する
			chown root:root ${HINEMOS_HOME}/sbin/fping
			chmod 4755 ${HINEMOS_HOME}/sbin/fping
			chown root:root ${HINEMOS_HOME}/sbin/fping6
			chmod 4755 $HINEMOS_HOME/sbin/fping6
			
			# syslog-ngの設定
			syslogng_install
			
			# /etc/hostsの確認
			hosts_check ${IP_ADDRESS}
			
			echo ""
			sleep 1
			
			
			# DB初期化
			echo "データベースの初期化を行います。"
			
			# カーネルリソースの確認
			kernel_resurce_check
			
			cd ${HINEMOS_HOME}
			su -c ${HINEMOS_HOME}/sbin/db_init/pg_init.sh ${HINEMOS_USER}
			
			
			# LDAP初期化
			echo ""
			echo "LDAPの初期化を行います。"
			
			cd ${HINEMOS_HOME}
			su -c ${HINEMOS_HOME}/sbin/db_init/ldap_init.sh ${HINEMOS_USER}
			
			REVAL=$?
			if [ "${REVAL}" -eq 0 ]; then
				echo "LDAPの初期化が完了しました。"
				echo ""
			fi
			
			
			echo "Hinemosマネージャのインストールが完了しました。"
			echo ""
			break
			;;
		n|N)
			echo "Hinemosマネージャのインストールを終了します。"
			exit 0
			;;
		*)
			;;
	esac
done		
##
## インストーラ本編(終)
##
