/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller.jmx;

import com.clustercontrol.poller.PollerManager;
import com.clustercontrol.poller.jmx.PollerServiceMBean;
import com.clustercontrol.poller.util.ReceiveRepositoryTopic;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

public class PollerService
extends ServiceMBeanSupport
implements PollerServiceMBean {
    private String jndiName = "PollerManager";
    private String quartzJndiName = null;
    private PollerManager manager;
    private ReceiveRepositoryTopic m_receiveRepositoryTopic;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.log.info((Object)("setJndiName() Service : " + jndiName));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            NamingException ne;
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
        }
    }

    public String getQuartzJndiName() {
        return this.quartzJndiName;
    }

    public void setQuartzJndiName(String jndiName) {
        this.quartzJndiName = jndiName;
    }

    public String getName() {
        return "PollerService(" + this.jndiName + ")";
    }

    public String printPollerInfo() {
        return this.manager.getPollerDebugInfo();
    }

    public void createService() {
        this.log.info((Object)("Create PollerService(" + this.jndiName + ")"));
        this.manager = new PollerManager(this.jndiName);
        this.log.info((Object)("Created PollerService(" + this.jndiName + ")"));
    }

    public void startService() throws NamingException {
        this.log.info((Object)("Start PollerService(" + this.jndiName + ")"));
        this.m_receiveRepositoryTopic = new ReceiveRepositoryTopic(this.manager);
        this.rebind();
        this.log.info((Object)("Started PollerService(" + this.jndiName + ")"));
    }

    public void stopService() throws NamingException {
        this.log.info((Object)("Stop PollerService(" + this.jndiName + ")"));
        this.m_receiveRepositoryTopic.terminate();
        this.unbind(this.jndiName);
        this.log.info((Object)("Stoped PollerService(" + this.jndiName + ")"));
    }

    public void destroyService() throws Exception {
        this.log.info((Object)("Destroy PollerService(" + this.jndiName + ")"));
        this.manager = null;
        this.log.info((Object)("Destroyed PollerService(" + this.jndiName + ")"));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws NamingException {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = PollerService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }
}

