/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.factory;

import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performance.util.Repository;
import com.clustercontrol.performance.util.code.CollectorItemCodeTable;
import com.clustercontrol.util.Messages;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorPerformance2
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorPerformance2.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected MonitorPerfInfoLocal m_perf = null;
    private String m_itemName = null;
    private CollectorDeviceInfoData m_deviceData = null;
    protected NumberFormat m_numberFormat = NumberFormat.getNumberInstance();

    public RunMonitor createMonitorInstance() throws NamingException, JMSException, CreateException {
        return new RunMonitorPerformance2();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String monitorTypeId, String monitorId, CollectedDataInfo data) throws FinderException, RemoveException, JMSException, NamingException, CreateException {
        block24: {
            block23: {
                block22: {
                    block21: {
                        try {
                            try {
                                String facilityId;
                                block26: {
                                    block25: {
                                        super.initialize();
                                        facilityId = data.getFacilityId();
                                        if (facilityId == null) break block25;
                                        if (!"".equals(facilityId)) break block26;
                                    }
                                    Object var14_9 = null;
                                    break block21;
                                }
                                if (this.m_repository.getExecTargetFacilityIdList(facilityId).size() == 0) {
                                    break block22;
                                }
                                this.m_value = (float)data.getValue();
                                this.m_now = new Date();
                                this.m_monitorTypeId = monitorTypeId;
                                this.m_monitorId = monitorId;
                                this.m_priorityMap = new HashMap();
                                this.m_priorityMap.put(3, new ArrayList());
                                this.m_priorityMap.put(2, new ArrayList());
                                this.m_priorityMap.put(0, new ArrayList());
                                this.m_priorityMap.put(1, new ArrayList());
                                boolean notify = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
                                if (!notify) {
                                    break block23;
                                }
                                this.setJudgementInfo();
                                this.setCheckInfo();
                                boolean isNode = false;
                                if (this.m_repository.isNode(this.m_facilityId)) {
                                    isNode = true;
                                }
                                boolean result = this.collect(facilityId);
                                int priority = this.getCheckResult(result);
                                if (this.m_repository.isNode(facilityId)) {
                                    if (0 == this.m_monitorBlock || 1 == this.m_monitorBlock && isNode || 2 == this.m_monitorBlock) {
                                        m_log.debug((Object)("run() displayName : " + data.getDisplayName()));
                                        if (data.getDisplayName() != null && !data.getDisplayName().equals("")) {
                                            Repository repository = new Repository();
                                            List<CollectorDeviceInfoData> deviceList = repository.getDeviceList(facilityId);
                                            for (CollectorDeviceInfoData device : deviceList) {
                                                if (!device.getDisplayName().equals(data.getDisplayName())) continue;
                                                this.m_deviceData = device;
                                                break;
                                            }
                                        }
                                        if (data.getDate().getTime() == 0L) {
                                            this.notify(true, facilityId, priority, new Date());
                                            break block24;
                                        } else {
                                            this.notify(true, facilityId, priority, data.getDate());
                                        }
                                    }
                                    break block24;
                                }
                                if (1 != this.m_monitorBlock && 2 != this.m_monitorBlock) break block24;
                                if (data.getDate().getTime() == 0L) {
                                    this.notify(false, facilityId, priority, new Date());
                                    break block24;
                                } else {
                                    this.notify(false, facilityId, priority, data.getDate());
                                }
                                break block24;
                            }
                            catch (FinderException e) {
                                m_log.error((Object)("run():" + e.getMessage()));
                                e.printStackTrace();
                                throw e;
                            }
                            catch (JMSException e) {
                                e.printStackTrace();
                                throw e;
                            }
                            catch (NamingException e) {
                                m_log.error((Object)("run():" + e.getMessage()));
                                e.printStackTrace();
                                throw e;
                            }
                            catch (CreateException e) {
                                m_log.error((Object)("run():" + e.getMessage()));
                                e.printStackTrace();
                                throw e;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_13 = null;
                            this.terminate();
                            throw throwable;
                        }
                    }
                    this.terminate();
                    return;
                }
                Object var14_10 = null;
                this.terminate();
                return;
            }
            Object var14_11 = null;
            this.terminate();
            return;
        }
        Object var14_12 = null;
        this.terminate();
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorPerfInfoPK pk = new MonitorPerfInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_perf = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_itemName = CollectorItemCodeTable.getFullItemName(this.m_perf.getItemCode(), this.m_perf.getDisplayName());
    }

    public String getMessageId(int result) {
        if (result == 3) {
            return MESSAGE_ID_INFO;
        }
        if (result == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (result == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int result) {
        String valueString = Double.isNaN(this.m_value) ? "NaN" : this.m_numberFormat.format(this.m_value);
        return this.m_itemName + " : " + valueString;
    }

    public String getMessageForScope(int result) {
        String valueString = Double.isNaN(this.m_value) ? "NaN" : this.m_numberFormat.format(this.m_value);
        return this.m_itemName + " : " + valueString;
    }

    public String getMessageOrg(int result) {
        String valueString;
        if (Double.isNaN(this.m_value)) {
            valueString = "NaN";
        } else {
            valueString = this.m_numberFormat.format(this.m_value);
            m_log.debug((Object)("RunMonitorPerf messageOrg : " + valueString));
            if (this.m_deviceData != null) {
                valueString = valueString + "\n" + Messages.getString((String)"device.name") + " : " + this.m_deviceData.getDeviceName() + "\n" + Messages.getString((String)"device.index") + " : " + this.m_deviceData.getIndex();
                m_log.debug((Object)("RunMonitorPerf add DeviceInfo : " + valueString));
            }
        }
        return this.m_itemName + " : " + valueString;
    }

    public String getMessageOrgForScope(int result) {
        String valueString = Double.isNaN(this.m_value) ? "NaN" : this.m_numberFormat.format(this.m_value);
        return this.m_itemName + " : " + valueString;
    }

    public boolean collect(String facilityId) {
        return !Double.isNaN(this.m_value);
    }
}

