/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.PerTxEntityInstanceCacheMBean;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;

public class PerTxEntityInstanceCache
implements EntityCache,
PerTxEntityInstanceCacheMBean {
    private static final Logger log = Logger.getLogger(PerTxEntityInstanceCache.class);
    private final TransactionLocal txLocalCache = new TransactionLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private EntityContainer container;

    public Object createCacheKey(Object id) {
        return id;
    }

    public EnterpriseContext get(Object id) throws RemoteException, NoSuchObjectException {
        if (id == null) {
            throw new IllegalArgumentException("Can't get an object with a null key");
        }
        Map cache = this.getLocalCache();
        EntityEnterpriseContext instance = (EntityEnterpriseContext)cache.get(id);
        if (instance == null) {
            try {
                instance = (EntityEnterpriseContext)this.container.getInstancePool().get();
                instance.setId(id);
                instance.setCacheKey(id);
                this.container.getPersistenceManager().activateEntity(instance);
                cache.put(id, instance);
            }
            catch (Throwable x) {
                throw new NoSuchObjectException(x.getMessage());
            }
        }
        return instance;
    }

    public void insert(EnterpriseContext instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Can't insert a null object in the cache");
        }
        EntityEnterpriseContext entity = (EntityEnterpriseContext)instance;
        this.getLocalCache().put(entity.getCacheKey(), instance);
    }

    public void release(EnterpriseContext instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Can't release a null object");
        }
        this.tryToPassivate(instance);
    }

    public void remove(Object id) {
        this.getLocalCache().remove(id);
    }

    public boolean isActive(Object id) {
        return this.getLocalCache().containsKey(id);
    }

    public long getCacheSize() {
        return 0L;
    }

    public void flush() {
    }

    public void setContainer(Container con) {
        this.container = (EntityContainer)con;
    }

    public void create() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryToPassivate(EnterpriseContext instance) {
        Object id = instance.getId();
        if (id != null) {
            BeanLock lock = this.container.getLockManager().getLock(id);
            try {
                lock.sync();
                if (this.canPassivate(instance)) {
                    try {
                        this.remove(id);
                        EntityEnterpriseContext entity = (EntityEnterpriseContext)instance;
                        this.container.getPersistenceManager().passivateEntity(entity);
                        this.container.getInstancePool().free(instance);
                    }
                    catch (Exception ignored) {
                        log.warn((Object)("failed to passivate, id=" + id), (Throwable)ignored);
                    }
                } else {
                    log.warn((Object)("Unable to passivate due to ctx lock, id=" + id));
                }
            }
            finally {
                lock.releaseSync();
                this.container.getLockManager().removeLockRef(id);
            }
        }
    }

    protected boolean canPassivate(EnterpriseContext ctx) {
        if (ctx.isLocked()) {
            return false;
        }
        if (ctx.getTransaction() != null) {
            return false;
        }
        Object key = ((EntityEnterpriseContext)ctx).getCacheKey();
        return this.container.getLockManager().canPassivate(key);
    }

    private Map getLocalCache() {
        return (Map)this.txLocalCache.get();
    }
}

