/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterUtil {
    protected static Log m_log = LogFactory.getLog(ParameterUtil.class);
    public static final int TYPE_JOB = 1;
    public static final int TYPE_MONITOR = 2;

    public static String getParameterValue(String paramId, OutputNotifyGroupInfo info) {
        String value = null;
        if (info == null) {
            return value;
        }
        if (paramId.equals("FACILITY_ID")) {
            value = info.getFacilityId();
        } else if (paramId.equals("PLUGIN_ID")) {
            value = info.getPluginId();
        } else if (paramId.equals("MONITOR_ID")) {
            value = info.getMonitorId();
        } else if (paramId.equals("MESSAGE_ID")) {
            value = info.getMessageId();
        } else if (paramId.equals("APPLICATION")) {
            value = info.getApplication();
        } else if (paramId.equals("PRIORITY")) {
            value = String.valueOf(info.getPriority());
        } else if (paramId.equals("MESSAGE")) {
            value = info.getMessage();
        } else if (paramId.equals("ORG_MESSAGE")) {
            value = info.getMessageOrg();
        }
        return value;
    }

    public static HashMap<String, String> getSessionParameters(String sessionId) {
        HashMap<String, String> parameters;
        block10: {
            parameters = new HashMap<String, String>();
            Collection collection = null;
            Iterator itr = null;
            JobParamInfoLocal param2 = null;
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("getting parameters of job session... (session_id = " + sessionId + ")"));
            }
            try {
                collection = JobParamInfoUtil.getLocalHome().findBySessionId(sessionId);
                if (collection != null && collection.size() > 0) {
                    for (JobParamInfoLocal param2 : collection) {
                        if (!parameters.containsKey(param2.getParam_id())) {
                            if (m_log.isDebugEnabled()) {
                                m_log.debug((Object)("added parameter. (session_id = " + sessionId + ", param_id = " + param2.getParam_id() + ", value = " + param2.getValue() + ")"));
                            }
                            parameters.put(param2.getParam_id(), param2.getValue());
                            continue;
                        }
                        if (!m_log.isDebugEnabled()) continue;
                        m_log.debug((Object)("duplicated, skipped paramter. (session_id = " + sessionId + ", param_id = " + param2.getParam_id() + ", value = " + param2.getValue() + ")"));
                    }
                }
            }
            catch (FinderException e) {
                if (m_log.isWarnEnabled()) {
                    m_log.debug((Object)("failed to get parameters of job session... (session_id = " + sessionId + ")"), (Throwable)e);
                }
            }
            catch (NamingException e) {
                if (!m_log.isWarnEnabled()) break block10;
                m_log.debug((Object)("failed to get parameters of job session... (session_id = " + sessionId + ")"), (Throwable)e);
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("successful in get parameters of job session... (session_id = " + sessionId + ")"));
        }
        return parameters;
    }

    public static String getJobParameterValue(String sessionId, String paramId) throws FinderException, NamingException {
        String ret = null;
        if (paramId.equals("START_DATE")) {
            JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
            ret = DateFormat.getDateTimeInstance().format(session.getSchedule_date());
        } else if (paramId.equals("SESSION_ID")) {
            ret = sessionId;
        } else if (paramId.equals("TRIGGER_TYPE")) {
            JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
            ret = JobTriggerTypeConstant.typeToString(session.getTrigger_type());
        } else if (paramId.equals("TRIGGER_INFO")) {
            JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
            ret = session.getTrigger_info();
        }
        return ret;
    }

    public static String getSessionParameterValue(String sessionId, String paramId) {
        String value;
        block3: {
            Iterator itr;
            value = null;
            Collection collection = null;
            try {
                collection = JobParamInfoUtil.getLocalHome().findBySessionIdAndParamId(sessionId, paramId);
            }
            catch (FinderException e) {
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (collection == null || collection.size() <= 0 || !(itr = collection.iterator()).hasNext()) break block3;
            JobParamInfoLocal param = (JobParamInfoLocal)itr.next();
            value = param.getValue();
        }
        return value;
    }

    public static String replaceSessionParameterValue(String sessionId, String source) {
        String commandConv;
        String commandOrig;
        block8: {
            HashMap<Object, Object> parameters = new HashMap();
            commandOrig = source;
            commandConv = source;
            if (m_log.isDebugEnabled()) {
                m_log.debug((Object)("generating command string... (session_id = " + sessionId + ", command_orig = " + commandOrig + ")"));
            }
            if (commandOrig == null && m_log.isWarnEnabled()) {
                m_log.warn((Object)("registed command is invalid. (session_id = " + sessionId + ", command_orig = " + commandOrig + ")"));
            }
            try {
                parameters = ParameterUtil.getSessionParameters(sessionId);
                for (String string : parameters.keySet()) {
                    if (parameters.get(string) != null) {
                        if (m_log.isDebugEnabled()) {
                            m_log.debug((Object)("replace parameter. (session_id = " + sessionId + ", command_orig = " + commandOrig + ", parameter = " + string + ", value = " + (String)parameters.get(string) + ")"));
                        }
                        commandConv = commandConv.replace("${" + string + "}", (CharSequence)parameters.get(string));
                        continue;
                    }
                    if (!m_log.isDebugEnabled()) continue;
                    m_log.debug((Object)("skip replace parameter (undef). (session_id = " + sessionId + ", command_orig = " + commandOrig + ", parameter = " + string + ")"));
                }
            }
            catch (Exception e) {
                if (!m_log.isWarnEnabled()) break block8;
                m_log.warn((Object)("failed to replace parameter. (session_id = " + sessionId + ", command_orig = " + commandOrig + ")"), (Throwable)e);
            }
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug((Object)("successful in generating command string... (session_id = " + sessionId + ", command_orig = " + commandOrig + ", command_conv = " + commandConv + ")"));
        }
        return commandConv;
    }

    public static int checkFunctionType(String paramId) {
        int ret = 0;
        if (paramId.equals("START_DATE") || paramId.equals("SESSION_ID") || paramId.equals("TRIGGER_TYPE") || paramId.equals("TRIGGER_INFO")) {
            ret = 1;
        } else if (paramId.equals("FACILITY_ID") || paramId.equals("PLUGIN_ID") || paramId.equals("MONITOR_ID") || paramId.equals("MESSAGE_ID") || paramId.equals("APPLICATION") || paramId.equals("PRIORITY") || paramId.equals("MESSAGE") || paramId.equals("ORG_MESSAGE")) {
            ret = 2;
        }
        return ret;
    }
}

