/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sblim.wbem.http.HttpClient;

public class KeepAliveInputStream
extends FilterInputStream {
    HttpClient iClient;

    public KeepAliveInputStream(InputStream is, HttpClient client) {
        super(is);
        this.iClient = client;
    }

    public int read() throws IOException {
        int i = super.read();
        if (i == -1 && this.iClient != null) {
            this.iClient.streamFinished();
            this.iClient = null;
        }
        return i;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int i = super.read(buf, off, len);
        if (i == -1 && this.iClient != null) {
            this.iClient.streamFinished();
            this.iClient = null;
        }
        return i;
    }

    public long skip(long len) throws IOException {
        long i = super.skip(len);
        if (i == -1L && this.iClient != null) {
            this.iClient.streamFinished();
            this.iClient = null;
        }
        return i;
    }

    public void close() throws IOException {
        super.close();
        if (this.iClient != null) {
            this.iClient.streamFinished();
            this.iClient = null;
        }
    }
}

