/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.accesscontrol.util.TimeKeeper;
import com.clustercontrol.accesscontrol.util.TimeKeeperService;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class LdapConnectionManager {
    protected static Log m_log;
    private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    private static final String OBJECT_NAME = "user:name=TroubleDetection,service=TroubleDetectionService";
    private static final String OPERATION_NAME = "putMessage";
    private static final String LDAP_PROVIDER_CONNECT_INTERVAL_KEY = "common.ldap.reconnect.interval";
    private static final int PROVIDER_CONNECT_INTERVAL_DEFAULT = 60000;
    private static int PROVIDER_CONNECT_INTERVAL;
    private static final String LDAP_RECONNECT_RETRIES_KEY = "common.ldap.reconnect.retries";
    private static final int RECONNECT_MAX_DEFAULT = 5;
    private static int RECONNECT_MAX;
    private static boolean m_provider;
    private static boolean m_consumer;
    private static long m_conenctTime;
    private static String m_outputLog;
    private static LdapConnectionManager m_instance;

    public static LdapConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new LdapConnectionManager();
        }
        return m_instance;
    }

    private LdapConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext getDirContext() {
        DirContext ctx;
        boolean consumer;
        boolean provider;
        block19: {
            provider = false;
            consumer = false;
            LdapConnectionManager ldapConnectionManager = this;
            synchronized (ldapConnectionManager) {
                long diff = System.currentTimeMillis() - m_conenctTime;
                if (diff >= (long)PROVIDER_CONNECT_INTERVAL) {
                    provider = true;
                    m_conenctTime = System.currentTimeMillis();
                    m_log.debug((Object)"getDirContext() : LDAP ReConnect");
                } else {
                    provider = m_provider;
                }
                consumer = m_consumer;
            }
            ctx = null;
            try {
                if (!provider) {
                    throw new NamingException();
                }
                ctx = this.getDirContext("external/hinemos/ldap/provider");
                if (consumer) {
                    this.outputLog("LDAP03", "001");
                }
                provider = true;
                consumer = false;
            }
            catch (NamingException e) {
                try {
                    ctx = this.getDirContext("external/hinemos/ldap/consumer");
                }
                catch (NamingException e1) {
                    // empty catch block
                }
                if (ctx == null) break block19;
                if (provider && !consumer) {
                    this.outputLog("LDAP02", "001");
                }
                provider = false;
                consumer = true;
            }
        }
        if (ctx == null) {
            AplLogger apllog = new AplLogger("REP", "rep");
            apllog.put("SYS", "001");
            if (provider) {
                this.outputLog("LDAP02", "002");
            } else {
                this.outputLog("LDAP03", "002");
            }
            provider = false;
            consumer = false;
        } else {
            m_log.debug((Object)"getDirContext() : Get LDAP Connection");
        }
        LdapConnectionManager ldapConnectionManager = this;
        synchronized (ldapConnectionManager) {
            m_provider = provider;
            m_consumer = consumer;
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext getDirContext(String jndiName) throws NamingException {
        InitialLdapContext ctx = null;
        for (int i = 0; i < RECONNECT_MAX; ++i) {
            TimeKeeper timer = TimeKeeperService.start();
            try {
                m_log.debug((Object)("getDirContext() : LDAP Connect " + jndiName));
                InitialContext iniCtx = new InitialContext();
                ctx = (InitialLdapContext)iniCtx.lookup(jndiName);
                if (ctx == null) continue;
                break;
            }
            catch (NamingException e) {
                m_log.error((Object)("getDirContext() : LDAP Connection Error " + jndiName + " : " + e.getMessage()), (Throwable)e);
                continue;
            }
            finally {
                Thread.currentThread();
                Thread.interrupted();
                TimeKeeperService.stop(timer);
            }
        }
        if (ctx == null) {
            throw new NamingException();
        }
        return ctx;
    }

    public void setDirContext(DirContext ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputLog(String monitorId, String messageId) {
        String string = m_outputLog;
        synchronized (string) {
            String outputLog = monitorId + messageId;
            if (outputLog.equals("LDAP02002")) {
                m_outputLog = outputLog;
            } else if (outputLog.equals("LDAP03002")) {
                m_outputLog = outputLog;
            } else if (outputLog.equals(m_outputLog)) {
                return;
            }
        }
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object[] args = new Object[]{monitorId, messageId};
            String[] signature = new String[]{String.class.getName(), String.class.getName()};
            server.invoke(name, OPERATION_NAME, args, signature);
        }
        catch (NamingException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (IOException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
    }

    static {
        block20: {
            m_log = LogFactory.getLog(LdapConnectionManager.class);
            PROVIDER_CONNECT_INTERVAL = 60000;
            RECONNECT_MAX = 5;
            m_provider = true;
            m_consumer = false;
            m_conenctTime = System.currentTimeMillis();
            m_outputLog = "";
            m_instance = null;
            Properties properties = new Properties();
            String etcdir = System.getProperty("hinemos.manager.etc.dir");
            String propertyFile = etcdir + File.separator + "hinemos.properties";
            PROVIDER_CONNECT_INTERVAL = 60000;
            RECONNECT_MAX = 5;
            try {
                block19: {
                    properties.load(new FileInputStream(propertyFile));
                    if (properties.containsKey(LDAP_PROVIDER_CONNECT_INTERVAL_KEY)) {
                        try {
                            PROVIDER_CONNECT_INTERVAL = Integer.parseInt(properties.getProperty(LDAP_PROVIDER_CONNECT_INTERVAL_KEY));
                            if (PROVIDER_CONNECT_INTERVAL <= 0) {
                                if (m_log.isWarnEnabled()) {
                                    m_log.warn((Object)("invalid ldap reconnect interval. (common.ldap.reconnect.interval=" + properties.getProperty(LDAP_PROVIDER_CONNECT_INTERVAL_KEY) + ")"));
                                }
                                PROVIDER_CONNECT_INTERVAL = 60000;
                            }
                            break block19;
                        }
                        catch (NumberFormatException e) {
                            if (m_log.isWarnEnabled()) {
                                m_log.warn((Object)("invalid ldap reconnect interval. (common.ldap.reconnect.interval=" + properties.getProperty(LDAP_PROVIDER_CONNECT_INTERVAL_KEY) + ")"), (Throwable)e);
                            }
                            break block19;
                        }
                    }
                    if (m_log.isInfoEnabled()) {
                        m_log.info((Object)"ldap reconnect interval is not defined. (common.ldap.reconnect.interval)");
                    }
                }
                if (properties.containsKey(LDAP_RECONNECT_RETRIES_KEY)) {
                    try {
                        RECONNECT_MAX = Integer.parseInt(properties.getProperty(LDAP_RECONNECT_RETRIES_KEY));
                        if (RECONNECT_MAX < 0) {
                            if (m_log.isWarnEnabled()) {
                                m_log.warn((Object)("invalid ldap retry count. (common.ldap.reconnect.retries=" + properties.getProperty(LDAP_RECONNECT_RETRIES_KEY) + ")"));
                            }
                            RECONNECT_MAX = 5;
                        }
                        break block20;
                    }
                    catch (NumberFormatException e) {
                        if (m_log.isWarnEnabled()) {
                            m_log.warn((Object)("invalid ldap retry count. (common.ldap.reconnect.retries=" + properties.getProperty(LDAP_RECONNECT_RETRIES_KEY) + ")"), (Throwable)e);
                        }
                        break block20;
                    }
                }
                if (m_log.isInfoEnabled()) {
                    m_log.info((Object)"ldap retry count is not defined. (common.ldap.reconnect.retries)");
                }
            }
            catch (FileNotFoundException e) {
                if (m_log.isWarnEnabled()) {
                    m_log.warn((Object)("file not found. (" + propertyFile + ")"), (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!m_log.isWarnEnabled()) break block20;
                m_log.warn((Object)("failed to load a file. (" + propertyFile + ")"), (Throwable)e);
            }
        }
        if (m_log.isInfoEnabled()) {
            m_log.info((Object)("configured ldap reconnect interval. (" + PROVIDER_CONNECT_INTERVAL + " [msec])"));
            m_log.info((Object)("configured ldap retry count. (" + RECONNECT_MAX + " [retries])"));
        }
    }
}

